/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks.server.docker;

import ai.digital.integration.server.common.constant.ProductName;
import ai.digital.integration.server.common.domain.Server;
import ai.digital.integration.server.common.util.DockerComposeUtil;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import java.io.File;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0011\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\b\u0010\n\u001a\u00020\u000bH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lai/digital/integration/server/deploy/tasks/server/docker/DockerBasedStopDeployTask;", "Lorg/gradle/api/DefaultTask;", "execOperations", "Lorg/gradle/process/ExecOperations;", "<init>", "(Lorg/gradle/process/ExecOperations;)V", "getDockerComposeFile", "Ljava/io/File;", "server", "Lai/digital/integration/server/common/domain/Server;", "run", "", "Companion", "integration-server-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nDockerBasedStopDeployTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerBasedStopDeployTask.kt\nai/digital/integration/server/deploy/tasks/server/docker/DockerBasedStopDeployTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,49:1\n1869#2,2:50\n*S KotlinDebug\n*F\n+ 1 DockerBasedStopDeployTask.kt\nai/digital/integration/server/deploy/tasks/server/docker/DockerBasedStopDeployTask\n*L\n37#1:50,2\n*E\n"})
public class DockerBasedStopDeployTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExecOperations execOperations;
    @NotNull
    public static final String NAME = "dockerBasedStopDeploy";

    @Inject
    public DockerBasedStopDeployTask(@NotNull ExecOperations execOperations) {
        Intrinsics.checkNotNullParameter((Object)execOperations, (String)"execOperations");
        this.execOperations = execOperations;
        Object[] objectArray = new Object[]{"prepareDeploy"};
        this.dependsOn(objectArray);
        this.setGroup("Integration Server");
        this.onlyIf(new Spec(){

            public final boolean isSatisfiedBy(Task it) {
                Project project = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                return DeployServerUtil.Companion.isDockerBased(project);
            }
        });
    }

    @InputFiles
    @NotNull
    public final File getDockerComposeFile(@NotNull Server server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        File file = DeployServerUtil.Companion.getResolvedDockerFile(project, server).toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        return file;
    }

    @TaskAction
    public final void run() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Iterable $this$forEach$iv = DeployServerUtil.Companion.getServers(project);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Server server = (Server)element$iv;
            boolean bl = false;
            this.getProject().getLogger().lifecycle("Stopping Deploy Server from a docker image " + DeployServerUtil.Companion.getDockerImageVersion(server));
            Project project2 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            DockerComposeUtil.Companion.allowToCleanMountedFiles(project2, ProductName.DEPLOY, server, this.getDockerComposeFile(server));
            this.execOperations.exec(new Action(this, server){
                final /* synthetic */ DockerBasedStopDeployTask this$0;
                final /* synthetic */ Server $server;
                {
                    this.this$0 = $receiver;
                    this.$server = $server;
                }

                public final void execute(ExecSpec $this$exec) {
                    Intrinsics.checkNotNullParameter((Object)$this$exec, (String)"$this$exec");
                    $this$exec.setExecutable("docker-compose");
                    Object[] objectArray = new String[]{"-f", this.this$0.getDockerComposeFile(this.$server).getPath(), "down", "-v"};
                    $this$exec.setArgs((List)CollectionsKt.arrayListOf((Object[])objectArray));
                }
            });
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lai/digital/integration/server/deploy/tasks/server/docker/DockerBasedStopDeployTask$Companion;", "", "<init>", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

