/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks.server;

import ai.digital.integration.server.common.domain.Server;
import ai.digital.integration.server.common.util.DbUtil;
import ai.digital.integration.server.common.util.InfrastructureUtil;
import ai.digital.integration.server.common.util.ProcessUtil;
import ai.digital.integration.server.deploy.domain.Worker;
import ai.digital.integration.server.deploy.internals.CentralConfigurationServerUtil;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import ai.digital.integration.server.deploy.internals.DeployShutdownUtil;
import ai.digital.integration.server.deploy.internals.EnvironmentUtil;
import ai.digital.integration.server.deploy.internals.SatelliteUtil;
import ai.digital.integration.server.deploy.internals.WorkerUtil;
import ai.digital.integration.server.deploy.tasks.server.DownloadAndExtractServerDistTask;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;
import org.gradle.kotlin.dsl.GroovyInteroperabilityKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0016\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\u000f\u001a\u00020\tH\u0002J\b\u0010\u0010\u001a\u00020\tH\u0002J\b\u0010\u0011\u001a\u00020\tH\u0007\u00a8\u0006\u0013"}, d2={"Lai/digital/integration/server/deploy/tasks/server/StartDeployServerInstanceTask;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "getBinDir", "Ljava/io/File;", "server", "Lai/digital/integration/server/common/domain/Server;", "runWithPreviousInstallation", "", "startServer", "Ljava/lang/Process;", "hasToBeStartedFromClasspath", "", "start", "maybeTearDown", "allowToWriteMountedHostFolders", "launch", "Companion", "integration-server-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nStartDeployServerInstanceTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StartDeployServerInstanceTask.kt\nai/digital/integration/server/deploy/tasks/server/StartDeployServerInstanceTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,205:1\n1869#2,2:206\n774#2:208\n865#2,2:209\n1869#2,2:211\n*S KotlinDebug\n*F\n+ 1 StartDeployServerInstanceTask.kt\nai/digital/integration/server/deploy/tasks/server/StartDeployServerInstanceTask\n*L\n170#1:206,2\n193#1:208\n193#1:209,2\n194#1:211,2\n*E\n"})
public class StartDeployServerInstanceTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "startDeployServerInstance";

    public StartDeployServerInstanceTask() {
        this.setGroup("Integration Server");
        Object[] objectArray = new String[15];
        objectArray[0] = "applicationConfigurationOverride";
        objectArray[1] = "centralConfiguration";
        objectArray[2] = "checkUILibVersions";
        objectArray[3] = "copyCliBuildArtifacts";
        objectArray[4] = "copyServerFolders";
        objectArray[5] = "copyServerBuildArtifacts";
        objectArray[6] = "serverCopyOverlays";
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        objectArray[7] = DbUtil.Companion.isDerby(project) ? "derbyStart" : "databaseStart";
        objectArray[8] = DownloadAndExtractServerDistTask.Companion.getNAME();
        objectArray[9] = "prepareDatabase";
        objectArray[10] = "prepareDeploy";
        objectArray[11] = "setLogbackLevels";
        objectArray[12] = "startMq";
        objectArray[13] = "startCache";
        objectArray[14] = "serverYamlPatch";
        List dependencies = CollectionsKt.mutableListOf((Object[])objectArray);
        this.configure(GroovyInteroperabilityKt.closureOf((Object)((Object)this), arg_0 -> StartDeployServerInstanceTask._init_$lambda$0(dependencies, arg_0)));
    }

    private final File getBinDir(Server server) {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        String[] stringArray = new String[]{"bin"};
        return Paths.get(DeployServerUtil.Companion.getServerWorkingDir(project, server), stringArray).toFile();
    }

    private final void runWithPreviousInstallation(Server server) {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Server previousServer = DeployServerUtil.Companion.getPreviousInstallationServer(project);
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        String workDir = DeployServerUtil.Companion.getServerWorkingDir(project2, previousServer);
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
        File logFile = Paths.get(DeployServerUtil.Companion.getLogDir(project3, server) + "/deployit.log", new String[0]).toFile();
        this.getProject().getLogger().lifecycle("Initializing Deploy with previous installation from " + workDir);
        Pair[] pairArray = new Pair[5];
        pairArray[0] = TuplesKt.to((Object)"command", (Object)"run");
        Project project4 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"getProject(...)");
        pairArray[1] = TuplesKt.to((Object)"environment", EnvironmentUtil.Companion.getServerEnv(project4, server));
        Object[] objectArray = new String[]{"-setup", "-previous-installation", workDir, "-force-upgrades"};
        pairArray[2] = TuplesKt.to((Object)"params", (Object)CollectionsKt.listOf((Object[])objectArray));
        File file = this.getBinDir(server);
        Intrinsics.checkNotNull((Object)file);
        pairArray[3] = TuplesKt.to((Object)"workDir", (Object)file);
        pairArray[4] = TuplesKt.to((Object)"wait", (Object)true);
        Map map = MapsKt.mapOf((Pair[])pairArray);
        Intrinsics.checkNotNull((Object)logFile);
        ProcessUtil.Companion.execAndCheck(map, logFile);
    }

    private final Process startServer(Server server) {
        File file;
        this.getProject().getLogger().lifecycle("Launching server");
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Map<String, String> environment = EnvironmentUtil.Companion.getServerEnv(project, server);
        this.getProject().getLogger().info("Starting server with environment: " + environment);
        Pair[] pairArray = new Pair[6];
        pairArray[0] = TuplesKt.to((Object)"command", (Object)"run");
        pairArray[1] = TuplesKt.to((Object)"discardIO", (Object)(server.getStdoutFileName() == null ? 1 : 0));
        if (server.getStdoutFileName() != null) {
            Project project2 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            file = new File(DeployServerUtil.Companion.getLogDir(project2, server) + "/" + server.getStdoutFileName());
        } else {
            file = null;
        }
        pairArray[2] = TuplesKt.to((Object)"redirectTo", (Object)file);
        pairArray[3] = TuplesKt.to((Object)"environment", environment);
        pairArray[4] = TuplesKt.to((Object)"params", (Object)CollectionsKt.listOf((Object)"-force-upgrades"));
        pairArray[5] = TuplesKt.to((Object)"workDir", (Object)this.getBinDir(server));
        Map map = MapsKt.mapOf((Pair[])pairArray);
        Process process = ProcessUtil.Companion.exec(map);
        this.getProject().getLogger().lifecycle("Launched server on PID [" + process.pid() + "] with command [" + process.info().commandLine().orElse("") + "].");
        return process;
    }

    private final boolean hasToBeStartedFromClasspath(Server server) {
        return server.getRuntimeDirectory() != null;
    }

    private final Process start(Server server) {
        Process process;
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (!DeployServerUtil.Companion.isDockerBased(project)) {
            this.maybeTearDown();
            if (this.hasToBeStartedFromClasspath(server)) {
                Project project2 = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                process = DeployServerUtil.Companion.startServerFromClasspath(project2);
            } else {
                Project project3 = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
                if (DeployServerUtil.Companion.isPreviousInstallationServerDefined(project3)) {
                    this.runWithPreviousInstallation(server);
                }
                process = this.startServer(server);
            }
        } else {
            Project project4 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"getProject(...)");
            DeployServerUtil.Companion.runDockerBasedInstance(project4, server);
            process = null;
        }
        return process;
    }

    private final void maybeTearDown() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Server server = DeployServerUtil.Companion.getServer(project);
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        DeployShutdownUtil.Companion.shutdownServer(project2);
        this.getProject().getLogger().lifecycle("Forcefully cleaning up any processes on server ports");
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
        DeployShutdownUtil.Companion.killProcessByPort(project3, server.getHttpPort());
        Integer n = server.getDebugPort();
        if (n != null) {
            int debugPort = ((Number)n).intValue();
            boolean bl = false;
            Project project4 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"getProject(...)");
            DeployShutdownUtil.Companion.killProcessByPort(project4, debugPort);
        }
        Project project5 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project5, (String)"getProject(...)");
        if (WorkerUtil.Companion.hasWorkers(project5)) {
            Project project6 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project6, (String)"getProject(...)");
            Iterable $this$forEach$iv = WorkerUtil.Companion.getWorkers(project6);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Worker worker = (Worker)element$iv;
                boolean bl = false;
                try {
                    Integer workerPort = StringsKt.toIntOrNull((String)worker.getPort());
                    if (workerPort != null) {
                        Project project7 = this.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project7, (String)"getProject(...)");
                        DeployShutdownUtil.Companion.killProcessByPort(project7, workerPort);
                    }
                    Integer n2 = worker.getDebugPort();
                    if (n2 != null) {
                        int debugPort = ((Number)n2).intValue();
                        boolean bl2 = false;
                        Project project8 = this.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project8, (String)"getProject(...)");
                        DeployShutdownUtil.Companion.killProcessByPort(project8, debugPort);
                    }
                }
                catch (Exception e) {
                    this.getProject().getLogger().warn("Failed to cleanup worker port: " + e.getMessage());
                }
            }
        }
    }

    private final void allowToWriteMountedHostFolders() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        DeployServerUtil.Companion.grantPermissionsToIntegrationServerFolder(project);
    }

    /*
     * Unable to fully structure code
     */
    @TaskAction
    public final void launch() {
        v0 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getProject(...)");
        $this$filter$iv = DeployServerUtil.Companion.getServers(v0);
        $i$f$filter = false;
        var3_3 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            server = (Server)element$iv$iv;
            $i$a$-filter-StartDeployServerInstanceTask$launch$1 = false;
            if (!server.getPreviousInstallation()) ** GOTO lbl-1000
            v1 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getProject(...)");
            if (DeployServerUtil.Companion.isDockerBased(v1)) lbl-1000:
            // 2 sources

            {
                v2 = true;
            } else {
                v2 = false;
            }
            if (!v2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$forEach$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (E element$iv : $this$forEach$iv) {
            server = (Server)element$iv;
            $i$a$-forEach-StartDeployServerInstanceTask$launch$2 = false;
            this.getProject().getLogger().lifecycle("About to launch Deploy Server " + server.getName() + " on port " + server.getHttpPort() + ".");
            this.allowToWriteMountedHostFolders();
            process = this.start(server);
            v3 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getProject(...)");
            DeployServerUtil.Companion.waitForBoot$default(DeployServerUtil.Companion, v3, process, server, false, 8, null);
            v4 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getProject(...)");
            if (!DeployServerUtil.Companion.isDockerBased(v4) || !server.getPreviousInstallation()) continue;
            v5 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getProject(...)");
            DeployServerUtil.Companion.stopDockerContainer(v5, server);
        }
    }

    private static final Unit _init_$lambda$0(List $dependencies, StartDeployServerInstanceTask $this$closureOf) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$closureOf), (String)"$this$closureOf");
        Project project = $this$closureOf.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (DeployServerUtil.Companion.isTls(project)) {
            $dependencies.add("tlsApplicationConfigurationOverride");
        }
        Project project2 = $this$closureOf.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        if (DeployServerUtil.Companion.isPekkoSecured(project2)) {
            $dependencies.add("generateSecurePekkoKeys");
        }
        Project project3 = $this$closureOf.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
        if (InfrastructureUtil.Companion.hasInfrastructures(project3)) {
            $dependencies.add("infrastructureStart");
        }
        Project project4 = $this$closureOf.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"getProject(...)");
        if (CentralConfigurationServerUtil.Companion.hasCentralConfigurationServer(project4)) {
            $dependencies.add("startCentralConfigurationServer");
        }
        Object[] objectArray = new Object[]{$dependencies};
        $this$closureOf.dependsOn(objectArray);
        Project project5 = $this$closureOf.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project5, (String)"getProject(...)");
        if (!DeployServerUtil.Companion.isDockerBased(project5)) {
            Project project6 = $this$closureOf.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project6, (String)"getProject(...)");
            if (WorkerUtil.Companion.hasWorkers(project6)) {
                objectArray = new Object[]{"startWorkers"};
                $this$closureOf.finalizedBy(objectArray);
            }
            Project project7 = $this$closureOf.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project7, (String)"getProject(...)");
            if (SatelliteUtil.Companion.hasSatellites(project7)) {
                objectArray = new Object[]{"startSatellite"};
                $this$closureOf.finalizedBy(objectArray);
            }
        }
        objectArray = new Object[]{"importDbUnitData"};
        $this$closureOf.finalizedBy(objectArray);
        objectArray = new Object[]{"runDevOpsAsCode"};
        $this$closureOf.finalizedBy(objectArray);
        objectArray = new Object[]{"runDatasetGeneration"};
        $this$closureOf.finalizedBy(objectArray);
        objectArray = new Object[]{"runCli"};
        $this$closureOf.finalizedBy(objectArray);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lai/digital/integration/server/deploy/tasks/server/StartDeployServerInstanceTask$Companion;", "", "<init>", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

