/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks.server;

import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import de.vandermeer.asciitable.AsciiTable;
import de.vandermeer.skb.interfaces.transformers.textformat.TextAlignment;
import groovy.json.JsonSlurper;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.io.IOUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;
import org.gradle.kotlin.dsl.GroovyInteroperabilityKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J&\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002JB\u0010\u0010\u001a\u0018\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u000b\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\t2\u001a\u0010\u0013\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u000b0\u0011H\u0002J2\u0010\u0014\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u000b0\u00112\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0011H\u0002J8\u0010\u0019\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u000b0\u00112\u001a\u0010\u001a\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u000b0\u0011H\u0002J$\u0010\u001b\u001a\u00020\t2\u001a\u0010\u001c\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u000b0\u0011H\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0007\u00a8\u0006 "}, d2={"Lai/digital/integration/server/deploy/tasks/server/CheckUILibVersionsTask;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "parseVersions", "", "stream", "Ljava/util/zip/ZipInputStream;", "parsePluginName", "", "extractPluginMetadata", "", "xldpZip", "Ljava/util/zip/ZipFile;", "internalJarEntry", "Ljava/util/zip/ZipEntry;", "checkForMismatch", "", "libName", "plugins", "collectPluginMetadata", "project", "Lorg/gradle/api/Project;", "files", "Ljava/io/File;", "findMismatches", "metadata", "formatErrorMessage", "mismatches", "check", "", "Companion", "integration-server-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nCheckUILibVersionsTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CheckUILibVersionsTask.kt\nai/digital/integration/server/deploy/tasks/server/CheckUILibVersionsTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,193:1\n1563#2:194\n1634#2,3:195\n1374#2:198\n1460#2,5:199\n774#2:204\n865#2,2:205\n1563#2:207\n1634#2,3:208\n774#2:211\n865#2,2:212\n1374#2:214\n1460#2,5:215\n1563#2:220\n1634#2,3:221\n774#2:224\n865#2,2:225\n1869#2:227\n1869#2,2:228\n1870#2:230\n*S KotlinDebug\n*F\n+ 1 CheckUILibVersionsTask.kt\nai/digital/integration/server/deploy/tasks/server/CheckUILibVersionsTask\n*L\n83#1:194\n83#1:195,3\n94#1:198\n94#1:199,5\n108#1:204\n108#1:205,2\n110#1:207\n110#1:208,3\n127#1:211\n127#1:212,2\n133#1:214\n133#1:215,5\n138#1:220\n138#1:221,3\n147#1:224\n147#1:225,2\n156#1:227\n160#1:228,2\n156#1:230\n*E\n"})
public class CheckUILibVersionsTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "checkUILibVersions";

    public CheckUILibVersionsTask() {
        this.setGroup("Integration Server");
        Object[] objectArray = new String[]{"serverCopyOverlays", "copyServerBuildArtifacts"};
        List dependencies = CollectionsKt.listOf((Object[])objectArray);
        this.configure(GroovyInteroperabilityKt.closureOf((Object)((Object)this), arg_0 -> CheckUILibVersionsTask._init_$lambda$1(dependencies, arg_0)));
    }

    private final Object parseVersions(ZipInputStream stream) {
        JsonSlurper jsonSlurper = new JsonSlurper();
        return jsonSlurper.parse(IOUtils.toByteArray((InputStream)stream));
    }

    private final String parsePluginName(ZipInputStream stream) {
        String string;
        Object v1;
        String prefix;
        block3: {
            prefix = "plugin=";
            String string2 = IOUtils.toString((InputStream)stream, (Charset)Charset.defaultCharset());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            String[] stringArray = new String[]{"\n"};
            Iterable iterable = StringsKt.split$default((CharSequence)string2, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            for (Object t : iterable) {
                String it = (String)t;
                boolean bl = false;
                if (!StringsKt.startsWith$default((String)it, (String)prefix, (boolean)false, (int)2, null)) continue;
                v1 = t;
                break block3;
            }
            v1 = null;
        }
        String string3 = v1;
        if (string3 != null) {
            String string4 = string3.substring(prefix.length());
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
        } else {
            string = null;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<String, Object> extractPluginMetadata(ZipFile xldpZip, ZipEntry internalJarEntry) {
        ZipInputStream zipStream = new ZipInputStream(xldpZip.getInputStream(internalJarEntry));
        Closeable closeable = zipStream;
        Throwable throwable = null;
        try {
            Map map;
            ZipInputStream stream = (ZipInputStream)closeable;
            boolean bl = false;
            ZipEntry entry = stream.getNextEntry();
            String pluginName = null;
            Object versions = null;
            while (entry != null && (pluginName == null || versions == null)) {
                String string = entry.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (StringsKt.endsWith$default((String)string, (String)"-metadata.json", (boolean)false, (int)2, null)) {
                    versions = this.parseVersions(stream);
                }
                if (Intrinsics.areEqual((Object)entry.getName(), (Object)"plugin-version.properties")) {
                    pluginName = this.parsePluginName(stream);
                }
                entry = stream.getNextEntry();
            }
            if (pluginName != null && versions != null) {
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"plugin", pluginName), TuplesKt.to((Object)"versions", (Object)versions)};
                map = MapsKt.mapOf((Pair[])pairArray);
            } else {
                map = MapsKt.emptyMap();
            }
            Map map2 = map;
            return map2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Map<String, Object>> checkForMismatch(String libName, List<? extends Map<String, ? extends Object>> plugins) {
        void $this$flatMapTo$iv$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = plugins;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Map map;
            void plugin;
            Map map2 = (Map)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object v = plugin.get("versions");
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
            Object version = ((Map)v).get(libName);
            if (version != null) {
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"plugin", plugin.get("plugin")), TuplesKt.to((Object)"version", version)};
                map = MapsKt.mapOf((Pair[])pairArray);
            } else {
                map = MapsKt.emptyMap();
            }
            collection.add(map);
        }
        List pluginVersions = (List)destination$iv$iv;
        Iterable $this$flatMap$iv = pluginVersions;
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Map current = (Map)element$iv$iv;
            boolean bl = false;
            Object v = current.get("version");
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.String");
            String version = (String)v;
            Iterable list$iv$iv = SetsKt.setOf((Object)version);
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        Set mismatchSet = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        return mismatchSet.size() > 1 ? pluginVersions : null;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Map<String, Object>> collectPluginMetadata(Project project, List<? extends File> files) {
        Iterable $this$mapTo$iv$iv;
        File file;
        Iterable $this$filterTo$iv$iv;
        project.getLogger().lifecycle("Collecting plugins metadata");
        Iterable $this$filter$iv = files;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            file = (File)element$iv$iv;
            boolean bl = false;
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (!StringsKt.endsWith$default((String)string, (String)".xldp", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Map<String, Object> map;
            void plugin;
            file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            project.getLogger().lifecycle("Extracting plugin's metadata from the plugin " + (File)plugin);
            if (plugin.length() > 0L) {
                Object v4;
                ZipFile xldpZip;
                block6: {
                    xldpZip = new ZipFile((File)plugin);
                    Enumeration<? extends ZipEntry> enumeration = xldpZip.entries();
                    Intrinsics.checkNotNullExpressionValue(enumeration, (String)"entries(...)");
                    ArrayList<? extends ZipEntry> arrayList = Collections.list(enumeration);
                    Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
                    Iterable iterable2 = arrayList;
                    for (Object t : iterable2) {
                        ZipEntry it = (ZipEntry)t;
                        boolean bl2 = false;
                        String string = it.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        if (!StringsKt.endsWith$default((String)string, (String)".jar", (boolean)false, (int)2, null)) continue;
                        v4 = t;
                        break block6;
                    }
                    v4 = null;
                }
                ZipEntry internalJarEntry = v4;
                map = internalJarEntry != null ? this.extractPluginMetadata(xldpZip, internalJarEntry) : MapsKt.emptyMap();
            } else {
                project.getLogger().lifecycle("Skipping the check of " + (File)plugin + " as the content is empty.");
                map = MapsKt.emptyMap();
            }
            collection.add(map);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Map map = (Map)element$iv$iv;
            boolean bl = false;
            boolean bl3 = !map.isEmpty();
            if (!bl3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Map<String, Object>> findMismatches(List<? extends Map<String, ? extends Object>> metadata) {
        void $this$filterTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        Object list$iv$iv;
        Map map;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = metadata;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            map = (Map)element$iv$iv;
            boolean bl = false;
            Object v = map.get("versions");
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
            list$iv$iv = ((Map)v).keySet();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Set allLibs = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$map$iv = allLibs;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Map map2;
            void lib;
            list$iv$iv = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            List<Map<String, Object>> mismatch = this.checkForMismatch((String)lib, metadata);
            if (mismatch != null) {
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"lib", (Object)lib), TuplesKt.to((Object)"versions", mismatch)};
                map2 = MapsKt.mapOf((Pair[])pairArray);
            } else {
                map2 = MapsKt.emptyMap();
            }
            collection.add(map2);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            map = (Map)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !map.isEmpty();
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final String formatErrorMessage(List<? extends Map<String, ? extends Object>> mismatches) {
        AsciiTable table = new AsciiTable();
        table.addRule();
        Object[] objectArray = new Object[]{null, "Version(s) mismatch has been detected"};
        table.addRow(objectArray).setTextAlignment(TextAlignment.CENTER);
        table.addRule();
        Iterable $this$forEach$iv = mismatches;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map current = (Map)element$iv;
            boolean bl = false;
            Object[] objectArray2 = new Object[]{null, current.get("lib")};
            table.addRow(objectArray2).setTextAlignment(TextAlignment.CENTER);
            table.addRule();
            Object v = current.get("versions");
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.collections.Map<kotlin.String, kotlin.Any?>>");
            List versions = (List)v;
            Iterable $this$forEach$iv2 = versions;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Map descriptor = (Map)element$iv2;
                boolean bl2 = false;
                Object[] objectArray3 = new Object[]{descriptor.get("plugin"), descriptor.get("version")};
                table.addRow(objectArray3);
                table.addRule();
            }
        }
        return "/n" + table.render();
    }

    @TaskAction
    public final void check() {
        this.getProject().getLogger().lifecycle("Checking UI Lib Versions on Deploy server");
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Object[] plugins = Paths.get(DeployServerUtil.Companion.getServerWorkingDir(project), new String[0]).resolve("plugins").resolve("xld-official").toFile().listFiles();
        if (plugins != null) {
            Project project2 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            List<Map<String, Object>> metadata = this.collectPluginMetadata(project2, ArraysKt.toList((Object[])plugins));
            List<Map<String, Object>> mismatches = this.findMismatches(metadata);
            if (!((Collection)mismatches).isEmpty()) {
                throw new GradleException(this.formatErrorMessage(mismatches));
            }
        } else {
            this.getProject().getLogger().lifecycle("No plugins have been found on Deploy Server. Skipping checking versions for UI libraries.");
        }
    }

    private static final Unit lambda$1$lambda$0(CheckUILibVersionsTask $this$closureOf) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$closureOf), (String)"$this$closureOf");
        Project project = $this$closureOf.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        DeployServerUtil.Companion.isDockerBased(project);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(List $dependencies, CheckUILibVersionsTask $this$closureOf) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$closureOf), (String)"$this$closureOf");
        Object[] objectArray = new Object[]{$dependencies};
        $this$closureOf.dependsOn(objectArray);
        $this$closureOf.onlyIf(GroovyInteroperabilityKt.closureOf((Object)((Object)$this$closureOf), CheckUILibVersionsTask::lambda$1$lambda$0));
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lai/digital/integration/server/deploy/tasks/server/CheckUILibVersionsTask$Companion;", "", "<init>", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

