/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks.kube.scanning;

import ai.digital.integration.server.common.util.KubeCtlHelper;
import ai.digital.integration.server.common.util.KubeScanningUtil;
import ai.digital.integration.server.common.util.ProcessUtil;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007J\b\u0010\u0006\u001a\u00020\u0005H\u0002J\b\u0010\u0007\u001a\u00020\u0005H\u0002J\b\u0010\b\u001a\u00020\u0005H\u0002J\b\u0010\t\u001a\u00020\u0005H\u0002\u00a8\u0006\u000b"}, d2={"Lai/digital/integration/server/deploy/tasks/kube/scanning/KubeAwsScannerFinalizerTask;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "launch", "", "deleteEksJob", "dockerLogout", "deleteRepository", "deleteDockerImage", "Companion", "integration-server-gradle-plugin"})
public class KubeAwsScannerFinalizerTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "KubeAwsScannerFinalizer";

    @TaskAction
    public final void launch() {
        this.dockerLogout();
        this.deleteRepository();
        this.deleteEksJob();
        this.deleteDockerImage();
    }

    private final void deleteEksJob() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KubeCtlHelper kubeCtlHelper = KubeScanningUtil.Companion.getKubectlHelper(project);
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        kubeCtlHelper.deleteFile(new File(KubeScanningUtil.Companion.getKubeBenchDir(project2) + "/job-eks.yaml"));
    }

    private final void dockerLogout() {
        Project project = this.getProject();
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, project, "docker logout", null, KubeScanningUtil.Companion.getKubeScanner(project2).getLogOutput(), false, 0L, 52, null);
    }

    private final void deleteRepository() {
        Project project = this.getProject();
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        String string = "aws ecr --region " + KubeScanningUtil.Companion.getRegion(project2) + " delete-repository --repository-name k8s/kube-bench --force";
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, project, string, null, KubeScanningUtil.Companion.getKubeScanner(project3).getLogOutput(), false, 0L, 52, null);
    }

    private final void deleteDockerImage() {
        Project project = this.getProject();
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        String string = KubeScanningUtil.Companion.getAWSAccountId(project2);
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
        String string2 = "docker image rm " + string + "/k8s/kube-bench:" + KubeScanningUtil.Companion.getKubeScanner(project3).getKubeBenchTagVersion();
        Project project4 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"getProject(...)");
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, project, string2, null, KubeScanningUtil.Companion.getKubeScanner(project4).getLogOutput(), false, 0L, 52, null);
        Project project5 = this.getProject();
        Project project6 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project6, (String)"getProject(...)");
        String string3 = "docker image rm k8s/kube-bench:" + KubeScanningUtil.Companion.getKubeScanner(project6).getKubeBenchTagVersion();
        Project project7 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project7, (String)"getProject(...)");
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, project5, string3, null, KubeScanningUtil.Companion.getKubeScanner(project7).getLogOutput(), false, 0L, 52, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lai/digital/integration/server/deploy/tasks/kube/scanning/KubeAwsScannerFinalizerTask$Companion;", "", "<init>", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

