/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.util;

import ai.digital.integration.server.common.domain.KubeScanner;
import ai.digital.integration.server.common.util.KubeCtlHelper;
import ai.digital.integration.server.common.util.ProcessUtil;
import ai.digital.integration.server.deploy.internals.DeployExtensionUtil;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.sf.json.JSONObject;
import net.sf.json.util.JSONTokener;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lai/digital/integration/server/common/util/KubeScanningUtil;", "", "<init>", "()V", "Companion", "integration-server-gradle-plugin"})
public final class KubeScanningUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int DEFAULT_RETRY_SLEEP_TIME = 10;
    private static final int DEFAULT_RETRY_TRIES = 3;

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0002J\u000e\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0014\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0015\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nJ\"\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u00172\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u0017J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lai/digital/integration/server/common/util/KubeScanningUtil$Companion;", "", "<init>", "()V", "DEFAULT_RETRY_SLEEP_TIME", "", "DEFAULT_RETRY_TRIES", "getKubeScanningDir", "", "project", "Lorg/gradle/api/Project;", "getKubeBenchDir", "generateReport", "", "fileName", "getKubeScanningReportDir", "Ljava/nio/file/Path;", "getAWSAccountId", "getKubeScanner", "Lai/digital/integration/server/common/domain/KubeScanner;", "getRegion", "buildKubeBench", "getCommand", "", "existingCommand", "getKubectlHelper", "Lai/digital/integration/server/common/util/KubeCtlHelper;", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        private final String getKubeScanningDir(Project project) {
            return ((Directory)project.getLayout().getBuildDirectory().get()).getAsFile().toPath().toAbsolutePath() + "/kube-scanning";
        }

        @NotNull
        public final String getKubeBenchDir(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return ((Object)Paths.get(this.getKubeScanningDir(project) + "/kube-bench", new String[0]).toAbsolutePath()).toString();
        }

        public final void generateReport(@NotNull Project project, @NotNull String fileName) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, "mkdir \"" + this.getKubeScanningReportDir(project).toAbsolutePath() + "\"", null, false, false, 0L, 30, null);
            ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, "cd \"" + this.getKubeScanningReportDir(project).toAbsolutePath() + "\"", null, false, false, 0L, 30, null);
            String kubeBenchPod = ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, project, "kubectl get po | awk '/kube-bench/{print $1}'", null, this.getKubeScanner(project).getLogOutput(), false, 0L, 52, null);
            String status = null;
            int count = 3;
            do {
                status = ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, "kubectl get pods " + kubeBenchPod + " -o 'jsonpath={..status.containerStatuses[0].state.terminated.reason}'", null, false, false, 0L, 30, null);
                TimeUnit.SECONDS.sleep(10L);
            } while (!Intrinsics.areEqual((Object)status, (Object)"Completed") && count-- > 0);
            Object[] objectArray = new String[]{"logs", "pod/" + kubeBenchPod};
            String testReport = ProcessUtil.Companion.execute(project, "kubectl", CollectionsKt.listOf((Object[])objectArray), true);
            FilesKt.writeText$default((File)new File(this.getKubeScanningReportDir(project).toAbsolutePath() + "/" + fileName), (String)testReport, null, (int)2, null);
        }

        private final Path getKubeScanningReportDir(Project project) {
            Path path = Paths.get(this.getKubeScanningDir(project) + "/report", new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            return path;
        }

        @NotNull
        public final String getAWSAccountId(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            String identityDetail = ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, "aws sts get-caller-identity", null, false, false, 0L, 30, null);
            Object object = new JSONTokener(identityDetail).nextValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type net.sf.json.JSONObject");
            JSONObject identity = (JSONObject)object;
            return identity.get("Account") + ".dkr.ecr." + this.getRegion(project) + ".amazonaws.com";
        }

        @NotNull
        public final KubeScanner getKubeScanner(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = DeployExtensionUtil.Companion.getExtension(project).getKubeScanner().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            return (KubeScanner)object;
        }

        @NotNull
        public final String getRegion(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            String string = this.getKubeScanner(project).getAwsRegion();
            if (string == null) {
                throw new RuntimeException("AWS Region has to be explicitly defined");
            }
            return string;
        }

        public final void buildKubeBench(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, project, "docker build -t k8s/kube-bench:" + this.getKubeScanner(project).getKubeBenchTagVersion() + " \"" + this.getKubeBenchDir(project) + "\"", null, this.getKubeScanner(project).getLogOutput(), false, 0L, 52, null);
        }

        @NotNull
        public final List<String> getCommand(@NotNull Project project, @NotNull List<String> existingCommand) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(existingCommand, (String)"existingCommand");
            if (this.getKubeScanner(project).getCommand().size() > 0) {
                existingCommand.addAll((Collection<String>)this.getKubeScanner(project).getCommand());
            }
            return existingCommand;
        }

        @NotNull
        public final KubeCtlHelper getKubectlHelper(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return new KubeCtlHelper(project, null, false, 4, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

