/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.domain;

import ai.digital.integration.server.common.util.TlsUtil;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000  2\u00020\u0001:\u0001 B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u001dJ\u0006\u0010\u001f\u001a\u00020\u001dR\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0005R\u001a\u0010\n\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\u0005R\u001a\u0010\r\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\b\"\u0004\b\u000f\u0010\u0005R\u001a\u0010\u0010\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\b\"\u0004\b\u0012\u0010\u0005R\u001a\u0010\u0013\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\b\"\u0004\b\u0015\u0010\u0005R\u001a\u0010\u0016\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\b\"\u0004\b\u0018\u0010\u0005R\u001a\u0010\u0019\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\b\"\u0004\b\u001b\u0010\u0005\u00a8\u0006!"}, d2={"Lai/digital/integration/server/common/domain/Tls;", "", "serverWorkingDir", "", "<init>", "(Ljava/lang/String;)V", "keyStorePassword", "getKeyStorePassword", "()Ljava/lang/String;", "setKeyStorePassword", "keyPassword", "getKeyPassword", "setKeyPassword", "truststorePassword", "getTruststorePassword", "setTruststorePassword", "trustStoreName", "getTrustStoreName", "setTrustStoreName", "confWorkDirPath", "getConfWorkDirPath", "setConfWorkDirPath", "keyStoreFilePath", "getKeyStoreFilePath", "setKeyStoreFilePath", "trustStoreFilePath", "getTrustStoreFilePath", "setTrustStoreFilePath", "confWorkDir", "Ljava/io/File;", "keyStoreFile", "trustStoreFile", "Companion", "integration-server-gradle-plugin"})
public final class Tls {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String keyStorePassword;
    @NotNull
    private String keyPassword;
    @NotNull
    private String truststorePassword;
    @NotNull
    private String trustStoreName;
    @NotNull
    private String confWorkDirPath;
    @NotNull
    private String keyStoreFilePath;
    @NotNull
    private String trustStoreFilePath;
    @NotNull
    public static final String KEYSTORE_TYPE = "pkcs12";
    @NotNull
    public static final String KEYSTORE_TYPE_EXTENSION = "pk12";
    @NotNull
    public static final String KEY_NAME = "master_tls";
    @NotNull
    public static final String TRUSTSTORE_SUFFIX_NAME = "truststore";

    public Tls(@NotNull String serverWorkingDir) {
        Intrinsics.checkNotNullParameter((Object)serverWorkingDir, (String)"serverWorkingDir");
        this.keyStorePassword = TlsUtil.Companion.generatePassword("smaster_tls");
        this.keyPassword = TlsUtil.Companion.generatePassword("kmaster_tls");
        this.truststorePassword = TlsUtil.Companion.generatePassword("tmaster_tls");
        this.trustStoreName = "master_tls-truststore";
        this.confWorkDirPath = serverWorkingDir + "/conf";
        this.keyStoreFilePath = this.confWorkDir() + "/master_tls.pk12";
        this.trustStoreFilePath = this.confWorkDir() + "/" + this.trustStoreName + ".pk12";
    }

    @NotNull
    public final String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public final void setKeyStorePassword(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.keyStorePassword = string;
    }

    @NotNull
    public final String getKeyPassword() {
        return this.keyPassword;
    }

    public final void setKeyPassword(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.keyPassword = string;
    }

    @NotNull
    public final String getTruststorePassword() {
        return this.truststorePassword;
    }

    public final void setTruststorePassword(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.truststorePassword = string;
    }

    @NotNull
    public final String getTrustStoreName() {
        return this.trustStoreName;
    }

    public final void setTrustStoreName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.trustStoreName = string;
    }

    @NotNull
    public final String getConfWorkDirPath() {
        return this.confWorkDirPath;
    }

    public final void setConfWorkDirPath(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.confWorkDirPath = string;
    }

    @NotNull
    public final String getKeyStoreFilePath() {
        return this.keyStoreFilePath;
    }

    public final void setKeyStoreFilePath(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.keyStoreFilePath = string;
    }

    @NotNull
    public final String getTrustStoreFilePath() {
        return this.trustStoreFilePath;
    }

    public final void setTrustStoreFilePath(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.trustStoreFilePath = string;
    }

    @NotNull
    public final File confWorkDir() {
        return new File(this.confWorkDirPath);
    }

    @NotNull
    public final File keyStoreFile() {
        return new File(this.keyStoreFilePath);
    }

    @NotNull
    public final File trustStoreFile() {
        return new File(this.trustStoreFilePath);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lai/digital/integration/server/common/domain/Tls$Companion;", "", "<init>", "()V", "KEYSTORE_TYPE", "", "KEYSTORE_TYPE_EXTENSION", "KEY_NAME", "TRUSTSTORE_SUFFIX_NAME", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

