/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.cluster.helm;

import ai.digital.integration.server.common.cluster.helm.HelmHelper;
import ai.digital.integration.server.common.cluster.setup.AwsEksHelper;
import ai.digital.integration.server.common.constant.ProductName;
import ai.digital.integration.server.common.domain.profiles.Profile;
import ai.digital.integration.server.common.domain.providers.AwsEksProvider;
import ai.digital.integration.server.common.util.YamlFileUtil;
import java.io.File;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\u000bJ\u0006\u0010\r\u001a\u00020\u000bJ\u0006\u0010\u000e\u001a\u00020\u000bJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0012H\u0016J\u0010\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0012H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lai/digital/integration/server/common/cluster/helm/AwsEksHelmHelper;", "Lai/digital/integration/server/common/cluster/helm/HelmHelper;", "project", "Lorg/gradle/api/Project;", "productName", "Lai/digital/integration/server/common/constant/ProductName;", "<init>", "(Lorg/gradle/api/Project;Lai/digital/integration/server/common/constant/ProductName;)V", "awsEksHelper", "Lai/digital/integration/server/common/cluster/setup/AwsEksHelper;", "launchCluster", "", "helmInstallCluster", "setupHelmValues", "shutdownCluster", "getProvider", "Lai/digital/integration/server/common/domain/providers/AwsEksProvider;", "getStorageClass", "", "getDbStorageClass", "getMqStorageClass", "updateCustomHelmValues", "valuesFile", "Ljava/io/File;", "getFqdn", "integration-server-gradle-plugin"})
public class AwsEksHelmHelper
extends HelmHelper {
    @NotNull
    private final AwsEksHelper awsEksHelper;

    public AwsEksHelmHelper(@NotNull Project project, @NotNull ProductName productName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)productName), (String)"productName");
        super(project, productName);
        this.awsEksHelper = new AwsEksHelper(project, productName, this.getProfile());
    }

    public final void launchCluster() {
        this.awsEksHelper.launchCluster();
    }

    public final void helmInstallCluster() {
        this.installCluster();
        Object object = this.getProfile().getIngressType().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        String string = (String)object;
        Object object2 = this.getProfile().getDeploymentTimeoutSeconds().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        this.waitForDeployment(string, ((Number)object2).intValue(), true);
        Object object3 = this.getProfile().getDeploymentTimeoutSeconds().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
        this.waitForMasterPods(((Number)object3).intValue());
        Object object4 = this.getProfile().getDeploymentTimeoutSeconds().get();
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"get(...)");
        this.waitForWorkerPods(((Number)object4).intValue());
        this.createClusterMetadata();
        this.awsEksHelper.updateRoute53(Profile.Companion.getDEFAULT_NAMESPACE_NAME(), this.getFqdn());
        this.waitForBoot(this.getContextRoot(), this.getFqdn());
    }

    public final void setupHelmValues() {
        this.copyValuesYamlFile();
        this.updateHelmValuesYaml();
        this.updateHelmDependency();
    }

    public final void shutdownCluster() {
        this.helmCleanUpCluster();
        this.getKubectlHelper().deleteAllPVCs();
        this.awsEksHelper.destroyClusterOnShutdown();
    }

    @Override
    @NotNull
    public AwsEksProvider getProvider() {
        return this.getProfile().getAwsEks();
    }

    @Override
    @NotNull
    public String getStorageClass() {
        return this.awsEksHelper.getStorageClass();
    }

    @Override
    @NotNull
    public String getDbStorageClass() {
        return "gp2";
    }

    @Override
    @NotNull
    public String getMqStorageClass() {
        return "gp2";
    }

    @Override
    public void updateCustomHelmValues(@NotNull File valuesFile) {
        Intrinsics.checkNotNullParameter((Object)valuesFile, (String)"valuesFile");
        Pair[] pairArray = new Pair[2];
        String[] stringArray = new String[]{this.getFqdn()};
        pairArray[0] = TuplesKt.to((Object)"ingress.hosts", (Object)stringArray);
        pairArray[1] = TuplesKt.to((Object)"rabbitmq.persistence.storageClass", (Object)"gp2");
        Map pairs = MapsKt.mutableMapOf((Pair[])pairArray);
        YamlFileUtil.Companion.overlayFile$default(YamlFileUtil.Companion, valuesFile, pairs, null, false, 4, null);
    }

    @Override
    @NotNull
    public String getFqdn() {
        return this.awsEksHelper.getFqdn();
    }
}

