/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.util;

import ai.digital.integration.server.common.constant.ProductName;
import ai.digital.integration.server.common.domain.InfrastructureInfo;
import ai.digital.integration.server.common.domain.profiles.Profile;
import ai.digital.integration.server.common.util.ProcessUtil;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.commons.codec.binary.Base64;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b!\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u001e\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u0005J\u000e\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u0005J\u000e\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u0005J\u0010\u0010 \u001a\u00020!2\b\b\u0002\u0010\"\u001a\u00020\u0007J\u0006\u0010#\u001a\u00020\u0011J\u0006\u0010$\u001a\u00020\u0011J\u000e\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u0005J\u000e\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\u0005J\u0006\u0010)\u001a\u00020\u0005J\u0010\u0010*\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\u0005H\u0002J\u000e\u0010,\u001a\u00020\u00052\u0006\u0010-\u001a\u00020\u0005J\u000e\u0010.\u001a\u00020\u00052\u0006\u0010-\u001a\u00020\u0005J\u000e\u0010/\u001a\u00020\u00052\u0006\u00100\u001a\u00020\u0005J\u000e\u00101\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\u0005J\u0018\u0010*\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\u00052\u0006\u00102\u001a\u00020\u0005H\u0002J\u000e\u00103\u001a\u00020\u00052\u0006\u00100\u001a\u00020\u0005J\u0010\u00104\u001a\u00020\u00052\u0006\u00105\u001a\u00020\u0005H\u0002J\u0010\u00106\u001a\u00020\u00052\u0006\u00105\u001a\u00020\u0005H\u0002J\u0018\u00107\u001a\u00020\u00052\u0006\u00108\u001a\u00020\u00052\u0006\u00109\u001a\u00020\u0005H\u0002J\u0018\u0010:\u001a\u00020\u00052\u0006\u0010;\u001a\u00020\u00052\u0006\u0010<\u001a\u00020\u0005H\u0002J\u000e\u0010=\u001a\u00020\u00052\u0006\u0010>\u001a\u00020\u0005J\u000e\u0010?\u001a\u00020\u00052\u0006\u0010@\u001a\u00020\u0005J\u0016\u0010A\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010B\u001a\u00020CJ\u0016\u0010A\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010D\u001a\u00020\u0005J\u000e\u0010A\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0005J\u000e\u0010E\u001a\u00020\u00052\u0006\u0010F\u001a\u00020\u0005J\u000e\u0010G\u001a\u00020\u00052\u0006\u0010F\u001a\u00020\u0005J\u0010\u0010H\u001a\u00020\u00052\u0006\u0010I\u001a\u00020\u0005H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006J"}, d2={"Lai/digital/integration/server/common/util/KubeCtlHelper;", "", "project", "Lorg/gradle/api/Project;", "namespace", "", "isOpenShift", "", "<init>", "(Lorg/gradle/api/Project;Ljava/lang/String;Z)V", "getProject", "()Lorg/gradle/api/Project;", "getNamespace", "()Ljava/lang/String;", "command", "getCommand", "applyFile", "", "file", "Ljava/io/File;", "deleteFile", "wait", "resource", "condition", "timeoutSeconds", "", "savePodLogs", "podName", "setDefaultStorageClass", "newDefaultStorageClass", "hasStorageClass", "storageClass", "getCurrentContextInfo", "Lai/digital/integration/server/common/domain/InfrastructureInfo;", "skip", "deleteCurrentContext", "deleteAllPVCs", "getIngresHost", "ingressName", "getServiceExternalIp", "serviceName", "getCurrentContext", "configView", "jsonPath", "getContextCluster", "contextName", "getContextUser", "getClusterServer", "clusterName", "getServiceClusterIp", "fallbackJsonPath", "getClusterCertificateAuthorityData", "getUserClientKeyData", "userName", "getUserClientCertificateData", "getNameAndGrep", "params", "grepFor", "getWithPath", "subCommand", "jsonpath", "getCrd", "groupName", "getCr", "crdName", "getResourceNames", "productName", "Lai/digital/integration/server/common/constant/ProductName;", "filter", "deleteNames", "names", "clearCrFinalizers", "namespaceWrapper", "kcCommand", "integration-server-gradle-plugin"})
public class KubeCtlHelper {
    @NotNull
    private final Project project;
    @Nullable
    private final String namespace;
    @NotNull
    private final String command;

    public KubeCtlHelper(@NotNull Project project, @Nullable String namespace, boolean isOpenShift) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.namespace = namespace;
        this.command = isOpenShift ? "oc" : "kubectl";
    }

    public /* synthetic */ KubeCtlHelper(Project project, String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(project, string, bl);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final String getNamespace() {
        return this.namespace;
    }

    @NotNull
    public final String getCommand() {
        return this.command;
    }

    public final void applyFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.project, this.namespaceWrapper(this.command + " apply -f \"" + file.getAbsolutePath() + "\""), null, false, false, 0L, 60, null);
    }

    public final void deleteFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.project, this.namespaceWrapper(this.command + " delete -f \"" + file.getAbsolutePath() + "\""), null, false, false, 0L, 60, null);
    }

    public final boolean wait(@NotNull String resource, @NotNull String condition, int timeoutSeconds) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        this.project.getLogger().lifecycle("Waiting for resource " + resource + " to be " + condition);
        long expectedEndTime = System.currentTimeMillis() + (long)(timeoutSeconds * 1000);
        while (expectedEndTime > System.currentTimeMillis()) {
            String result = ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.project, this.namespaceWrapper(this.command + " wait --for condition=" + condition + " --timeout=" + timeoutSeconds + "s " + resource), null, false, false, 0L, 44, null);
            if (StringsKt.contains$default((CharSequence)result, (CharSequence)"condition met", (boolean)false, (int)2, null)) {
                return true;
            }
            Thread.sleep(1000L);
        }
        return false;
    }

    public final void savePodLogs(@NotNull String podName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)podName, (String)"podName");
        if (StringsKt.startsWith$default((String)podName, (String)"pod/", (boolean)false, (int)2, null)) {
            String string2 = podName.substring(4);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = podName;
        }
        String name = string;
        try {
            String logContent = ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.project, this.namespaceWrapper(this.command + " logs " + name), null, false, false, 0L, 52, null);
            File logDir = DeployServerUtil.Companion.getLogDir(this.project);
            File file = new File(logDir, name + ".log");
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            FilesKt.writeText((File)file, (String)logContent, (Charset)charset);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void setDefaultStorageClass(@NotNull String newDefaultStorageClass) {
        Intrinsics.checkNotNullParameter((Object)newDefaultStorageClass, (String)"newDefaultStorageClass");
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.project, this.namespaceWrapper(this.command + " get sc -o name") + "|sed -e 's/.*\\///g' |xargs -I {} " + this.namespaceWrapper(this.command + " patch storageclass {} -p '{\"metadata\": {\"annotations\":{\"storageclass.kubernetes.io/is-default-class\":\"false\"}}}'"), null, false, false, 0L, 60, null);
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.project, this.namespaceWrapper(this.command + " patch storageclass " + newDefaultStorageClass + " -p '{\"metadata\": {\"annotations\":{\"storageclass.kubernetes.io/is-default-class\":\"true\"}}}'"), null, false, false, 0L, 60, null);
    }

    public final boolean hasStorageClass(@NotNull String storageClass) {
        Intrinsics.checkNotNullParameter((Object)storageClass, (String)"storageClass");
        String result = this.getNameAndGrep("storageclass", storageClass);
        return StringsKt.contains$default((CharSequence)result, (CharSequence)storageClass, (boolean)false, (int)2, null);
    }

    @NotNull
    public final InfrastructureInfo getCurrentContextInfo(boolean skip) {
        String context = this.getCurrentContext();
        String cluster = this.getContextCluster(context);
        String user = this.getContextUser(context);
        return new InfrastructureInfo(cluster, user, this.getClusterServer(cluster), this.getClusterCertificateAuthorityData(cluster), !skip ? this.getUserClientCertificateData(user) : null, !skip ? this.getUserClientKeyData(user) : null);
    }

    public static /* synthetic */ InfrastructureInfo getCurrentContextInfo$default(KubeCtlHelper kubeCtlHelper, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getCurrentContextInfo");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        return kubeCtlHelper.getCurrentContextInfo(bl);
    }

    public final void deleteCurrentContext() {
        try {
            String context = this.getCurrentContext();
            String cluster = this.getContextCluster(context);
            String user = this.getContextUser(context);
            Object[] objectArray = new Object[]{context, cluster, user};
            this.project.getLogger().info("Current cluster context is being deleted {} with related cluster {} and user {} information", objectArray);
            KubeCtlHelper.deleteCurrentContext$delete(this, "delete-context " + context);
            KubeCtlHelper.deleteCurrentContext$delete(this, "delete-user " + user);
            KubeCtlHelper.deleteCurrentContext$delete(this, "delete-cluster " + cluster);
        }
        catch (RuntimeException e) {
            this.project.getLogger().info("Skipping delete of current context because: {}", (Object)e.getMessage());
        }
    }

    public final void deleteAllPVCs() {
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.project, this.namespaceWrapper(this.command + " delete pvc --all --grace-period=1"), null, false, false, 0L, 44, null);
    }

    @NotNull
    public final String getIngresHost(@NotNull String ingressName) {
        Intrinsics.checkNotNullParameter((Object)ingressName, (String)"ingressName");
        return this.getWithPath("ing " + ingressName, "{.items[*].spec.rules[*].host}");
    }

    @NotNull
    public final String getServiceExternalIp(@NotNull String serviceName) {
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        return this.getWithPath("get " + serviceName, "{.status.loadBalancer.ingress[*].ip}");
    }

    @NotNull
    public final String getCurrentContext() {
        return ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.project, this.command + " config current-context", null, false, false, 0L, 52, null);
    }

    private final String configView(String jsonPath) {
        return ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.project, this.command + " config view -o jsonpath='" + jsonPath + "' --raw", null, false, false, 0L, 52, null);
    }

    @NotNull
    public final String getContextCluster(@NotNull String contextName) {
        Intrinsics.checkNotNullParameter((Object)contextName, (String)"contextName");
        return this.configView("{.contexts[?(@.name == \"" + contextName + "\")].context.cluster}");
    }

    @NotNull
    public final String getContextUser(@NotNull String contextName) {
        Intrinsics.checkNotNullParameter((Object)contextName, (String)"contextName");
        return this.configView("{.contexts[?(@.name == \"" + contextName + "\")].context.user}");
    }

    @NotNull
    public final String getClusterServer(@NotNull String clusterName) {
        Intrinsics.checkNotNullParameter((Object)clusterName, (String)"clusterName");
        return this.configView("{.clusters[?(@.name == \"" + clusterName + "\")].cluster.server}");
    }

    @NotNull
    public final String getServiceClusterIp(@NotNull String serviceName) {
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        return this.getWithPath("get svc " + serviceName, "{.spec.clusterIP}");
    }

    private final String configView(String jsonPath, String fallbackJsonPath) {
        CharSequence charSequence;
        String data = this.configView(jsonPath);
        CharSequence charSequence2 = data;
        if (charSequence2.length() == 0) {
            boolean bl = false;
            String path = this.configView(fallbackJsonPath);
            byte[] byArray = FilesKt.readText$default((File)new File(path), null, (int)1, null).getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            String string = Base64.encodeBase64String((byte[])byArray);
            charSequence = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeBase64String(...)");
        } else {
            charSequence = charSequence2;
        }
        return (String)charSequence;
    }

    @NotNull
    public final String getClusterCertificateAuthorityData(@NotNull String clusterName) {
        Intrinsics.checkNotNullParameter((Object)clusterName, (String)"clusterName");
        return this.configView("{.clusters[?(@.name == \"" + clusterName + "\")].cluster.certificate-authority-data}", "{.clusters[?(@.name == \"" + clusterName + "\")].cluster.certificate-authority}");
    }

    private final String getUserClientKeyData(String userName) {
        return this.configView("{.users[?(@.name == \"" + userName + "\")].user.client-key-data}", "{.users[?(@.name == \"" + userName + "\")].user.client-key}");
    }

    private final String getUserClientCertificateData(String userName) {
        return this.configView("{.users[?(@.name == \"" + userName + "\")].user.client-certificate-data}", "{.users[?(@.name == \"" + userName + "\")].user.client-certificate}");
    }

    private final String getNameAndGrep(String params, String grepFor) {
        ProcessUtil.Companion companion = ProcessUtil.Companion;
        Project project = this.project;
        String string = this.namespaceWrapper(this.command + " get " + params + " -o name") + " | grep " + grepFor;
        return ProcessUtil.Companion.executeCommand$default(companion, project, string, null, false, false, 0L, 36, null);
    }

    private final String getWithPath(String subCommand, String jsonpath) {
        return ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.project, this.namespaceWrapper(this.command + " " + subCommand + " -o 'jsonpath=" + jsonpath + "'"), null, false, false, 0L, 60, null);
    }

    @NotNull
    public final String getCrd(@NotNull String groupName) {
        Intrinsics.checkNotNullParameter((Object)groupName, (String)"groupName");
        return this.getWithPath("get crd", "{.items[?(@..spec.group == \"" + groupName + "\")].metadata.name}");
    }

    @NotNull
    public final String getCr(@NotNull String crdName) {
        Intrinsics.checkNotNullParameter((Object)crdName, (String)"crdName");
        return this.getWithPath("get " + crdName, "{.items[0].metadata.name}");
    }

    @NotNull
    public final String getResourceNames(@NotNull String resource, @NotNull ProductName productName) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        Intrinsics.checkNotNullParameter((Object)((Object)productName), (String)"productName");
        return this.getResourceNames(resource, productName.getShortName());
    }

    @NotNull
    public final String getResourceNames(@NotNull String resource, @NotNull String filter) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        return ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.project, this.namespaceWrapper(this.command + " get " + resource + " -o name") + " | grep " + filter + " | tr \"\\n\" \" \" | sed -e 's/,$//'", null, false, false, 0L, 36, null);
    }

    @NotNull
    public final String getResourceNames(@NotNull String resource) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        return ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.project, this.namespaceWrapper(this.command + " get " + resource + " -o name"), null, false, false, 0L, 36, null);
    }

    @NotNull
    public final String deleteNames(@NotNull String names) {
        Intrinsics.checkNotNullParameter((Object)names, (String)"names");
        return ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.project, this.namespaceWrapper(this.command + " delete " + names), null, false, false, 0L, 36, null);
    }

    @NotNull
    public final String clearCrFinalizers(@NotNull String names) {
        Intrinsics.checkNotNullParameter((Object)names, (String)"names");
        return ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.project, this.namespaceWrapper(this.command + " patch " + names + " -p '{\"metadata\":{\"finalizers\":[]}}' --type=merge"), null, false, false, 0L, 36, null);
    }

    private final String namespaceWrapper(String kcCommand) {
        String string = this.namespace;
        if (string == null) {
            string = Profile.Companion.getDEFAULT_NAMESPACE_NAME();
        }
        String namespaceOrDefault = string;
        return kcCommand + " --namespace " + namespaceOrDefault;
    }

    private static final void deleteCurrentContext$delete(KubeCtlHelper this$0, String what) {
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this$0.project, this$0.command + " config " + what, null, false, false, 0L, 44, null);
    }
}

