/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.cluster.operator;

import ai.digital.integration.server.common.cluster.Helper;
import ai.digital.integration.server.common.cluster.operator.AwsEksOperatorHelper;
import ai.digital.integration.server.common.cluster.operator.AwsOpenshiftOperatorHelper;
import ai.digital.integration.server.common.cluster.operator.AzureAksOperatorHelper;
import ai.digital.integration.server.common.cluster.operator.GcpGkeOperatorHelper;
import ai.digital.integration.server.common.cluster.operator.OnPremOperatorHelper;
import ai.digital.integration.server.common.cluster.operator.OperatorHelper;
import ai.digital.integration.server.common.cluster.operator.VmwareOpenshiftOperatorHelper;
import ai.digital.integration.server.common.cluster.util.OperatorUtil;
import ai.digital.integration.server.common.constant.OperatorHelmProviderName;
import ai.digital.integration.server.common.constant.ProductName;
import ai.digital.integration.server.common.domain.InfrastructureInfo;
import ai.digital.integration.server.common.domain.Server;
import ai.digital.integration.server.common.domain.profiles.IngressType;
import ai.digital.integration.server.common.domain.profiles.Profile;
import ai.digital.integration.server.common.domain.providers.Provider;
import ai.digital.integration.server.common.util.FileUtil;
import ai.digital.integration.server.common.util.KubeCtlHelper;
import ai.digital.integration.server.common.util.XlCliUtil;
import ai.digital.integration.server.common.util.YamlFileUtil;
import ai.digital.integration.server.deploy.internals.CliUtil;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import ai.digital.integration.server.deploy.internals.cluster.DeployClusterUtil;
import ai.digital.integration.server.release.tasks.cluster.ReleaseClusterUtil;
import ai.digital.integration.server.release.util.ReleaseServerUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.GlobalScope;
import kotlinx.coroutines.InterruptibleKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.TimeoutKt;
import org.apache.commons.io.FileUtils;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\b&\u0018\u0000 U2\u00020\u0001:\u0001UB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u001f\u001a\u00020\u000fJ\u0006\u0010 \u001a\u00020!J\u0006\u0010\"\u001a\u00020!J\b\u0010#\u001a\u00020!H\u0016J\u0006\u0010$\u001a\u00020!J\u0006\u0010%\u001a\u00020!J\b\u0010&\u001a\u00020\u000fH\u0002J\u0006\u0010'\u001a\u00020!J\u0006\u0010(\u001a\u00020!J\u0006\u0010)\u001a\u00020!J\u0006\u0010*\u001a\u00020!J\u0006\u0010+\u001a\u00020,J\n\u0010-\u001a\u0004\u0018\u00010\u000fH\u0016J\u0006\u0010.\u001a\u00020!J\u0006\u0010/\u001a\u00020!J\u0010\u00100\u001a\u00020!2\u0006\u00101\u001a\u000202H&J\b\u00103\u001a\u00020\u000fH\u0016J\u0006\u00104\u001a\u000202J\u0006\u00105\u001a\u000202J\b\u00106\u001a\u00020\u000fH\u0016J\b\u00107\u001a\u00020\u000fH\u0016J\b\u00108\u001a\u00020\u000fH\u0016J\b\u00109\u001a\u00020:H\u0016J\b\u0010;\u001a\u00020\u000fH\u0016J\u0006\u0010<\u001a\u00020\u000fJ\b\u0010=\u001a\u00020\u000fH\u0016J\b\u0010>\u001a\u00020!H\u0016J\u0006\u0010?\u001a\u00020\u000fJ\b\u0010@\u001a\u00020\u000fH&J\b\u0010A\u001a\u00020BH&J\b\u0010C\u001a\u00020DH\u0016J\u000e\u0010E\u001a\u00020!2\u0006\u0010F\u001a\u00020GJ\u000e\u0010H\u001a\u00020!2\u0006\u0010F\u001a\u00020GJ\u001b\u0010I\u001a\u00020\u000f2\f\u0010J\u001a\b\u0012\u0004\u0012\u00020\u000f0KH\u0002\u00a2\u0006\u0002\u0010LJ\u001b\u0010M\u001a\u00020!2\f\u0010J\u001a\b\u0012\u0004\u0012\u00020\u000f0KH\u0002\u00a2\u0006\u0002\u0010NJ4\u0010O\u001a\u00020,2\u0006\u0010P\u001a\u00020\t2\u0006\u0010Q\u001a\u00020R2\u0006\u0010F\u001a\u00020G2\f\u0010J\u001a\b\u0012\u0004\u0012\u00020\u000f0KH\u0082@\u00a2\u0006\u0002\u0010SJ\u001b\u0010T\u001a\u00020!2\f\u0010J\u001a\b\u0012\u0004\u0012\u00020\u000f0KH\u0002\u00a2\u0006\u0002\u0010NR\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0011\u0010\u0014\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0011R\u000e\u0010\u0016\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001c\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0011R\u000e\u0010\u001e\u001a\u00020\u000fX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006V"}, d2={"Lai/digital/integration/server/common/cluster/operator/OperatorHelper;", "Lai/digital/integration/server/common/cluster/Helper;", "project", "Lorg/gradle/api/Project;", "productName", "Lai/digital/integration/server/common/constant/ProductName;", "<init>", "(Lorg/gradle/api/Project;Lai/digital/integration/server/common/constant/ProductName;)V", "loggingJob", "Lkotlinx/coroutines/Job;", "getLoggingJob", "()Lkotlinx/coroutines/Job;", "setLoggingJob", "(Lkotlinx/coroutines/Job;)V", "OPERATOR_INFRASTRUCTURE_PATH", "", "getOPERATOR_INFRASTRUCTURE_PATH", "()Ljava/lang/String;", "OPERATOR_CR_VALUES_FILENAME", "getOPERATOR_CR_VALUES_FILENAME", "OPERATOR_CR_VALUES_REL_PATH", "getOPERATOR_CR_VALUES_REL_PATH", "operatorMetadataPath", "OPERATOR_FOLDER_NAME", "OPERATOR_APPS_REL_PATH", "OPERATOR_CR_PACKAGE_REL_PATH", "OPERATOR_PACKAGE_REL_PATH", "OPERATOR_ENVIRONMENT_REL_PATH", "OPERATOR_DEPLOYMENT_PATH", "getOPERATOR_DEPLOYMENT_PATH", "DIGITAL_AI_PATH", "getOperatorHomeDir", "updateOperatorApplications", "", "updateOperatorEnvironment", "updateInfrastructure", "updateOperatorDeployment", "updateOperatorDeploymentCr", "getOperatorNamespaceVersion", "turnOnLogging", "turnOffLogging", "createClusterMetadata", "undeployCluster", "undeployCis", "", "getOperatorImage", "updateDeploymentValues", "updateOperatorCrValues", "updateCustomOperatorCrValues", "crValuesFile", "Ljava/io/File;", "getFqdn", "getInitialCrValuesFile", "getReferenceCrValuesFile", "getProviderCrContextPath", "getContextRoot", "getIngressClass", "getCurrentContextInfo", "Lai/digital/integration/server/common/domain/InfrastructureInfo;", "getHost", "getDeploySuffix", "getPort", "applyYamlFiles", "getProviderHomeDir", "getProviderHomePath", "getProvider", "Lai/digital/integration/server/common/domain/providers/Provider;", "getKubectlHelper", "Lai/digital/integration/server/common/util/KubeCtlHelper;", "operatorCleanUpCluster", "waiting", "Ljava/time/Duration;", "cleanUpCluster", "getResources", "resourcesList", "", "([Ljava/lang/String;)Ljava/lang/String;", "deleteAllResources", "([Ljava/lang/String;)V", "waitDeleteAllResources", "deleteResourcesJob", "iteration", "", "(Lkotlinx/coroutines/Job;ILjava/time/Duration;[Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "deleteResources", "Companion", "integration-server-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nOperatorHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OperatorHelper.kt\nai/digital/integration/server/common/cluster/operator/OperatorHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,513:1\n1#2:514\n10135#3:515\n10557#3,2:516\n11228#3:518\n11563#3,3:519\n10559#3,3:522\n13472#3:525\n13472#3,2:526\n13473#3:528\n*S KotlinDebug\n*F\n+ 1 OperatorHelper.kt\nai/digital/integration/server/common/cluster/operator/OperatorHelper\n*L\n442#1:515\n442#1:516,2\n443#1:518\n443#1:519,3\n442#1:522,3\n495#1:525\n496#1:526,2\n495#1:528\n*E\n"})
public abstract class OperatorHelper
extends Helper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Job loggingJob;
    @NotNull
    private final String OPERATOR_INFRASTRUCTURE_PATH;
    @NotNull
    private final String OPERATOR_CR_VALUES_FILENAME;
    @NotNull
    private final String OPERATOR_CR_VALUES_REL_PATH;
    @NotNull
    private final String operatorMetadataPath;
    @NotNull
    private final String OPERATOR_FOLDER_NAME;
    @NotNull
    private final String OPERATOR_APPS_REL_PATH;
    @NotNull
    private final String OPERATOR_CR_PACKAGE_REL_PATH;
    @NotNull
    private final String OPERATOR_PACKAGE_REL_PATH;
    @NotNull
    private final String OPERATOR_ENVIRONMENT_REL_PATH;
    @NotNull
    private final String OPERATOR_DEPLOYMENT_PATH;
    @NotNull
    private final String DIGITAL_AI_PATH;

    public OperatorHelper(@NotNull Project project, @NotNull ProductName productName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)productName), (String)"productName");
        super(project, productName);
        this.OPERATOR_INFRASTRUCTURE_PATH = "digitalai-" + this.getName() + "/infrastructure.yaml";
        this.OPERATOR_CR_VALUES_FILENAME = "dai" + this.getName() + "_cr.yaml";
        this.OPERATOR_CR_VALUES_REL_PATH = "digitalai-" + this.getName() + "/kubernetes/" + this.OPERATOR_CR_VALUES_FILENAME;
        this.operatorMetadataPath = this.getName() + "/operator/operator-metadata.properties";
        this.OPERATOR_FOLDER_NAME = "xl-" + this.getName() + "-kubernetes-operator";
        this.OPERATOR_APPS_REL_PATH = "digitalai-" + this.getName() + "/applications.yaml";
        this.OPERATOR_CR_PACKAGE_REL_PATH = "digitalai-" + this.getName() + "/deployment-cr.yaml";
        this.OPERATOR_PACKAGE_REL_PATH = "digitalai-" + this.getName() + "/deployment.yaml";
        this.OPERATOR_ENVIRONMENT_REL_PATH = "digitalai-" + this.getName() + "/environment.yaml";
        this.OPERATOR_DEPLOYMENT_PATH = "digitalai-" + this.getName() + "/kubernetes/template/deployment.yaml";
        this.DIGITAL_AI_PATH = "digital-ai.yaml";
    }

    @Nullable
    public final Job getLoggingJob() {
        return this.loggingJob;
    }

    public final void setLoggingJob(@Nullable Job job) {
        this.loggingJob = job;
    }

    @NotNull
    public final String getOPERATOR_INFRASTRUCTURE_PATH() {
        return this.OPERATOR_INFRASTRUCTURE_PATH;
    }

    @NotNull
    public final String getOPERATOR_CR_VALUES_FILENAME() {
        return this.OPERATOR_CR_VALUES_FILENAME;
    }

    @NotNull
    public final String getOPERATOR_CR_VALUES_REL_PATH() {
        return this.OPERATOR_CR_VALUES_REL_PATH;
    }

    @NotNull
    public final String getOPERATOR_DEPLOYMENT_PATH() {
        return this.OPERATOR_DEPLOYMENT_PATH;
    }

    @NotNull
    public final String getOperatorHomeDir() {
        return ((Object)((Directory)this.getProject().getLayout().getBuildDirectory().get()).getAsFile().toPath().resolve(this.OPERATOR_FOLDER_NAME).toAbsolutePath()).toString();
    }

    public final void updateOperatorApplications() {
        this.getProject().getLogger().lifecycle("Updating operator's applications");
        String operatorNamespaceVersion = this.getOperatorNamespaceVersion();
        String deploySuffix = this.getDeploySuffix();
        File file = new File(this.getProviderHomeDir(), this.OPERATOR_APPS_REL_PATH);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"spec[0].children[0].name", (Object)(operatorNamespaceVersion + deploySuffix))};
        Map pairs = MapsKt.mutableMapOf((Pair[])pairArray);
        YamlFileUtil.Companion.overlayFile$default(YamlFileUtil.Companion, file, pairs, null, false, 12, null);
    }

    public final void updateOperatorEnvironment() {
        String string;
        String operatorNamespace;
        block5: {
            Object object;
            block4: {
                this.getProject().getLogger().lifecycle("Updating operator's environment");
                object = this.getNamespace();
                if (object == null) break block4;
                String it = object;
                boolean bl = false;
                String string2 = "-" + it;
                object = string2;
                if (string2 != null) break block5;
            }
            object = operatorNamespace = "";
        }
        if ((string = this.getNamespace()) == null) {
            string = Profile.Companion.getDEFAULT_NAMESPACE_NAME();
        }
        String operatorNamespaceOrDefault = string;
        String deploySuffix = this.getDeploySuffix();
        File file = new File(this.getProviderHomeDir(), this.OPERATOR_ENVIRONMENT_REL_PATH);
        Pair[] pairArray = new Pair[2];
        pairArray[0] = TuplesKt.to((Object)"spec[0].children[0].name", (Object)(this.getPrefixName() + operatorNamespace + deploySuffix));
        String[] stringArray = new String[]{"~Infrastructure/k8s-infra/" + this.getPrefixName() + operatorNamespace + deploySuffix + "/" + operatorNamespaceOrDefault};
        pairArray[1] = TuplesKt.to((Object)"spec[0].children[0].members", (Object)stringArray);
        Map pairs = MapsKt.mutableMapOf((Pair[])pairArray);
        YamlFileUtil.Companion.overlayFile$default(YamlFileUtil.Companion, file, pairs, null, false, 12, null);
    }

    public void updateInfrastructure() {
        Object object;
        block3: {
            block2: {
                this.getProject().getLogger().lifecycle("Updating operator's infrastructure");
                object = this.getNamespace();
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                String string = "-" + it;
                object = string;
                if (string != null) break block3;
            }
            object = "";
        }
        String operatorNamespace = object;
        String deploySuffix = this.getDeploySuffix();
        File file = new File(this.getProviderHomeDir(), this.OPERATOR_INFRASTRUCTURE_PATH);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"spec[0].children[0].name", (Object)(this.getPrefixName() + operatorNamespace + deploySuffix))};
        Map pairs = MapsKt.mutableMapOf((Pair[])pairArray);
        YamlFileUtil.Companion.overlayFile$default(YamlFileUtil.Companion, file, pairs, null, false, 12, null);
    }

    public final void updateOperatorDeployment() {
        Object object;
        block3: {
            block2: {
                this.getProject().getLogger().lifecycle("Updating operator's deployment");
                object = this.getNamespace();
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                String string = "-" + it;
                object = string;
                if (string != null) break block3;
            }
            object = "";
        }
        String operatorNamespace = object;
        String operatorNamespaceVersion = this.getOperatorNamespaceVersion();
        String deploySuffix = this.getDeploySuffix();
        File file = new File(this.getProviderHomeDir(), this.OPERATOR_PACKAGE_REL_PATH);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"spec.package", (Object)("Applications/" + this.getPrefixName() + "-operator-app/" + operatorNamespaceVersion + deploySuffix)), TuplesKt.to((Object)"spec.environment", (Object)("Environments/kubernetes-envs/" + this.getPrefixName() + operatorNamespace + deploySuffix))};
        Map pairs = MapsKt.mutableMapOf((Pair[])pairArray);
        YamlFileUtil.Companion.overlayFile$default(YamlFileUtil.Companion, file, pairs, null, false, 12, null);
    }

    public final void updateOperatorDeploymentCr() {
        Object object;
        block3: {
            block2: {
                this.getProject().getLogger().lifecycle("Updating operator's deployment CR");
                object = this.getNamespace();
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                String string = "-" + it;
                object = string;
                if (string != null) break block3;
            }
            object = "";
        }
        String operatorNamespace = object;
        String operatorNamespaceVersion = this.getOperatorNamespaceVersion();
        String deploySuffix = this.getDeploySuffix();
        File file = new File(this.getProviderHomeDir(), this.OPERATOR_CR_PACKAGE_REL_PATH);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"spec.package", (Object)("Applications/" + this.getPrefixName() + "-cr/" + operatorNamespaceVersion + deploySuffix)), TuplesKt.to((Object)"spec.environment", (Object)("Environments/kubernetes-envs/" + this.getPrefixName() + operatorNamespace + deploySuffix))};
        Map pairs = MapsKt.mutableMapOf((Pair[])pairArray);
        YamlFileUtil.Companion.overlayFile$default(YamlFileUtil.Companion, file, pairs, null, false, 12, null);
    }

    private final String getOperatorNamespaceVersion() {
        Object object;
        block3: {
            block2: {
                object = this.getNamespace();
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                String string = "-" + it;
                object = string;
                if (string != null) break block3;
            }
            object = "";
        }
        String namespaceAsSuffix = object;
        Object object2 = this.getProvider().getOperatorPackageVersion().map(new Transformer(namespaceAsSuffix){
            final /* synthetic */ String $namespaceAsSuffix;
            {
                this.$namespaceAsSuffix = $namespaceAsSuffix;
            }

            public final String transform(String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it + this.$namespaceAsSuffix;
            }
        }).getOrElse((Object)(this.getServerVersion() + namespaceAsSuffix));
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getOrElse(...)");
        return (String)object2;
    }

    public final void turnOnLogging() {
        this.loggingJob = BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int I$0;
            int I$1;
            int I$2;
            int I$3;
            Object L$0;
            int label;
            final /* synthetic */ OperatorHelper this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var14_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        var2_3 = 1000;
                        var3_4 = this.this$0;
                        var4_5 = 0;
lbl8:
                        // 2 sources

                        while (var4_5 < var2_3) {
                            it = var4_5;
                            $i$a$-repeat-OperatorHelper$turnOnLogging$1$1 = 0;
                            var3_4.getKubectlHelper().savePodLogs(var3_4.getPostgresPodName(0));
                            var3_4.getKubectlHelper().savePodLogs(var3_4.getRabbitMqPodName(0));
                            var7_9 = var3_4.getMasterCount();
                            var8_12 = new ArrayList<String>(var7_9);
                            var9_15 = 0;
                            while (var9_15 < var7_9) {
                                var11_21 = var10_17 = var9_15++;
                                var12_25 = var8_12;
                                $i$a$-List-OperatorHelper$turnOnLogging$1$1$1 = false;
                                var12_25.add(var3_4.getMasterPodName((int)position));
                            }
                            var7_8 = var8_12;
                            $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                it = (String)element$iv;
                                $i$a$-forEach-OperatorHelper$turnOnLogging$1$1$2 = false;
                                var3_4.getKubectlHelper().savePodLogs(it);
                            }
                            if (var3_4.getProductName() == ProductName.DEPLOY) {
                                $this$forEach$iv = var3_4.getDeployWorkerCount();
                                $i$f$forEach = new ArrayList<E>($this$forEach$iv);
                                var9_16 = 0;
                                while (var9_16 < $this$forEach$iv) {
                                    it = element$iv = var9_16++;
                                    var12_25 = $i$f$forEach;
                                    $i$a$-List-OperatorHelper$turnOnLogging$1$1$3 = false;
                                    var12_25.add(var3_4.getWorkerPodName((int)position));
                                }
                                $this$forEach$iv = $i$f$forEach;
                                $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    it = (String)element$iv;
                                    $i$a$-forEach-OperatorHelper$turnOnLogging$1$1$4 = false;
                                    var3_4.getKubectlHelper().savePodLogs(it);
                                }
                            }
                            this.L$0 = var3_4;
                            this.I$0 = var2_3;
                            this.I$1 = var4_5;
                            this.I$2 = it;
                            this.I$3 = $i$a$-repeat-OperatorHelper$turnOnLogging$1$1;
                            this.label = 1;
                            v0 = DelayKt.delay((long)2000L, (Continuation)this);
                            if (v0 == var14_2) {
                                return var14_2;
                            }
                            ** GOTO lbl71
                        }
                        break;
                    }
                    case 1: {
                        $i$a$-repeat-OperatorHelper$turnOnLogging$1$1 = this.I$3;
                        it = this.I$2;
                        var4_5 = this.I$1;
                        var2_3 = this.I$0;
                        var3_4 = (OperatorHelper)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl71:
                        // 2 sources

                        ++var4_5;
                        ** GOTO lbl8
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void turnOffLogging() {
        block0: {
            Job job = this.loggingJob;
            if (job == null) break block0;
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
    }

    public final void createClusterMetadata() {
        this.clusterMetadata(this.operatorMetadataPath, this.getContextRoot());
    }

    public final void undeployCluster() {
        this.getProject().getLogger().lifecycle("Operator is being undeployed");
        if (this.undeployCis()) {
            this.getProject().getLogger().lifecycle("PVCs are being deleted");
            this.getKubectlHelper().deleteAllPVCs();
        } else {
            this.getProject().getLogger().lifecycle("Skip delete of PVCs");
        }
    }

    public final boolean undeployCis() {
        boolean bl;
        String scriptName = "undeploy_" + this.getProductName().getDisplayName() + ".py";
        InputStream fileStream = ((Function0)OperatorHelper::undeployCis$lambda$5).getClass().getClassLoader().getResourceAsStream("operator/python/" + scriptName);
        String[] stringArray = new String[]{scriptName};
        Path resultComposeFilePath = Paths.get(this.getProviderWorkDir(), stringArray);
        InputStream inputStream = fileStream;
        if (inputStream != null) {
            InputStream it = inputStream;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)resultComposeFilePath);
            FileUtil.Companion.copyFile(it, resultComposeFilePath);
        }
        try {
            CliUtil.Companion.executeScripts$default(CliUtil.Companion, this.getProject(), CollectionsKt.listOf((Object)resultComposeFilePath.toFile()), scriptName, false, null, true, 24, null);
            bl = true;
        }
        catch (RuntimeException e) {
            this.getProject().getLogger().error("Undeploy didn't run. Check if operator's " + this.getName() + " server is running on port " + new OperatorUtil(this.getProject()).getOperatorServer().getHttpPort() + ": " + e.getMessage());
            bl = false;
        }
        catch (IOException e) {
            this.getProject().getLogger().error("Undeploy didn't run. Check if operator's " + this.getName() + " server has all files: " + e.getMessage());
            bl = false;
        }
        return bl;
    }

    @Nullable
    public String getOperatorImage() {
        return (String)this.getProvider().getOperatorImage().getOrNull();
    }

    public final void updateDeploymentValues() {
        block0: {
            String string = this.getOperatorImage();
            if (string == null) break block0;
            String operatorImage = string;
            boolean bl = false;
            this.getProject().getLogger().lifecycle("Updating operator's deployment values");
            File file = new File(this.getProviderHomeDir(), this.OPERATOR_DEPLOYMENT_PATH);
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"spec.template.spec.containers[1].image", (Object)operatorImage)};
            Map pairs = MapsKt.mutableMapOf((Pair[])pairArray);
            YamlFileUtil.Companion.overlayFile$default(YamlFileUtil.Companion, file, pairs, null, false, 4, null);
        }
    }

    public final void updateOperatorCrValues() {
        this.getProject().getLogger().lifecycle("Updating operator's CR values");
        File file = this.getInitialCrValuesFile();
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"spec.ImageRepository", (Object)this.getServerImageRepository()), TuplesKt.to((Object)"spec.ServerImageRepository", (Object)this.getServerImageRepository()), TuplesKt.to((Object)"spec.ImageTag", (Object)this.getServerVersion()), TuplesKt.to((Object)"spec.KeystorePassphrase", (Object)this.getProvider().getKeystorePassphrase().get()), TuplesKt.to((Object)"spec.Persistence.StorageClass", (Object)this.getStorageClass()), TuplesKt.to((Object)"spec.RepositoryKeystore", (Object)this.getProvider().getRepositoryKeystore().get()), TuplesKt.to((Object)"spec.postgresql.image.debug", (Object)true), TuplesKt.to((Object)"spec.postgresql.persistence.size", (Object)"1Gi"), TuplesKt.to((Object)"spec.postgresql.persistence.storageClass", (Object)this.getDbStorageClass()), TuplesKt.to((Object)"spec.postgresql.postgresqlMaxConnections", (Object)this.getDbConnectionCount()), TuplesKt.to((Object)"spec.keycloak.install", (Object)false), TuplesKt.to((Object)"spec.keycloak.postgresql.persistence.size", (Object)"1Gi"), TuplesKt.to((Object)"spec.oidc.enabled", (Object)false), TuplesKt.to((Object)"spec.rabbitmq.persistence.storageClass", (Object)this.getMqStorageClass()), TuplesKt.to((Object)"spec.rabbitmq.image.debug", (Object)true), TuplesKt.to((Object)"spec.rabbitmq.persistence.size", (Object)"1Gi"), TuplesKt.to((Object)"spec.rabbitmq.replicaCount", (Object)this.getProvider().getRabbitmqReplicaCount().get()), TuplesKt.to((Object)"spec.rabbitmq.persistence.replicaCount", (Object)1), TuplesKt.to((Object)("spec." + this.getPrefixName() + "License"), (Object)this.getLicense())};
        Map pairs = MapsKt.mutableMapOf((Pair[])pairArray);
        Object object = this.getProfile().getIngressType().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        if (IngressType.valueOf((String)object) == IngressType.HAPROXY) {
            pairArray = new Pair[4];
            pairArray[0] = TuplesKt.to((Object)"spec.haproxy-ingress.install", (Object)true);
            pairArray[1] = TuplesKt.to((Object)"spec.nginx-ingress-controller.install", (Object)false);
            pairArray[2] = TuplesKt.to((Object)"spec.ingress.path", (Object)this.getContextRoot());
            Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)"kubernetes.io/ingress.class", (Object)this.getIngressClass()), TuplesKt.to((Object)"ingress.kubernetes.io/ssl-redirect", (Object)"false"), TuplesKt.to((Object)"ingress.kubernetes.io/rewrite-target", (Object)this.getContextRoot()), TuplesKt.to((Object)"ingress.kubernetes.io/affinity", (Object)"cookie"), TuplesKt.to((Object)"ingress.kubernetes.io/session-cookie-name", (Object)"JSESSIONID"), TuplesKt.to((Object)"ingress.kubernetes.io/session-cookie-strategy", (Object)"prefix"), TuplesKt.to((Object)"ingress.kubernetes.io/config-backend", (Object)"option httpchk GET /ha/health HTTP/1.0")};
            pairArray[3] = TuplesKt.to((Object)"spec.ingress.annotations", (Object)MapsKt.mapOf((Pair[])pairArray2));
            pairs.putAll(MapsKt.mutableMapOf((Pair[])pairArray));
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.getProductName().ordinal()]) {
            case 1: {
                Pair[] pairArray3 = new Pair[]{TuplesKt.to((Object)"spec.XldMasterCount", (Object)this.getMasterCount()), TuplesKt.to((Object)"spec.XldWorkerCount", (Object)this.getDeployWorkerCount()), TuplesKt.to((Object)"spec.WorkerImageRepository", (Object)this.getDeployWorkerImageRepository()), TuplesKt.to((Object)"spec.Persistence.XldMasterPvcSize", (Object)"1Gi"), TuplesKt.to((Object)"spec.Persistence.XldWorkerPvcSize", (Object)"1Gi"), TuplesKt.to((Object)"spec.centralConfiguration.image.repository", (Object)this.getCentralConfigImageRepository())};
                pairs.putAll(MapsKt.mutableMapOf((Pair[])pairArray3));
                break;
            }
            case 2: {
                Pair[] pairArray4 = new Pair[]{TuplesKt.to((Object)"spec.replicaCount", (Object)this.getMasterCount()), TuplesKt.to((Object)"spec.Persistence.Size", (Object)"1Gi")};
                pairs.putAll(MapsKt.mutableMapOf((Pair[])pairArray4));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        YamlFileUtil.Companion.overlayFile$default(YamlFileUtil.Companion, file, pairs, null, false, 4, null);
        this.updateCustomOperatorCrValues(file);
    }

    public abstract void updateCustomOperatorCrValues(@NotNull File var1);

    @Override
    @NotNull
    public String getFqdn() {
        return this.getHost();
    }

    @NotNull
    public final File getInitialCrValuesFile() {
        return new File(this.getProviderHomeDir(), this.OPERATOR_CR_VALUES_REL_PATH);
    }

    @NotNull
    public final File getReferenceCrValuesFile() {
        return new File(this.getProviderWorkDir(), this.OPERATOR_CR_VALUES_FILENAME);
    }

    @NotNull
    public String getProviderCrContextPath() {
        return "spec.ingress.path";
    }

    @NotNull
    public String getContextRoot() {
        File file = this.getInitialCrValuesFile();
        String pathKey = this.getProviderCrContextPath();
        return this.getContextRootPath(file, pathKey);
    }

    @NotNull
    public String getIngressClass() {
        File file = this.getInitialCrValuesFile();
        String pathKey = "spec.ingress.annotations";
        Object object = YamlFileUtil.Companion.readFileKey$default(YamlFileUtil.Companion, file, pathKey, false, 4, null);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.MutableMap<*, *>");
        Map annotations = TypeIntrinsics.asMutableMap((Object)object);
        Object v = annotations.get("kubernetes.io/ingress.class");
        Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.String");
        return (String)v;
    }

    @NotNull
    public InfrastructureInfo getCurrentContextInfo() {
        return new InfrastructureInfo(null, null, null, null, null, null);
    }

    @Override
    @NotNull
    public String getHost() {
        Property<String> property = this.getProvider().getHost();
        Object object = this.getProvider().getName().get();
        String string = this.getProductName().getShortName();
        String string2 = this.getNamespace();
        if (string2 == null) {
            string2 = Profile.Companion.getDEFAULT_NAMESPACE_NAME();
        }
        Object object2 = property.getOrElse((Object)(object + "-" + string + "-" + string2));
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getOrElse(...)");
        return (String)object2;
    }

    @NotNull
    public final String getDeploySuffix() {
        Object object = this.getProfile().getDeploySuffix().map((Transformer)getDeploySuffix.1.INSTANCE).getOrElse((Object)"");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getOrElse(...)");
        return (String)object;
    }

    @Override
    @NotNull
    public String getPort() {
        return "80";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyYamlFiles() {
        this.getProject().getLogger().lifecycle("Applying prepared Yaml files");
        File digitalAiPath = new File(this.getProviderHomeDir(), this.DIGITAL_AI_PATH);
        this.getProject().getLogger().lifecycle("Applying Digital AI " + this.getProductName() + " platform on cluster (" + digitalAiPath + ")");
        Server operatorServer = new OperatorUtil(this.getProject()).getOperatorServer();
        LocalDateTime startTime = LocalDateTime.now();
        try {
            XlCliUtil.Companion.xlApply(this.getProject(), digitalAiPath, new File(this.getProviderHomeDir()), operatorServer.getHttpPort());
            FileUtils.copyFileToDirectory((File)this.getInitialCrValuesFile(), (File)new File(this.getProviderWorkDir()));
        }
        finally {
            Project project = this.getProject();
            String string = "deploy-" + operatorServer.getVersion();
            Intrinsics.checkNotNull((Object)startTime);
            DeployServerUtil.Companion.saveServerLogsToFile(project, operatorServer, string, startTime);
        }
    }

    @NotNull
    public final String getProviderHomeDir() {
        return this.getOperatorHomeDir() + "/" + this.getProviderHomePath();
    }

    @NotNull
    public abstract String getProviderHomePath();

    @Override
    @NotNull
    public abstract Provider getProvider();

    @Override
    @NotNull
    public KubeCtlHelper getKubectlHelper() {
        return new KubeCtlHelper(this.getProject(), this.getNamespace(), false, 4, null);
    }

    public final void operatorCleanUpCluster(@NotNull Duration waiting) {
        Intrinsics.checkNotNullParameter((Object)waiting, (String)"waiting");
        if (((Boolean)this.getProfile().getDoCleanup().get()).booleanValue()) {
            String[] stringArray = new String[]{"crd", "all", "service", "roles", "roleBinding", "clusterRoles", "clusterRoleBinding", "ing", "ingressclass", "serviceaccount", "pvc", "configmap", "secret", "job"};
            String[] resourcesList = stringArray;
            BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, waiting, resourcesList, null){
                Object L$1;
                int I$0;
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ OperatorHelper this$0;
                final /* synthetic */ Duration $waiting;
                final /* synthetic */ String[] $resourcesList;
                {
                    this.this$0 = $receiver;
                    this.$waiting = $waiting;
                    this.$resourcesList = $resourcesList;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var2_2 = (CoroutineScope)this.L$0;
                    var5_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            iteration = 1;
lbl7:
                            // 2 sources

                            while (iteration < 4) {
                                this.this$0.getProject().getLogger().lifecycle("Clean up cluster resources in namespace " + this.this$0.getKubectlHelper().getNamespace() + " iteration " + iteration);
                                deleteResourcesJob = BuildersKt.launch$default((CoroutineScope)$this$runBlocking, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$waiting, this.this$0, this.$resourcesList, null){
                                    int label;
                                    final /* synthetic */ Duration $waiting;
                                    final /* synthetic */ OperatorHelper this$0;
                                    final /* synthetic */ String[] $resourcesList;
                                    {
                                        this.$waiting = $waiting;
                                        this.this$0 = $receiver;
                                        this.$resourcesList = $resourcesList;
                                        super(2, $completion);
                                    }

                                    /*
                                     * Enabled force condition propagation
                                     * Lifted jumps to return sites
                                     */
                                    public final Object invokeSuspend(Object $result) {
                                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                this.label = 1;
                                                Object object2 = TimeoutKt.withTimeout((long)this.$waiting.toMillis(), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$resourcesList, null){
                                                    int label;
                                                    final /* synthetic */ OperatorHelper this$0;
                                                    final /* synthetic */ String[] $resourcesList;
                                                    {
                                                        this.this$0 = $receiver;
                                                        this.$resourcesList = $resourcesList;
                                                        super(2, $completion);
                                                    }

                                                    /*
                                                     * Enabled force condition propagation
                                                     * Lifted jumps to return sites
                                                     */
                                                    public final Object invokeSuspend(Object $result) {
                                                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                        switch (this.label) {
                                                            case 0: {
                                                                ResultKt.throwOnFailure((Object)$result);
                                                                this.label = 1;
                                                                Object object2 = InterruptibleKt.runInterruptible((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), () -> operatorCleanUpCluster.deleteResourcesJob.1.invokeSuspend$lambda$0(this.this$0, this.$resourcesList), (Continuation)((Continuation)this));
                                                                if (object2 != object) return Unit.INSTANCE;
                                                                return object;
                                                            }
                                                            case 1: {
                                                                ResultKt.throwOnFailure((Object)$result);
                                                                Object object2 = $result;
                                                                return Unit.INSTANCE;
                                                            }
                                                        }
                                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                    }

                                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                    }

                                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                    }

                                                    private static final Unit invokeSuspend$lambda$0(OperatorHelper this$0, String[] $resourcesList) {
                                                        OperatorHelper.access$deleteAllResources(this$0, $resourcesList);
                                                        return Unit.INSTANCE;
                                                    }
                                                }), (Continuation)((Continuation)this));
                                                if (object2 != object) return Unit.INSTANCE;
                                                return object;
                                            }
                                            case 1: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                Object object2 = $result;
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (int)3, null);
                                this.L$0 = $this$runBlocking;
                                this.L$1 = SpillingKt.nullOutSpilledVariable((Object)deleteResourcesJob);
                                this.I$0 = iteration;
                                this.label = 1;
                                v0 = OperatorHelper.access$waitDeleteAllResources(this.this$0, deleteResourcesJob, iteration, this.$waiting, this.$resourcesList, (Continuation)this);
                                if (v0 == var5_3) {
                                    return var5_3;
                                }
                                ** GOTO lbl24
                            }
                            ** GOTO lbl27
                        }
                        case 1: {
                            iteration = this.I$0;
                            deleteResourcesJob = (Job)this.L$1;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl24:
                            // 2 sources

                            if (((Boolean)v0).booleanValue()) ** GOTO lbl27
                            ++iteration;
                            ** GOTO lbl7
lbl27:
                            // 2 sources

                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
            this.getProject().getLogger().lifecycle("Clean up cluster resources finished in namespace " + this.getKubectlHelper().getNamespace());
        } else {
            this.getProject().getLogger().lifecycle("Skip up cluster resources in namespace " + this.getKubectlHelper().getNamespace());
        }
    }

    public final void cleanUpCluster(@NotNull Duration waiting) {
        Intrinsics.checkNotNullParameter((Object)waiting, (String)"waiting");
        this.operatorCleanUpCluster(waiting);
    }

    /*
     * WARNING - void declaration
     */
    private final String getResources(String[] resourcesList) {
        void $this$flatMapTo$iv$iv;
        KubeCtlHelper kubectlHelper = this.getKubectlHelper();
        ProductName[] productNames = ProductName.values();
        String[] $this$flatMap$iv = resourcesList;
        boolean $i$f$flatMap = false;
        String[] stringArray = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        int n = ((void)$this$flatMapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void $this$mapTo$iv$iv;
            void element$iv$iv;
            void resource = element$iv$iv = $this$flatMapTo$iv$iv[i];
            boolean bl = false;
            ProductName[] $this$map$iv = productNames;
            boolean $i$f$map = false;
            ProductName[] productNameArray = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n2 = ((void)$this$mapTo$iv$iv).length;
            for (int j = 0; j < n2; ++j) {
                void productName;
                void item$iv$iv;
                void var23_22 = item$iv$iv = $this$mapTo$iv$iv[j];
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(kubectlHelper.getResourceNames((String)resource, (ProductName)productName));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List resources = (List)destination$iv$iv;
        return ((Object)StringsKt.trim((CharSequence)CollectionsKt.joinToString$default((Iterable)resources, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null))).toString();
    }

    private final void deleteAllResources(String[] resourcesList) {
        this.deleteResources(resourcesList);
        KubeCtlHelper kubectlHelper = this.getKubectlHelper();
        String names = kubectlHelper.getResourceNames("ingressclass");
        if (!StringsKt.isBlank((CharSequence)names)) {
            this.getProject().getLogger().lifecycle("Deleting resources ingressclass:\n " + names);
            String deleteResult = kubectlHelper.deleteNames(names);
            if (!StringsKt.isBlank((CharSequence)deleteResult)) {
                this.getProject().getLogger().lifecycle("Deleted resources ingressclass:\n " + deleteResult);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private final Object waitDeleteAllResources(Job deleteResourcesJob, int iteration, Duration waiting, String[] resourcesList, Continuation<? super Boolean> $completion) {
        block11: {
            if (!($completion instanceof waitDeleteAllResources.1)) ** GOTO lbl-1000
            var10_6 = $completion;
            if ((var10_6.label & -2147483648) != 0) {
                var10_6.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    int I$0;
                    int I$1;
                    int I$2;
                    /* synthetic */ Object result;
                    final /* synthetic */ OperatorHelper this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return OperatorHelper.access$waitDeleteAllResources(this.this$0, null, 0, null, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var11_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            block0 : switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    repeat = 10;
                    i = 1;
lbl14:
                    // 2 sources

                    while (true) {
                        this.getProject().getLogger().lifecycle("Waiting cleanup " + i);
                        if (!deleteResourcesJob.isActive()) break block11;
                        $continuation.L$0 = deleteResourcesJob;
                        $continuation.L$1 = waiting;
                        $continuation.L$2 = resourcesList;
                        $continuation.I$0 = iteration;
                        $continuation.I$1 = repeat;
                        $continuation.I$2 = i;
                        $continuation.label = 1;
                        v0 = DelayKt.delay((long)(waiting.toMillis() / (long)repeat), (Continuation)$continuation);
                        if (v0 == var11_8) {
                            return var11_8;
                        }
                        break block0;
                        break;
                    }
                }
                case 1: {
                    i = $continuation.I$2;
                    repeat = $continuation.I$1;
                    iteration = $continuation.I$0;
                    resourcesList = (String[])$continuation.L$2;
                    waiting = (Duration)$continuation.L$1;
                    deleteResourcesJob = (Job)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
                    break;
                }
            }
            if (i != repeat) {
                ++i;
                ** continue;
            }
        }
        v1 = hasResources = StringsKt.isBlank((CharSequence)(existingResourcesFromList = this.getResources(resourcesList))) == false;
        if (hasResources) {
            this.getProject().getLogger().lifecycle("Has more resources, cancelling in iteration " + iteration + ": \n " + existingResourcesFromList);
            Job.DefaultImpls.cancel$default((Job)deleteResourcesJob, null, (int)1, null);
            v2 = false;
        } else {
            this.getProject().getLogger().lifecycle("Clean up cluster resources finished in iteration " + iteration + " in namespace " + this.getKubectlHelper().getNamespace());
            v2 = true;
        }
        return Boxing.boxBoolean((boolean)v2);
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void deleteResources(String[] resourcesList) {
        KubeCtlHelper kubectlHelper = this.getKubectlHelper();
        ProductName[] productNames = ProductName.values();
        String[] $this$forEach$iv = resourcesList;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            String element$iv;
            String resource = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            ProductName[] $this$forEach$iv2 = productNames;
            boolean $i$f$forEach2 = false;
            int n2 = $this$forEach$iv2.length;
            for (int j = 0; j < n2; ++j) {
                String deleteResult;
                ProductName element$iv2;
                ProductName productName = element$iv2 = $this$forEach$iv2[j];
                boolean bl2 = false;
                String names = kubectlHelper.getResourceNames(resource, productName);
                if (!(!StringsKt.isBlank((CharSequence)names))) continue;
                this.getProject().getLogger().lifecycle("Deleting resources " + resource + " on " + productName + ":\n " + names);
                if (Intrinsics.areEqual((Object)resource, (Object)"crd") || Intrinsics.areEqual((Object)resource, (Object)"service")) {
                    String result = kubectlHelper.clearCrFinalizers(names);
                    this.getProject().getLogger().lifecycle("Cleared finalizers for " + resource + " on " + productName + ":\n " + result);
                }
                if (!(!StringsKt.isBlank((CharSequence)(deleteResult = kubectlHelper.deleteNames(names))))) continue;
                this.getProject().getLogger().lifecycle("Deleted resources " + resource + " on " + productName + ":\n " + deleteResult);
            }
        }
    }

    private static final Unit undeployCis$lambda$5() {
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$deleteAllResources(OperatorHelper $this, String[] resourcesList) {
        $this.deleteAllResources(resourcesList);
    }

    public static final /* synthetic */ Object access$waitDeleteAllResources(OperatorHelper $this, Job deleteResourcesJob2, int iteration, Duration waiting, String[] resourcesList, Continuation $completion) {
        return $this.waitDeleteAllResources(deleteResourcesJob2, iteration, waiting, resourcesList, (Continuation<? super Boolean>)$completion);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\f"}, d2={"Lai/digital/integration/server/common/cluster/operator/OperatorHelper$Companion;", "", "<init>", "()V", "getOperatorHelper", "Lai/digital/integration/server/common/cluster/operator/OperatorHelper;", "project", "Lorg/gradle/api/Project;", "productName", "Lai/digital/integration/server/common/constant/ProductName;", "getOperatorProvider", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final OperatorHelper getOperatorHelper(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ProductName productName = ReleaseServerUtil.Companion.isReleaseServerDefined(project) ? ProductName.RELEASE : ProductName.DEPLOY;
            return this.getOperatorHelper(project, productName);
        }

        @NotNull
        public final OperatorHelper getOperatorHelper(@NotNull Project project, @NotNull ProductName productName) {
            OperatorHelper operatorHelper;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)((Object)productName), (String)"productName");
            String providerName = this.getOperatorProvider(project, productName);
            if (Intrinsics.areEqual((Object)providerName, (Object)OperatorHelmProviderName.AWS_EKS.getProviderName())) {
                operatorHelper = new AwsEksOperatorHelper(project, productName);
            } else if (Intrinsics.areEqual((Object)providerName, (Object)OperatorHelmProviderName.AWS_OPENSHIFT.getProviderName())) {
                operatorHelper = new AwsOpenshiftOperatorHelper(project, productName);
            } else if (Intrinsics.areEqual((Object)providerName, (Object)OperatorHelmProviderName.AZURE_AKS.getProviderName())) {
                operatorHelper = new AzureAksOperatorHelper(project, productName);
            } else if (Intrinsics.areEqual((Object)providerName, (Object)OperatorHelmProviderName.GCP_GKE.getProviderName())) {
                operatorHelper = new GcpGkeOperatorHelper(project, productName);
            } else if (Intrinsics.areEqual((Object)providerName, (Object)OperatorHelmProviderName.ON_PREMISE.getProviderName())) {
                operatorHelper = new OnPremOperatorHelper(project, productName);
            } else if (Intrinsics.areEqual((Object)providerName, (Object)OperatorHelmProviderName.VMWARE_OPENSHIFT.getProviderName())) {
                operatorHelper = new VmwareOpenshiftOperatorHelper(project, productName);
            } else {
                throw new IllegalArgumentException("Provided operator provider name `" + providerName + "` is not supported. Choose one of " + ArraysKt.joinToString$default((Object[])OperatorHelmProviderName.values(), null, null, null, (int)0, null, null, (int)63, null));
            }
            return operatorHelper;
        }

        private final String getOperatorProvider(Project project, ProductName productName) {
            return switch (WhenMappings.$EnumSwitchMapping$0[productName.ordinal()]) {
                case 1 -> DeployClusterUtil.Companion.getOperatorProvider(project);
                case 2 -> ReleaseClusterUtil.Companion.getOperatorProvider(project);
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ProductName.values().length];
                try {
                    nArray[ProductName.DEPLOY.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ProductName.RELEASE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProductName.values().length];
            try {
                nArray[ProductName.DEPLOY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProductName.RELEASE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

