/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks.worker;

import ai.digital.integration.server.common.util.FileUtil;
import ai.digital.integration.server.common.util.ProcessUtil;
import ai.digital.integration.server.deploy.domain.Worker;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import ai.digital.integration.server.deploy.internals.WorkerUtil;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.io.FileUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\n"}, d2={"Lai/digital/integration/server/deploy/tasks/worker/SyncServerPluginsWithWorkerTask;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "copyToWorkers", "", "copyServerDirToWorkerDir", "worker", "Lai/digital/integration/server/deploy/domain/Worker;", "Companion", "integration-server-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nSyncServerPluginsWithWorkerTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SyncServerPluginsWithWorkerTask.kt\nai/digital/integration/server/deploy/tasks/worker/SyncServerPluginsWithWorkerTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,69:1\n774#2:70\n865#2,2:71\n774#2:73\n865#2,2:74\n1869#2,2:76\n*S KotlinDebug\n*F\n+ 1 SyncServerPluginsWithWorkerTask.kt\nai/digital/integration/server/deploy/tasks/worker/SyncServerPluginsWithWorkerTask\n*L\n27#1:70\n27#1:71,2\n28#1:73\n28#1:74,2\n29#1:76,2\n*E\n"})
public class SyncServerPluginsWithWorkerTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "syncServerPluginsWithWorker";

    public SyncServerPluginsWithWorkerTask() {
        this.setGroup("Integration Server");
        Object[] objectArray = new Object[]{"downloadAndExtractWorkerServer"};
        this.dependsOn(objectArray);
        this.onlyIf(new Spec(){

            public final boolean isSatisfiedBy(Task it) {
                Project project = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                return WorkerUtil.Companion.hasWorkers(project);
            }
        });
    }

    @TaskAction
    public final void copyToWorkers() {
        Worker worker;
        Iterable $this$filterTo$iv$iv;
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Iterable $this$filter$iv = WorkerUtil.Companion.getWorkers(project);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            worker = (Worker)element$iv$iv;
            boolean bl = false;
            if (!worker.getSlimDistribution()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            worker = (Worker)element$iv$iv;
            boolean bl = false;
            Project project2 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            if (!WorkerUtil.Companion.isExternalRuntimeWorker(project2, worker)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Worker worker2 = (Worker)element$iv;
            boolean bl = false;
            this.copyServerDirToWorkerDir(worker2);
        }
    }

    private final void copyServerDirToWorkerDir(Worker worker) {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        String sourceDir = DeployServerUtil.Companion.getServerWorkingDir(project);
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        File destinationDir = Paths.get(WorkerUtil.Companion.getWorkerWorkingDir(project2, worker), new String[0]).toFile();
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
        Project project4 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"getProject(...)");
        Object[] objectArray = new String[]{"bin"};
        ProcessUtil.Companion.chMod(project3, "755", String.valueOf(Paths.get(WorkerUtil.Companion.getWorkerWorkingDir(project4, worker), (String[])objectArray).toAbsolutePath()));
        this.getProject().getLogger().lifecycle("Copy plugins from directory " + sourceDir + " to Worker " + worker.getName() + " in directory " + destinationDir);
        Project project5 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project5, (String)"getProject(...)");
        objectArray = new String[]{"plugins"};
        FileUtils.deleteDirectory((File)Paths.get(WorkerUtil.Companion.getWorkerWorkingDir(project5, worker), (String[])objectArray).toFile());
        Project project6 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project6, (String)"getProject(...)");
        String string = DeployServerUtil.Companion.getServerWorkingDir(project6);
        Project project7 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project7, (String)"getProject(...)");
        objectArray = new String[]{"ext", "hotfix", "plugins"};
        FileUtil.Companion.copyDirs(string, WorkerUtil.Companion.getWorkerWorkingDir(project7, worker), CollectionsKt.listOf((Object[])objectArray));
        Project project8 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project8, (String)"getProject(...)");
        objectArray = new String[]{"conf"};
        String string2 = ((Object)Paths.get(DeployServerUtil.Companion.getServerWorkingDir(project8), (String[])objectArray).toAbsolutePath()).toString();
        Project project9 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project9, (String)"getProject(...)");
        objectArray = new String[]{"conf"};
        FileUtil.Companion.copyFiles(string2, ((Object)Paths.get(WorkerUtil.Companion.getWorkerWorkingDir(project9, worker), (String[])objectArray).toAbsolutePath()).toString(), CollectionsKt.listOf((Object)"deployit-license.lic"));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lai/digital/integration/server/deploy/tasks/worker/SyncServerPluginsWithWorkerTask$Companion;", "", "<init>", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

