/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks.worker;

import ai.digital.integration.server.common.util.CacheUtil;
import ai.digital.integration.server.common.util.OverlaysUtil;
import ai.digital.integration.server.deploy.domain.Worker;
import ai.digital.integration.server.deploy.internals.WorkerUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.specs.Spec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lai/digital/integration/server/deploy/tasks/worker/WorkerOverlaysTask;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "Companion", "integration-server-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nWorkerOverlaysTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkerOverlaysTask.kt\nai/digital/integration/server/deploy/tasks/worker/WorkerOverlaysTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,74:1\n1869#2:75\n1870#2:78\n216#3,2:76\n*S KotlinDebug\n*F\n+ 1 WorkerOverlaysTask.kt\nai/digital/integration/server/deploy/tasks/worker/WorkerOverlaysTask\n*L\n44#1:75\n44#1:78\n57#1:76,2\n*E\n"})
public class WorkerOverlaysTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "workerOverlays";
    @NotNull
    public static final String PREFIX = "worker";

    public WorkerOverlaysTask() {
        Object[] objectArray;
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (WorkerUtil.Companion.hasSlimWorkers(project)) {
            objectArray = new Object[]{"downloadAndExtractWorkerServer"};
            this.dependsOn(objectArray);
            objectArray = new Object[]{"syncServerPluginsWithWorker"};
            this.dependsOn(objectArray);
            objectArray = new Object[]{"setWorkerLogbackLevels"};
            this.dependsOn(objectArray);
            objectArray = new Object[]{"downloadAndExtractWorkerServer"};
            this.mustRunAfter(objectArray);
            objectArray = new Object[]{"syncServerPluginsWithWorker"};
            this.mustRunAfter(objectArray);
            objectArray = new Object[]{"setWorkerLogbackLevels"};
            this.mustRunAfter(objectArray);
        }
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        if (WorkerUtil.Companion.hasNonSlimWorkers(project2)) {
            objectArray = new Object[]{"copyIntegrationServer"};
            this.dependsOn(objectArray);
            objectArray = new Object[]{"setWorkerLogbackLevels"};
            this.dependsOn(objectArray);
            objectArray = new Object[]{"copyIntegrationServer"};
            this.mustRunAfter(objectArray);
            objectArray = new Object[]{"setWorkerLogbackLevels"};
            this.mustRunAfter(objectArray);
        }
        this.setGroup("Integration Server");
        this.onlyIf(new Spec(){

            public final boolean isSatisfiedBy(Task it) {
                Project project = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                return WorkerUtil.Companion.hasWorkers(project);
            }
        });
        WorkerOverlaysTask currentTask = this;
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
        Iterable $this$forEach$iv = WorkerUtil.Companion.getWorkers(project3);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Worker worker = (Worker)element$iv;
            boolean bl = false;
            if (worker.getSlimDistribution()) {
                Project project4 = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"getProject(...)");
                OverlaysUtil.Companion.addDatabaseDependency(project4, worker);
                Project project5 = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project5, (String)"getProject(...)");
                OverlaysUtil.Companion.addMqDependency(project5, worker);
                Project project6 = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project6, (String)"getProject(...)");
                if (CacheUtil.Companion.isCacheEnabled(project6)) {
                    Project project7 = this.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project7, (String)"getProject(...)");
                    OverlaysUtil.Companion.addCacheDependency(project7, worker);
                }
            }
            if (!worker.getOverlays().isEmpty()) {
                Project project8 = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project8, (String)"getProject(...)");
                if (!WorkerUtil.Companion.isExternalRuntimeWorker(project8, worker)) {
                    this.getLogger().warn("Overlays on the worker " + worker.getName() + " are ignored because worker's runtime directory is same to the master.");
                    continue;
                }
            }
            Map<String, List<Object>> $this$forEach$iv2 = worker.getOverlays();
            boolean $i$f$forEach2 = false;
            Iterator<Map.Entry<String, List<Object>>> iterator = $this$forEach$iv2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, List<Object>> element$iv2;
                Map.Entry<String, List<Object>> overlay = element$iv2 = iterator.next();
                boolean bl2 = false;
                Project project9 = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project9, (String)"getProject(...)");
                Task task2 = (Task)currentTask;
                Project project10 = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project10, (String)"getProject(...)");
                Object[] objectArray2 = new String[]{"downloadAndExtractWorkerServer" + worker.getName(), "syncServerPluginsWithWorker", "setWorkerLogbackLevels"};
                OverlaysUtil.Companion.defineOverlay$default(OverlaysUtil.Companion, project9, task2, WorkerUtil.Companion.getWorkerWorkingDir(project10, worker), PREFIX, overlay, CollectionsKt.arrayListOf((Object[])objectArray2), null, 64, null);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lai/digital/integration/server/deploy/tasks/worker/WorkerOverlaysTask$Companion;", "", "<init>", "()V", "NAME", "", "PREFIX", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

