/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks.cli;

import ai.digital.integration.server.deploy.domain.Cli;
import ai.digital.integration.server.deploy.internals.CliUtil;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0011H\u0007R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\"\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lai/digital/integration/server/deploy/tasks/cli/RunCliTask;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "secure", "Lorg/gradle/api/provider/Property;", "", "getSecure", "()Lorg/gradle/api/provider/Property;", "filesToExec", "", "Ljava/io/File;", "getFilesToExec", "()Ljava/util/List;", "setFilesToExec", "(Ljava/util/List;)V", "executeScripts", "", "cli", "Lai/digital/integration/server/deploy/domain/Cli;", "launch", "Companion", "integration-server-gradle-plugin"})
public abstract class RunCliTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private List<? extends File> filesToExec = new ArrayList();
    @NotNull
    public static final String NAME = "runCli";

    public RunCliTask() {
        Object[] objectArray = new Object[]{"cliCleanDefaultExt"};
        this.dependsOn(objectArray);
        objectArray = new Object[]{"cliOverlays"};
        this.dependsOn(objectArray);
        objectArray = new Object[]{"downloadAndExtractCli"};
        this.dependsOn(objectArray);
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (DeployServerUtil.Companion.isTls(project)) {
            objectArray = new Object[]{"tlsApplicationConfigurationOverride"};
            this.dependsOn(objectArray);
        }
        this.setGroup("Integration Server");
    }

    @Input
    @Option(option="security", description="Use true when TLS is enabled on the server side.")
    @Optional
    @NotNull
    public abstract Property<Boolean> getSecure();

    @Input
    @Option(option="files ", description="Additional files to Execute.")
    @Optional
    @NotNull
    public final List<File> getFilesToExec() {
        return this.filesToExec;
    }

    public final void setFilesToExec(@NotNull List<? extends File> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.filesToExec = list;
    }

    private final void executeScripts(Cli cli) {
        this.getProject().getLogger().lifecycle("Executing cli scripts ....");
        List<? extends File> filesExec = !((Collection)this.filesToExec).isEmpty() ? this.filesToExec : cli.getFilesToExecute();
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Object object = this.getSecure().getOrElse((Object)false);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getOrElse(...)");
        CliUtil.Companion.executeScripts$default(CliUtil.Companion, project, filesExec, "cli", (Boolean)object, null, false, 48, null);
    }

    @TaskAction
    public final void launch() {
        this.getProject().getLogger().lifecycle("Running a CLI provision script on the Deploy server.");
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.executeScripts(CliUtil.Companion.getCli(project));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lai/digital/integration/server/deploy/tasks/cli/RunCliTask$Companion;", "", "<init>", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

