/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.internals;

import ai.digital.integration.server.common.constant.ProductName;
import ai.digital.integration.server.common.domain.Test;
import ai.digital.integration.server.common.util.IdUtil;
import ai.digital.integration.server.common.util.IntegrationServerUtil;
import ai.digital.integration.server.common.util.ProcessUtil;
import ai.digital.integration.server.common.util.PropertyUtil;
import ai.digital.integration.server.deploy.domain.Cli;
import ai.digital.integration.server.deploy.internals.DeployExtensionUtil;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import ai.digital.integration.server.deploy.internals.EntryPointUrlUtil;
import ai.digital.integration.server.deploy.internals.EnvironmentUtil;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lai/digital/integration/server/deploy/internals/CliUtil;", "", "<init>", "()V", "Companion", "integration-server-gradle-plugin"})
public final class CliUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007J\u001f\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u000fH\u0002J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0005H\u0002JI\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u001a2\u0006\u0010\u0014\u001a\u00020\u000f2\b\b\u0002\u0010\u001b\u001a\u00020\t2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\u001d\u001a\u00020\t\u00a2\u0006\u0002\u0010\u001eJ4\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u001a2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020 J\u0081\u0001\u0010!\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u001a2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\t2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0#2\u0014\u0010$\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u000f0#2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00110\u001a2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\u001d\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u0010&\u00a8\u0006'"}, d2={"Lai/digital/integration/server/deploy/internals/CliUtil$Companion;", "", "<init>", "()V", "getCli", "Lai/digital/integration/server/deploy/domain/Cli;", "project", "Lorg/gradle/api/Project;", "hasCli", "", "getDebugPort", "", "cli", "(Lorg/gradle/api/Project;Lai/digital/integration/server/deploy/domain/Cli;)Ljava/lang/Integer;", "getWorkingDir", "", "getCliLogFolder", "Ljava/io/File;", "getCliExtFolder", "getCliLogFile", "label", "getCliBin", "getCliVersion", "executeScripts", "", "scriptSources", "", "secure", "deployPort", "auxiliaryServer", "(Lorg/gradle/api/Project;Ljava/util/List;Ljava/lang/String;ZLjava/lang/Integer;Z)V", "test", "Lai/digital/integration/server/common/domain/Test;", "runScripts", "extraEnvironments", "", "extraParams", "extraClassPath", "(Lorg/gradle/api/Project;Ljava/util/List;Ljava/lang/String;ZLjava/util/Map;Ljava/util/Map;Ljava/util/List;Ljava/lang/Integer;Z)V", "integration-server-gradle-plugin"})
    @SourceDebugExtension(value={"SMAP\nCliUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CliUtil.kt\nai/digital/integration/server/deploy/internals/CliUtil$Companion\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,184:1\n504#2,7:185\n126#3:192\n153#3,3:193\n*S KotlinDebug\n*F\n+ 1 CliUtil.kt\nai/digital/integration/server/deploy/internals/CliUtil$Companion\n*L\n133#1:185,7\n134#1:192\n134#1:193,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Cli getCli(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = DeployExtensionUtil.Companion.getExtension(project).getCli().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            Cli cli = (Cli)object;
            cli.setVersion(this.getCliVersion(project, cli));
            cli.setDebugPort(this.getDebugPort(project, cli));
            return cli;
        }

        public final boolean hasCli(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return this.getCli(project).getEnabled();
        }

        private final Integer getDebugPort(Project project, Cli cli) {
            return PropertyUtil.Companion.resolveBooleanValue(project, "debug", true) ? PropertyUtil.Companion.resolveIntValue(project, "cliDebugPort", cli.getDebugPort()) : null;
        }

        @NotNull
        public final String getWorkingDir(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            String version = this.getCli(project).getVersion();
            String targetDir = IntegrationServerUtil.Companion.getDist(project);
            String[] stringArray = new String[]{"xl-deploy-" + version + "-cli"};
            return ((Object)Paths.get(targetDir, stringArray).toAbsolutePath()).toString();
        }

        @NotNull
        public final File getCliLogFolder(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return new File(this.getWorkingDir(project), "log");
        }

        @NotNull
        public final File getCliExtFolder(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return new File(this.getWorkingDir(project), "ext");
        }

        private final File getCliLogFile(Project project, String label) {
            File file = Paths.get(this.getCliLogFolder(project) + "/" + label + "-" + IdUtil.Companion.shortId() + ".log", new String[0]).toFile();
            project.file((Object)file.getParent()).mkdirs();
            file.createNewFile();
            Intrinsics.checkNotNull((Object)file);
            return file;
        }

        private final File getCliBin(Project project) {
            String[] stringArray = new String[]{"bin"};
            File file = Paths.get(this.getWorkingDir(project), stringArray).toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            return file;
        }

        private final String getCliVersion(Project project, Cli cli) {
            String string;
            if (project.hasProperty("deployCliVersion")) {
                string = String.valueOf(project.property("deployCliVersion"));
            } else {
                CharSequence charSequence = cli.getVersion();
                if (!(charSequence == null || charSequence.length() == 0)) {
                    string = cli.getVersion();
                } else {
                    charSequence = DeployServerUtil.Companion.getServer(project).getVersion();
                    if (!(charSequence == null || charSequence.length() == 0)) {
                        string = DeployServerUtil.Companion.getServer(project).getVersion();
                    } else {
                        project.getLogger().error("CLI Version is not specified");
                        System.exit(1);
                        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
                    }
                }
            }
            return string;
        }

        public final void executeScripts(@NotNull Project project, @NotNull List<? extends File> scriptSources, @NotNull String label, boolean secure, @Nullable Integer deployPort, boolean auxiliaryServer) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(scriptSources, (String)"scriptSources");
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            if (!((Collection)scriptSources).isEmpty()) {
                this.runScripts(project, scriptSources, label, secure, MapsKt.emptyMap(), MapsKt.emptyMap(), CollectionsKt.emptyList(), deployPort, auxiliaryServer);
            }
        }

        public static /* synthetic */ void executeScripts$default(Companion companion, Project project, List list, String string, boolean bl, Integer n, boolean bl2, int n2, Object object) {
            if ((n2 & 8) != 0) {
                bl = false;
            }
            if ((n2 & 0x10) != 0) {
                n = null;
            }
            if ((n2 & 0x20) != 0) {
                bl2 = false;
            }
            companion.executeScripts(project, list, string, bl, n, bl2);
        }

        public final void executeScripts(@NotNull Project project, @NotNull List<? extends File> scriptSources, @NotNull String label, boolean secure, @NotNull Test test) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(scriptSources, (String)"scriptSources");
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            Intrinsics.checkNotNullParameter((Object)test, (String)"test");
            ai.digital.integration.server.deploy.internals.CliUtil$Companion.runScripts$default(this, project, scriptSources, label, secure, test.getEnvironments(), test.getSystemProperties(), test.getExtraClassPath(), null, false, 384, null);
        }

        /*
         * WARNING - void declaration
         */
        private final void runScripts(Project project, List<? extends File> scriptSources, String label, boolean secure, Map<String, String> extraEnvironments, Map<String, String> extraParams, List<? extends File> extraClassPath, Integer deployPort, boolean auxiliaryServer) {
            Object[] $this$mapTo$iv$iv;
            void $this$map$iv;
            Object it;
            Map $this$filterValues$iv;
            Cli cli = this.getCli(project);
            boolean clusterEnabled = DeployServerUtil.Companion.isClusterEnabled(project);
            Map<String, String> map = extraParams;
            boolean $i$f$filterValues = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
                it = (String)entry$iv.getValue();
                boolean bl = false;
                if (!(it != null)) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            $this$filterValues$iv = result$iv;
            boolean $i$f$map22 = false;
            result$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            it = $this$mapTo$iv$iv.entrySet().iterator();
            while (it.hasNext()) {
                void it2;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = (Map.Entry)it.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Object[] objectArray = new String[]{it2.getKey(), it2.getValue()};
                collection.add(CollectionsKt.arrayListOf((Object[])objectArray));
            }
            List extraParamsAsList = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
            Object $i$f$map22 = new String[15];
            $i$f$map22[0] = "-context";
            $i$f$map22[1] = new EntryPointUrlUtil(project, ProductName.DEPLOY, clusterEnabled).getContextRoot(auxiliaryServer);
            $i$f$map22[2] = "-expose-proxies";
            $i$f$map22[3] = "-password";
            $i$f$map22[4] = "admin";
            $i$f$map22[5] = "-port";
            Object object = deployPort;
            if (object == null || (object = ((Integer)object).toString()) == null) {
                object = new EntryPointUrlUtil(project, ProductName.DEPLOY, clusterEnabled).getHttpPort(auxiliaryServer);
            }
            $i$f$map22[6] = object;
            $i$f$map22[7] = "-host";
            $i$f$map22[8] = new EntryPointUrlUtil(project, ProductName.DEPLOY, clusterEnabled).getHttpHost(auxiliaryServer);
            $i$f$map22[9] = "-socketTimeout";
            $i$f$map22[10] = String.valueOf(cli.getSocketTimeout());
            $i$f$map22[11] = "-source";
            $i$f$map22[12] = CollectionsKt.joinToString$default((Iterable)scriptSources, (CharSequence)",", null, null, (int)0, null, Companion::runScripts$lambda$2, (int)30, null);
            $i$f$map22[13] = "-username";
            $i$f$map22[14] = "admin";
            List params = CollectionsKt.toMutableList((Collection)CollectionsKt.plus((Collection)CollectionsKt.arrayListOf((Object[])$i$f$map22), (Iterable)extraParamsAsList));
            if (!auxiliaryServer && (DeployServerUtil.Companion.isTls(project) || secure)) {
                $i$f$map22 = params;
                $this$mapTo$iv$iv = new String[]{"-secure"};
                CollectionsKt.addAll((Collection)$i$f$map22, (Object[])$this$mapTo$iv$iv);
            }
            File workDir = this.getCliBin(project);
            File scriptLogFile = this.getCliLogFile(project, label);
            String ext = Os.isFamily((String)"windows") ? "cmd" : "sh";
            String commandLine = workDir + " ./cli." + ext + " " + CollectionsKt.joinToString$default((Iterable)params, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
            project.getLogger().lifecycle("Running this command now: " + commandLine + ", logs can be found in " + scriptLogFile);
            Map environment = MapsKt.plus((Map)MapsKt.plus(cli.getEnvironments(), extraEnvironments), EnvironmentUtil.Companion.getCliEnv(project, cli, extraParams, extraClassPath, auxiliaryServer));
            project.getLogger().info("Starting worker with environment: " + environment);
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"command", (Object)"cli"), TuplesKt.to((Object)"environment", (Object)environment), TuplesKt.to((Object)"params", (Object)params), TuplesKt.to((Object)"redirectTo", (Object)scriptLogFile), TuplesKt.to((Object)"wait", (Object)true), TuplesKt.to((Object)"workDir", (Object)workDir)};
            ProcessUtil.Companion.execAndCheck(MapsKt.mutableMapOf((Pair[])pairArray), scriptLogFile);
        }

        static /* synthetic */ void runScripts$default(Companion companion, Project project, List list, String string, boolean bl, Map map, Map map2, List list2, Integer n, boolean bl2, int n2, Object object) {
            if ((n2 & 0x80) != 0) {
                n = null;
            }
            if ((n2 & 0x100) != 0) {
                bl2 = false;
            }
            companion.runScripts(project, list, string, bl, map, map2, list2, n, bl2);
        }

        private static final CharSequence runScripts$lambda$2(File source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            String string = source.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

