/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.pluginManager;

import ai.digital.integration.server.common.domain.Server;
import ai.digital.integration.server.common.util.ProcessUtil;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import ai.digital.integration.server.deploy.internals.EnvironmentUtil;
import java.io.File;
import java.nio.file.Paths;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\b\u0010\n\u001a\u00020\u0007H\u0007\u00a8\u0006\f"}, d2={"Lai/digital/integration/server/common/pluginManager/StartPluginManagerTask;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "getBinDir", "Ljava/io/File;", "startPluginManager", "", "server", "Lai/digital/integration/server/common/domain/Server;", "launch", "Companion", "integration-server-gradle-plugin"})
public class StartPluginManagerTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "startPluginManager";

    public StartPluginManagerTask() {
        Object[] objectArray = new String[]{"startDeployServerInstance"};
        List dependencies = CollectionsKt.mutableListOf((Object[])objectArray);
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (DeployServerUtil.Companion.isTls(project)) {
            dependencies.add("tlsApplicationConfigurationOverride");
        }
        objectArray = new Object[]{dependencies};
        this.dependsOn(objectArray);
        this.setGroup("Integration Server");
        this.onlyIf(new Spec(){

            public final boolean isSatisfiedBy(Task it) {
                Project project = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                return !DeployServerUtil.Companion.isDockerBased(project);
            }
        });
    }

    private final File getBinDir() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        String[] stringArray = new String[]{"bin"};
        File file = Paths.get(DeployServerUtil.Companion.getServerWorkingDir(project), stringArray).toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        return file;
    }

    private final void startPluginManager(Server server) {
        Pair[] pairArray = new Pair[5];
        pairArray[0] = TuplesKt.to((Object)"command", (Object)"run");
        pairArray[1] = TuplesKt.to((Object)"discardIO", (Object)true);
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        pairArray[2] = TuplesKt.to((Object)"environment", EnvironmentUtil.Companion.getServerEnv(project, server));
        String[] stringArray = new String[]{"plugin-manager-cli"};
        pairArray[3] = TuplesKt.to((Object)"params", (Object)stringArray);
        pairArray[4] = TuplesKt.to((Object)"workDir", (Object)this.getBinDir());
        Process process = ProcessUtil.Companion.exec(MapsKt.mapOf((Pair[])pairArray));
        this.getProject().getLogger().lifecycle("Launched Plugin Manager on Deploy server " + server + ".name on PID [" + process.pid() + "] with command [" + process.info().commandLine().orElse("") + "].");
    }

    @TaskAction
    public final void launch() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Server server = DeployServerUtil.Companion.getServer(project);
        this.getProject().getLogger().lifecycle("Launching Plugin Manager on Deploy server " + server + ".name");
        this.startPluginManager(server);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lai/digital/integration/server/common/pluginManager/StartPluginManagerTask$Companion;", "", "<init>", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

