/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.internals;

import ai.digital.integration.server.common.constant.ProductName;
import ai.digital.integration.server.common.domain.Server;
import ai.digital.integration.server.common.util.HTTPUtil;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import ai.digital.integration.server.deploy.internals.EntryPointUrlUtil;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lai/digital/integration/server/deploy/internals/DeployShutdownUtil;", "", "<init>", "()V", "Companion", "integration-server-gradle-plugin"})
public final class DeployShutdownUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0002J\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\f"}, d2={"Lai/digital/integration/server/deploy/internals/DeployShutdownUtil$Companion;", "", "<init>", "()V", "waitForShutdown", "", "project", "Lorg/gradle/api/Project;", "killProcessByPort", "port", "", "shutdownServer", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        private final void waitForShutdown(Project project) {
            Server server = DeployServerUtil.Companion.getServer(project);
            int triesLeft = server.getPingTotalTries();
            boolean success = false;
            while (triesLeft > 0 && !success) {
                try {
                    HttpClient client = HttpClient.newHttpClient();
                    HttpRequest request = HTTPUtil.Companion.doRequest$default(HTTPUtil.Companion, EntryPointUrlUtil.composeUrl$default(new EntryPointUrlUtil(project, ProductName.DEPLOY, false, 4, null), server.getContextRoot(), false, 2, null), null, null, 6, null).POST(HttpRequest.BodyPublishers.noBody()).build();
                    HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                    project.getLogger().lifecycle("Waiting " + server.getPingRetrySleepTime() + " seconds for shutdown. (" + triesLeft + ")");
                    TimeUnit.SECONDS.sleep(server.getPingRetrySleepTime());
                    if (response.statusCode() == 200) continue;
                    project.getLogger().lifecycle("XL Deploy server successfully shutdown");
                    success = true;
                }
                catch (Exception ignored) {
                    project.getLogger().lifecycle("XL Deploy server successfully shutdown.");
                    success = true;
                    break;
                }
            }
            if (!success) {
                throw new GradleException("Server failed to stop");
            }
        }

        private final void killProcessByPort(Project project, int port) {
            try {
                project.getLogger().lifecycle("Attempting to kill process on port " + port);
                String string = System.getProperty("os.name");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
                String string2 = string.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                String osName = string2;
                if (StringsKt.contains$default((CharSequence)osName, (CharSequence)"windows", (boolean)false, (int)2, null)) {
                    String[] stringArray = new String[]{"cmd", "/c", "netstat -ano | findstr :" + port};
                    ProcessBuilder findProcess = new ProcessBuilder(stringArray);
                    findProcess.redirectErrorStream(true);
                    Process findResult = findProcess.start();
                    InputStream inputStream = findResult.getInputStream();
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
                    InputStream inputStream2 = inputStream;
                    Charset charset = Charsets.UTF_8;
                    Reader reader = new InputStreamReader(inputStream2, charset);
                    int n = 8192;
                    String output = TextStreamsKt.readText((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)));
                    findResult.waitFor();
                    Regex pidPattern = new Regex("LISTENING\\s+(\\d+)");
                    MatchResult match = Regex.find$default((Regex)pidPattern, (CharSequence)output, (int)0, (int)2, null);
                    if (match != null) {
                        String pid = (String)match.getGroupValues().get(1);
                        project.getLogger().lifecycle("Found process " + pid + " on port " + port + ", attempting to kill");
                        String[] stringArray2 = new String[]{"taskkill", "/F", "/PID", pid};
                        ProcessBuilder killProcess = new ProcessBuilder(stringArray2);
                        killProcess.redirectErrorStream(true);
                        Process killResult = killProcess.start();
                        killResult.waitFor(10L, TimeUnit.SECONDS);
                        project.getLogger().lifecycle("Forcefully killed process " + pid);
                    } else {
                        project.getLogger().lifecycle("No process found listening on port " + port);
                    }
                } else if (StringsKt.contains$default((CharSequence)osName, (CharSequence)"linux", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)osName, (CharSequence)"mac", (boolean)false, (int)2, null)) {
                    Object findResult = new String[]{"sh", "-c", "lsof -ti:" + port};
                    ProcessBuilder findProcess = new ProcessBuilder((String[])findResult);
                    findProcess.redirectErrorStream(true);
                    findResult = findProcess.start();
                    InputStream inputStream = ((Process)findResult).getInputStream();
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
                    InputStream pidPattern = inputStream;
                    String[] match = Charsets.UTF_8;
                    Reader reader = new InputStreamReader(pidPattern, (Charset)match);
                    int n = 8192;
                    String pid = ((Object)StringsKt.trim((CharSequence)TextStreamsKt.readText((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n))))).toString();
                    ((Process)findResult).waitFor();
                    if (((CharSequence)pid).length() > 0) {
                        project.getLogger().lifecycle("Found process " + pid + " on port " + port + ", attempting to kill");
                        match = new String[]{"kill", "-9", pid};
                        ProcessBuilder killProcess = new ProcessBuilder(match);
                        killProcess.redirectErrorStream(true);
                        Process killResult = killProcess.start();
                        killResult.waitFor(10L, TimeUnit.SECONDS);
                        project.getLogger().lifecycle("Forcefully killed process " + pid);
                    } else {
                        project.getLogger().lifecycle("No process found listening on port " + port);
                    }
                }
                TimeUnit.SECONDS.sleep(2L);
            }
            catch (Exception e) {
                project.getLogger().warn("Failed to kill process on port " + port + ": " + e.getMessage());
            }
        }

        public final void shutdownServer(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Server server = DeployServerUtil.Companion.getServer(project);
            int port = server.getHttpPort();
            boolean gracefulShutdownSucceeded = false;
            try {
                project.getLogger().lifecycle("Trying to shutdown integration server on port " + port);
                HttpClient client = HttpClient.newHttpClient();
                HttpRequest request = HTTPUtil.Companion.doRequest$default(HTTPUtil.Companion, EntryPointUrlUtil.composeUrl$default(new EntryPointUrlUtil(project, ProductName.DEPLOY, false, 4, null), "/deployit/server/shutdown", false, 2, null), null, null, 6, null).POST(HttpRequest.BodyPublishers.noBody()).build();
                client.send(request, HttpResponse.BodyHandlers.ofString());
                this.waitForShutdown(project);
                project.getLogger().lifecycle("Integration server at port " + port + " is now shutdown");
                gracefulShutdownSucceeded = true;
            }
            catch (Exception ignored) {
                project.getLogger().lifecycle("Integration server on port " + port + " is not responding to graceful shutdown");
            }
            if (!gracefulShutdownSucceeded) {
                this.killProcessByPort(project, port);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

