/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.util;

import ai.digital.integration.server.common.util.DbUtil;
import ai.digital.integration.server.common.util.FileUtil;
import ai.digital.integration.server.deploy.config.LogbackConfigs;
import java.io.File;
import java.io.FileInputStream;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lai/digital/integration/server/common/util/LogbackUtil;", "", "<init>", "()V", "Companion", "integration-server-gradle-plugin"})
public final class LogbackUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002J*\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00062\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\r\u00a8\u0006\u000e"}, d2={"Lai/digital/integration/server/common/util/LogbackUtil$Companion;", "", "<init>", "()V", "getHardCodedLevels", "", "", "project", "Lorg/gradle/api/Project;", "setLogLevels", "", "workingDir", "customLogLevels", "", "integration-server-gradle-plugin"})
    @SourceDebugExtension(value={"SMAP\nLogbackUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogbackUtil.kt\nai/digital/integration/server/common/util/LogbackUtil$Companion\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,63:1\n216#2,2:64\n*S KotlinDebug\n*F\n+ 1 LogbackUtil.kt\nai/digital/integration/server/common/util/LogbackUtil$Companion\n*L\n38#1:64,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final Map<String, String> getHardCodedLevels(Project project) {
            return DbUtil.Companion.getDatabase(project).getLogSql() ? LogbackConfigs.Companion.getToLogSql() : (Map)new LinkedHashMap();
        }

        public final void setLogLevels(@NotNull Project project, @NotNull String workingDir, @NotNull Map<String, String> customLogLevels) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
            Intrinsics.checkNotNullParameter(customLogLevels, (String)"customLogLevels");
            String logbackConfig = workingDir + "/conf/logback.xml";
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            Intrinsics.checkNotNullExpressionValue((Object)documentBuilderFactory, (String)"newInstance(...)");
            DocumentBuilderFactory factory = documentBuilderFactory;
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            Intrinsics.checkNotNullExpressionValue((Object)documentBuilder, (String)"newDocumentBuilder(...)");
            DocumentBuilder builder = documentBuilder;
            Document document = builder.parse(new FileInputStream(logbackConfig));
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"parse(...)");
            Document doc = document;
            Map logLevels = MapsKt.plus(this.getHardCodedLevels(project), customLogLevels);
            Node configurationNode = doc.getElementsByTagName("configuration").item(0);
            Map $this$forEach$iv = logLevels;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Element logLevelNode;
                Map.Entry element$iv;
                Map.Entry logLevel = element$iv = iterator.next();
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)doc.createElement("logger"), (String)"createElement(...)");
                logLevelNode.setAttribute("name", (String)logLevel.getKey());
                logLevelNode.setAttribute("level", (String)logLevel.getValue());
                configurationNode.appendChild(logLevelNode);
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Intrinsics.checkNotNullExpressionValue((Object)transformerFactory, (String)"newInstance(...)");
            TransformerFactory transformerFactory2 = transformerFactory;
            Transformer transformer = transformerFactory2.newTransformer();
            Intrinsics.checkNotNullExpressionValue((Object)transformer, (String)"newTransformer(...)");
            Transformer transf = transformer;
            transf.setOutputProperty("encoding", "UTF-8");
            transf.setOutputProperty("indent", "yes");
            transf.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            DOMSource source = new DOMSource(doc);
            File logbackFile = new File(logbackConfig);
            StreamResult logbackSreamResult = new StreamResult(logbackFile);
            transf.transform(source, logbackSreamResult);
            String string = FilesKt.readText((File)logbackFile, (Charset)Charsets.UTF_8);
            File file = project.file((Object)logbackConfig);
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file(...)");
            FileUtil.Companion.removeEmptyLines(string, file);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

