/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks.tests;

import ai.digital.integration.server.common.domain.Server;
import ai.digital.integration.server.common.domain.Test;
import ai.digital.integration.server.common.util.FileUtil;
import ai.digital.integration.server.common.util.TestUtil;
import ai.digital.integration.server.deploy.internals.CliUtil;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J\b\u0010\u000b\u001a\u00020\u0005H\u0007\u00a8\u0006\r"}, d2={"Lai/digital/integration/server/deploy/tasks/tests/IntegrationTestsTask;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "executeScripts", "", "server", "Lai/digital/integration/server/common/domain/Server;", "tests", "", "Lai/digital/integration/server/common/domain/Test;", "launch", "Companion", "integration-server-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nIntegrationTestsTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntegrationTestsTask.kt\nai/digital/integration/server/deploy/tasks/tests/IntegrationTestsTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,61:1\n1869#2:62\n1869#2,2:63\n1869#2,2:65\n1870#2:67\n*S KotlinDebug\n*F\n+ 1 IntegrationTestsTask.kt\nai/digital/integration/server/deploy/tasks/tests/IntegrationTestsTask\n*L\n27#1:62\n35#1:63,2\n41#1:65,2\n27#1:67\n*E\n"})
public class IntegrationTestsTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "integrationTests";

    public IntegrationTestsTask() {
        this.setGroup("Integration Server");
    }

    private final void executeScripts(Server server, List<? extends Test> tests) {
        this.getProject().getLogger().lifecycle("Executing test scripts ....");
        Iterable $this$forEach$iv = tests;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File dir;
            Test test = (Test)element$iv;
            boolean bl = false;
            this.getProject().getLogger().lifecycle("About to execute test `" + test.getName() + "` ...");
            List filesToExecute = new ArrayList();
            List filesForTeardown = new ArrayList();
            if (test.getBaseDirectory() == null) continue;
            boolean bl2 = false;
            String basedir = dir.getAbsolutePath();
            Iterable $this$forEach$iv2 = test.getSetupScripts();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String setupScript = (String)element$iv2;
                boolean bl3 = false;
                Intrinsics.checkNotNull((Object)basedir);
                filesToExecute.addAll((Collection)FileUtil.Companion.findFiles(basedir, "/" + setupScript + "$"));
            }
            Intrinsics.checkNotNull((Object)basedir);
            filesToExecute.addAll((Collection)FileUtil.Companion.findFiles(basedir, test.getScriptPattern(), test.getExcludesPattern()));
            $this$forEach$iv2 = test.getTearDownScripts();
            $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String teardownScript = (String)element$iv2;
                boolean bl4 = false;
                filesToExecute.addAll((Collection)FileUtil.Companion.findFiles(basedir, "/" + teardownScript + "$"));
                filesForTeardown.addAll((Collection)FileUtil.Companion.findFiles(basedir, "/" + teardownScript + "$"));
            }
            try {
                Project project = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                CliUtil.Companion.executeScripts(project, filesToExecute, "test", server.getTls(), test);
            }
            catch (Exception ignored) {
                Project project = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                CliUtil.Companion.executeScripts(project, filesForTeardown, "teardown", server.getTls(), test);
            }
        }
    }

    @TaskAction
    public final void launch() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        FilesKt.deleteRecursively((File)CliUtil.Companion.getCliLogFolder(project));
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        Server server = DeployServerUtil.Companion.getServer(project2);
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
        this.executeScripts(server, TestUtil.Companion.getExecutableTests(project3));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lai/digital/integration/server/deploy/tasks/tests/IntegrationTestsTask$Companion;", "", "<init>", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

