/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks.server;

import ai.digital.integration.server.common.domain.Server;
import ai.digital.integration.server.common.util.DbUtil;
import ai.digital.integration.server.common.util.LogbackUtil;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import ai.digital.integration.server.deploy.tasks.server.DownloadAndExtractServerDistTask;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0007"}, d2={"Lai/digital/integration/server/deploy/tasks/server/SetServerLogbackLevelsTask;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "setLevels", "", "Companion", "integration-server-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nSetServerLogbackLevelsTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SetServerLogbackLevelsTask.kt\nai/digital/integration/server/deploy/tasks/server/SetServerLogbackLevelsTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,33:1\n1869#2,2:34\n*S KotlinDebug\n*F\n+ 1 SetServerLogbackLevelsTask.kt\nai/digital/integration/server/deploy/tasks/server/SetServerLogbackLevelsTask\n*L\n25#1:34,2\n*E\n"})
public class SetServerLogbackLevelsTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "setLogbackLevels";

    public SetServerLogbackLevelsTask() {
        this.setGroup("Integration Server");
        Object[] objectArray = new Object[]{DownloadAndExtractServerDistTask.Companion.getNAME()};
        this.mustRunAfter(objectArray);
        this.onlyIf(new Spec(){

            public final boolean isSatisfiedBy(Task it) {
                Project project = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                return !DeployServerUtil.Companion.isDockerBased(project);
            }
        });
    }

    @TaskAction
    public final void setLevels() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Iterable $this$forEach$iv = DeployServerUtil.Companion.getServers(project);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Server server = (Server)element$iv;
            boolean bl = false;
            Project project2 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            if (!DbUtil.Companion.getDatabase(project2).getLogSql() && !(!server.getLogLevels().isEmpty())) continue;
            this.getProject().getLogger().lifecycle("Setting logback level on Deploy Server " + server.getName());
            Project project3 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
            Project project4 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"getProject(...)");
            LogbackUtil.Companion.setLogLevels(project3, DeployServerUtil.Companion.getServerWorkingDir(project4, server), server.getLogLevels());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lai/digital/integration/server/deploy/tasks/server/SetServerLogbackLevelsTask$Companion;", "", "<init>", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

