/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks.server;

import ai.digital.integration.server.common.cluster.util.OperatorUtil;
import ai.digital.integration.server.common.domain.PekkoSecured;
import ai.digital.integration.server.common.domain.Server;
import ai.digital.integration.server.common.util.DbUtil;
import ai.digital.integration.server.common.util.MqUtil;
import ai.digital.integration.server.common.util.TlsUtil;
import ai.digital.integration.server.common.util.YamlFileUtil;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import ai.digital.integration.server.deploy.internals.SatelliteUtil;
import ai.digital.integration.server.deploy.internals.WorkerUtil;
import ai.digital.integration.server.deploy.tasks.server.DownloadAndExtractServerDistTask;
import com.fasterxml.jackson.core.TreeNode;
import java.io.File;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0016\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J\u001c\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J-\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u0005H\u0007\u00a8\u0006\u0017"}, d2={"Lai/digital/integration/server/deploy/tasks/server/CentralConfigurationTask;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "overlayRepositoryConfig", "", "serverDir", "", "createCentralConfigurationFiles", "server", "Lai/digital/integration/server/common/domain/Server;", "taskConfig", "", "", "project", "Lorg/gradle/api/Project;", "mq", "mqName", "mqPort", "", "(Ljava/lang/String;Ljava/lang/Integer;)Ljava/util/Map;", "launch", "Companion", "integration-server-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nCentralConfigurationTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CentralConfigurationTask.kt\nai/digital/integration/server/deploy/tasks/server/CentralConfigurationTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,181:1\n1869#2,2:182\n*S KotlinDebug\n*F\n+ 1 CentralConfigurationTask.kt\nai/digital/integration/server/deploy/tasks/server/CentralConfigurationTask\n*L\n174#1:182,2\n*E\n"})
public class CentralConfigurationTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "centralConfiguration";

    public CentralConfigurationTask() {
        this.setGroup("Integration Server");
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (!new OperatorUtil(project).isClusterEnabled()) {
            Object[] objectArray = new Object[]{DownloadAndExtractServerDistTask.Companion.getNAME()};
            this.dependsOn(objectArray);
        }
    }

    private final void overlayRepositoryConfig(String serverDir) {
        this.getProject().getLogger().lifecycle("Creating custom deploy-repository.yaml");
        File deployRepositoryYaml = new File(serverDir + "/centralConfiguration/deploy-repository.yaml");
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        TreeNode treeNode = DbUtil.Companion.dbConfig(project);
        if (treeNode != null) {
            TreeNode config = treeNode;
            boolean bl = false;
            YamlFileUtil.Companion.writeFileValue$default(YamlFileUtil.Companion, deployRepositoryYaml, config, false, 4, null);
        }
        String string = FilesKt.readText((File)deployRepositoryYaml, (Charset)Charsets.UTF_8);
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        String configuredTemplate = StringsKt.replace$default((String)string, (String)"{{DB_PORT}}", (String)String.valueOf(DbUtil.Companion.getPort(project2)), (boolean)false, (int)4, null);
        FilesKt.writeText$default((File)deployRepositoryYaml, (String)configuredTemplate, null, (int)2, null);
    }

    private final void createCentralConfigurationFiles(Server server) {
        this.getProject().getLogger().lifecycle("Generating initial central configuration files for server " + server.getName());
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        String serverDir = DeployServerUtil.Companion.getServerWorkingDir(project, server);
        this.overlayRepositoryConfig(serverDir);
        this.getProject().getLogger().lifecycle("Creating custom deploy-server.yaml");
        Map serverYaml = new LinkedHashMap();
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        if (DeployServerUtil.Companion.isPekkoSecured(project2)) {
            PekkoSecured secured;
            Project project3 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
            Project project4 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"getProject(...)");
            PekkoSecured pekkoSecured = secured = TlsUtil.Companion.getPekkoSecured(project3, DeployServerUtil.Companion.getServerWorkingDir(project4));
            if (pekkoSecured != null) {
                PekkoSecured sec = pekkoSecured;
                boolean bl = false;
                Map<String, PekkoSecured.KeyMeta> map = sec.getKeys();
                Project project5 = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project5, (String)"getProject(...)");
                PekkoSecured.KeyMeta key = map.get("pekko_ssl_master_" + DeployServerUtil.Companion.getServer(project5).getName());
                if (key != null) {
                    Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"deploy.server.ssl.enabled", (Object)true), TuplesKt.to((Object)"deploy.server.ssl.key-store", (Object)key.keyStoreFile().getAbsolutePath()), TuplesKt.to((Object)"deploy.server.ssl.key-store-password", (Object)key.getKeyStorePassword()), TuplesKt.to((Object)"deploy.server.ssl.trust-store", (Object)sec.trustStoreFile().getAbsolutePath()), TuplesKt.to((Object)"deploy.server.ssl.trust-store-password", (Object)sec.getTruststorePassword())};
                    serverYaml.putAll(MapsKt.mutableMapOf((Pair[])pairArray));
                    serverYaml.put("deploy.server.ssl.key-password", key.getKeyPassword());
                }
            }
        }
        YamlFileUtil.Companion.overlayFileWithJackson$default(YamlFileUtil.Companion, new File(serverDir + "/centralConfiguration/deploy-server.yaml"), serverYaml, null, false, 12, null);
        this.getProject().getLogger().lifecycle("Creating custom deploy-cluster.yaml");
        File clusterYaml = new File(serverDir + "/centralConfiguration/deploy-cluster.yaml");
        Map clusterYamlMap = new LinkedHashMap();
        Project project6 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project6, (String)"getProject(...)");
        String mode = DeployServerUtil.Companion.clusterMode(project6);
        Pair[] bl = new Pair[]{TuplesKt.to((Object)"deploy.cluster.mode", (Object)mode), TuplesKt.to((Object)"deploy.cluster.name", (Object)("deploy-" + mode + "-mode"))};
        clusterYamlMap.putAll(MapsKt.mutableMapOf((Pair[])bl));
        if (Intrinsics.areEqual((Object)mode, (Object)"full") || Intrinsics.areEqual((Object)mode, (Object)"hot-standby")) {
            bl = new Pair[4];
            Project project7 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project7, (String)"getProject(...)");
            bl[0] = TuplesKt.to((Object)"deploy.cluster.membership.jdbc.url", (Object)DbUtil.Companion.getDbPropValue(project7, "db-url"));
            Project project8 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project8, (String)"getProject(...)");
            bl[1] = TuplesKt.to((Object)"deploy.cluster.membership.jdbc.driver", (Object)DbUtil.Companion.getDbPropValue(project8, "db-driver-classname"));
            Project project9 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project9, (String)"getProject(...)");
            bl[2] = TuplesKt.to((Object)"deploy.cluster.membership.jdbc.username", (Object)DbUtil.Companion.getDbPropValue(project9, "db-username"));
            Project project10 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project10, (String)"getProject(...)");
            bl[3] = TuplesKt.to((Object)"deploy.cluster.membership.jdbc.password", (Object)DbUtil.Companion.getDbPropValue(project10, "db-password"));
            clusterYamlMap.putAll(MapsKt.mutableMapOf((Pair[])bl));
        }
        YamlFileUtil.Companion.overlayFileWithJackson$default(YamlFileUtil.Companion, clusterYaml, clusterYamlMap, null, false, 12, null);
        String string = FilesKt.readText((File)clusterYaml, (Charset)Charsets.UTF_8);
        Project project11 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project11, (String)"getProject(...)");
        String configuredTemplate = StringsKt.replace$default((String)string, (String)"{{DB_PORT}}", (String)String.valueOf(DbUtil.Companion.getPort(project11)), (boolean)false, (int)4, null);
        FilesKt.writeText$default((File)clusterYaml, (String)configuredTemplate, null, (int)2, null);
        this.getProject().getLogger().lifecycle("Creating custom deploy-task.yaml");
        File file = new File(serverDir + "/centralConfiguration/deploy-task.yaml");
        Project project12 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project12, (String)"getProject(...)");
        YamlFileUtil.Companion.overlayFileWithJackson$default(YamlFileUtil.Companion, file, this.taskConfig(project12), null, false, 12, null);
        Project project13 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project13, (String)"getProject(...)");
        if (SatelliteUtil.Companion.hasSatellites(project13)) {
            this.getProject().getLogger().lifecycle("Creating custom deploy-satellite.yaml");
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"deploy.satellite.enabled", (Object)true)};
            YamlFileUtil.Companion.overlayFileWithJackson$default(YamlFileUtil.Companion, new File(serverDir + "/centralConfiguration/deploy-satellite.yaml"), MapsKt.mutableMapOf((Pair[])pairArray), null, false, 12, null);
        }
    }

    private final Map<String, Object> taskConfig(Project project) {
        Map map;
        Map<String, String> mqDetail = this.mq(MqUtil.Companion.mqName(project), MqUtil.Companion.mqPort(project));
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"deploy.task.queue.name", (Object)"xld-tasks-queue"), TuplesKt.to((Object)"deploy.task.queue.archive-queue-name", (Object)"xld-archive-queue")};
        Map config = MapsKt.mutableMapOf((Pair[])pairArray);
        if (WorkerUtil.Companion.hasWorkers(project)) {
            pairArray = new Pair[]{TuplesKt.to((Object)"deploy.task.in-process-worker", (Object)"false"), TuplesKt.to((Object)"deploy.task.queue.external.jms-driver-classname", (Object)String.valueOf(mqDetail.get("jms-driver-classname"))), TuplesKt.to((Object)"deploy.task.queue.external.jms-password", (Object)String.valueOf(mqDetail.get("jms-password"))), TuplesKt.to((Object)"deploy.task.queue.external.jms-url", (Object)String.valueOf(mqDetail.get("jms-url"))), TuplesKt.to((Object)"deploy.task.queue.external.jms-username", (Object)String.valueOf(mqDetail.get("jms-username"))), TuplesKt.to((Object)"pekko.io.dns.resolver", (Object)"inet-address")};
            map = MapsKt.mutableMapOf((Pair[])pairArray);
        } else {
            pairArray = new Pair[]{TuplesKt.to((Object)"deploy.task.in-process-worker", (Object)"true")};
            map = MapsKt.mutableMapOf((Pair[])pairArray);
        }
        config.putAll(map);
        return config;
    }

    private final Map<String, String> mq(String mqName, Integer mqPort) {
        boolean hasPort = mqPort != null && mqPort > 0;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"jms-driver-classname", (Object)"com.rabbitmq.jms.admin.RMQConnectionFactory"), TuplesKt.to((Object)"jms-password", (Object)"guest"), TuplesKt.to((Object)"jms-url", (Object)("amqp://localhost:" + (hasPort ? mqPort : "5672"))), TuplesKt.to((Object)"jms-username", (Object)"guest")};
        Map rabbitMq = MapsKt.mutableMapOf((Pair[])pairArray);
        Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)"jms-driver-classname", (Object)"org.apache.activemq.ActiveMQConnectionFactory"), TuplesKt.to((Object)"jms-password", (Object)"admin"), TuplesKt.to((Object)"jms-url", (Object)("tcp://localhost:" + (hasPort ? mqPort : "61616"))), TuplesKt.to((Object)"jms-username", (Object)"admin")};
        Map activeMq = MapsKt.mutableMapOf((Pair[])pairArray2);
        return Intrinsics.areEqual((Object)"activemq", (Object)mqName) ? activeMq : rabbitMq;
    }

    @TaskAction
    public final void launch() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Iterable $this$forEach$iv = DeployServerUtil.Companion.getServers(project);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Server server = (Server)element$iv;
            boolean bl = false;
            if (!(server.numericVersion() >= 10.2)) continue;
            this.createCentralConfigurationFiles(server);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lai/digital/integration/server/deploy/tasks/server/CentralConfigurationTask$Companion;", "", "<init>", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

