/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecResult;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lai/digital/integration/server/common/util/ProcessUtil;", "", "<init>", "()V", "Companion", "integration-server-gradle-plugin"})
public final class ProcessUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\"\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fJ.\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00062\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u00152\b\b\u0002\u0010\u0016\u001a\u00020\tJ\u001c\u0010\u0013\u001a\u00020\u00172\u0014\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00010\rJ\u001e\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0006J8\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u00062\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u000f2\b\b\u0002\u0010\u0016\u001a\u00020\t2\b\b\u0002\u0010\u001e\u001a\u00020\t2\b\b\u0002\u0010\u001f\u001a\u00020 JB\u0010\u001b\u001a\u00020\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001c\u001a\u00020\u00062\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u000f2\b\b\u0002\u0010\u0016\u001a\u00020\t2\b\b\u0002\u0010\u001e\u001a\u00020\t2\b\b\u0002\u0010\u001f\u001a\u00020 J$\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020#2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0%H\u0002\u00a8\u0006&"}, d2={"Lai/digital/integration/server/common/util/ProcessUtil$Companion;", "", "<init>", "()V", "createRunCommand", "", "", "baseCommand", "runLocalShell", "", "execAndCheck", "", "config", "", "logFile", "Ljava/io/File;", "execute", "project", "Lorg/gradle/api/Project;", "exec", "arguments", "", "logOutput", "Ljava/lang/Process;", "chMod", "mode", "fileName", "executeCommand", "command", "workDir", "throwErrorOnFailure", "waitTimeoutSeconds", "", "readLines", "reader", "Ljava/io/BufferedReader;", "lineHandler", "Lkotlin/Function1;", "integration-server-gradle-plugin"})
    @SourceDebugExtension(value={"SMAP\nProcessUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProcessUtil.kt\nai/digital/integration/server/common/util/ProcessUtil$Companion\n+ 2 ProjectExtensions.kt\norg/gradle/kotlin/dsl/support/ProjectExtensionsKt\n+ 3 ServiceRegistryExtensions.kt\norg/gradle/kotlin/dsl/support/ServiceRegistryExtensionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,210:1\n27#2:211\n27#2:213\n27#2:215\n22#3:212\n22#3:214\n22#3:216\n1#4:217\n*S KotlinDebug\n*F\n+ 1 ProcessUtil.kt\nai/digital/integration/server/common/util/ProcessUtil$Companion\n*L\n40#1:211\n55#1:213\n121#1:215\n40#1:212\n55#1:214\n121#1:216\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final List<String> createRunCommand(String baseCommand, boolean runLocalShell) {
            List list;
            if (runLocalShell) {
                if (Os.isFamily((String)"windows")) {
                    Object[] objectArray = new String[]{"cmd", "/c", baseCommand + ".cmd"};
                    list = CollectionsKt.mutableListOf((Object[])objectArray);
                } else {
                    Object[] objectArray = new String[]{"./" + baseCommand + ".sh"};
                    list = CollectionsKt.mutableListOf((Object[])objectArray);
                }
            } else {
                Object[] objectArray = new String[]{baseCommand};
                list = CollectionsKt.mutableListOf((Object[])objectArray);
            }
            return list;
        }

        public final void execAndCheck(@NotNull Map<String, ? extends Object> config, @NotNull File logFile) {
            Intrinsics.checkNotNullParameter(config, (String)"config");
            Intrinsics.checkNotNullParameter((Object)logFile, (String)"logFile");
            if (this.exec(config).exitValue() == 1) {
                throw new RuntimeException("Running process was not successfully executed. Check logs [" + logFile + "] for more information.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final String execute(@NotNull Project project, @NotNull String exec, @NotNull List<String> arguments, boolean logOutput) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)exec, (String)"exec");
            Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
            project.getLogger().lifecycle("About to execute `" + exec + " " + CollectionsKt.joinToString$default((Iterable)arguments, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + "`");
            if (logOutput) {
                try (ByteArrayOutputStream stdout = new ByteArrayOutputStream();){
                    Project $this$serviceOf$iv = project;
                    boolean $i$f$serviceOf22 = false;
                    ServiceRegistry serviceRegistry = ((ProjectInternal)$this$serviceOf$iv).getServices();
                    Intrinsics.checkNotNullExpressionValue((Object)serviceRegistry, (String)"getServices(...)");
                    ServiceRegistry $this$get$iv$iv = serviceRegistry;
                    boolean $i$f$get = false;
                    Object object = $this$get$iv$iv.get(ExecOperations.class);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                    ExecOperations execOps = (ExecOperations)object;
                    execOps.exec(new Action(arguments, exec, stdout){
                        final /* synthetic */ List<String> $arguments;
                        final /* synthetic */ String $exec;
                        final /* synthetic */ ByteArrayOutputStream $stdout;
                        {
                            this.$arguments = $arguments;
                            this.$exec = $exec;
                            this.$stdout = $stdout;
                        }

                        public final void execute(ExecSpec $this$exec) {
                            Intrinsics.checkNotNullParameter((Object)$this$exec, (String)"$this$exec");
                            $this$exec.setArgs(this.$arguments);
                            $this$exec.setExecutable(this.$exec);
                            $this$exec.setStandardOutput((OutputStream)this.$stdout);
                        }
                    });
                    String output = stdout.toString(StandardCharsets.UTF_8);
                    project.getLogger().lifecycle(output);
                    Intrinsics.checkNotNull((Object)output);
                    String $i$f$serviceOf22 = output;
                    return $i$f$serviceOf22;
                }
            }
            try (NullOutputStream stdout = NullOutputStream.INSTANCE;){
                Project $this$serviceOf$iv = project;
                boolean $i$f$serviceOf = false;
                ServiceRegistry serviceRegistry = ((ProjectInternal)$this$serviceOf$iv).getServices();
                Intrinsics.checkNotNullExpressionValue((Object)serviceRegistry, (String)"getServices(...)");
                ServiceRegistry $this$get$iv$iv = serviceRegistry;
                boolean $i$f$get = false;
                Object object = $this$get$iv$iv.get(ExecOperations.class);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                ExecOperations execOps = (ExecOperations)object;
                ExecResult execResult = execOps.exec(new Action(arguments, exec, stdout){
                    final /* synthetic */ List<String> $arguments;
                    final /* synthetic */ String $exec;
                    final /* synthetic */ NullOutputStream $stdout;
                    {
                        this.$arguments = $arguments;
                        this.$exec = $exec;
                        this.$stdout = $stdout;
                    }

                    public final void execute(ExecSpec $this$exec) {
                        Intrinsics.checkNotNullParameter((Object)$this$exec, (String)"$this$exec");
                        $this$exec.setArgs(this.$arguments);
                        $this$exec.setExecutable(this.$exec);
                        $this$exec.setStandardOutput((OutputStream)this.$stdout);
                        $this$exec.setErrorOutput((OutputStream)this.$stdout);
                    }
                });
            }
            return "";
        }

        public static /* synthetic */ String execute$default(Companion companion, Project project, String string, List list, boolean bl, int n, Object object) {
            if ((n & 8) != 0) {
                bl = true;
            }
            return companion.execute(project, string, list, bl);
        }

        @NotNull
        public final Process exec(@NotNull Map<String, ? extends Object> config) {
            Intrinsics.checkNotNullParameter(config, (String)"config");
            Object object = config.getOrDefault("runLocalShell", (Object)true);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
            boolean runLocalShell = (Boolean)object;
            Object object2 = config.get("command");
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.String");
            List<String> command = this.createRunCommand((String)object2, runLocalShell);
            if (config.get("params") != null) {
                Object object3 = config.get("params");
                Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.String>");
                command.addAll((List)object3);
            }
            ProcessBuilder processBuilder = new ProcessBuilder(command);
            if (config.get("environment") != null) {
                Map<String, String> map = processBuilder.environment();
                Object object4 = config.get("environment");
                Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.String>");
                map.putAll((Map)object4);
            }
            if (config.get("workDir") != null) {
                Object object5 = config.get("workDir");
                Intrinsics.checkNotNull((Object)object5, (String)"null cannot be cast to non-null type java.io.File");
                processBuilder.directory((File)object5);
            }
            if (config.get("inheritIO") != null) {
                processBuilder.inheritIO();
            }
            if (config.get("discardIO") != null) {
                processBuilder.redirectOutput(ProcessBuilder.Redirect.DISCARD);
                processBuilder.redirectError(ProcessBuilder.Redirect.DISCARD);
            }
            if (config.get("redirectTo") != null) {
                processBuilder.redirectErrorStream(true);
                Object object6 = config.get("redirectTo");
                Intrinsics.checkNotNull((Object)object6, (String)"null cannot be cast to non-null type java.io.File");
                File redirectTo = (File)object6;
                if (!redirectTo.getParentFile().isDirectory()) {
                    redirectTo.getParentFile().mkdirs();
                }
                processBuilder.redirectOutput(ProcessBuilder.Redirect.to(redirectTo));
            }
            Process process = processBuilder.start();
            if (config.get("wait") != null) {
                process.waitFor();
            }
            Intrinsics.checkNotNull((Object)process);
            return process;
        }

        public final void chMod(@NotNull Project project, @NotNull String mode, @NotNull String fileName) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            if (Os.isFamily((String)"windows")) {
                project.getLogger().debug("Skipping chmod on Windows for: " + fileName);
                return;
            }
            Project $this$serviceOf$iv = project;
            boolean $i$f$serviceOf = false;
            ServiceRegistry serviceRegistry = ((ProjectInternal)$this$serviceOf$iv).getServices();
            Intrinsics.checkNotNullExpressionValue((Object)serviceRegistry, (String)"getServices(...)");
            ServiceRegistry $this$get$iv$iv = serviceRegistry;
            boolean $i$f$get = false;
            Object object = $this$get$iv$iv.get(ExecOperations.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            ExecOperations execOps = (ExecOperations)object;
            execOps.exec(new Action(mode, fileName){
                final /* synthetic */ String $mode;
                final /* synthetic */ String $fileName;
                {
                    this.$mode = $mode;
                    this.$fileName = $fileName;
                }

                public final void execute(ExecSpec $this$exec) {
                    Intrinsics.checkNotNullParameter((Object)$this$exec, (String)"$this$exec");
                    $this$exec.setExecutable("chmod");
                    Object[] objectArray = new String[]{"-R", this.$mode, this.$fileName};
                    $this$exec.setArgs(CollectionsKt.listOf((Object[])objectArray));
                }
            });
        }

        @NotNull
        public final String executeCommand(@NotNull String command, @Nullable File workDir, boolean logOutput, boolean throwErrorOnFailure, long waitTimeoutSeconds) {
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            return this.executeCommand(null, command, workDir, logOutput, throwErrorOnFailure, waitTimeoutSeconds);
        }

        public static /* synthetic */ String executeCommand$default(Companion companion, String string, File file, boolean bl, boolean bl2, long l, int n, Object object) {
            if ((n & 2) != 0) {
                file = null;
            }
            if ((n & 4) != 0) {
                bl = true;
            }
            if ((n & 8) != 0) {
                bl2 = true;
            }
            if ((n & 0x10) != 0) {
                l = 10L;
            }
            return companion.executeCommand(string, file, bl, bl2, l);
        }

        @NotNull
        public final String executeCommand(@Nullable Project project, @NotNull String command, @Nullable File workDir, boolean logOutput, boolean throwErrorOnFailure, long waitTimeoutSeconds) {
            Process process;
            String[] execCommand;
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            if (Os.isFamily((String)"windows")) {
                var9_7 = new String[]{"cmd", "/c", command};
                v0 = var9_7;
            } else {
                var9_7 = new String[]{"sh", "-c", command};
                v0 = execCommand = var9_7;
            }
            if (workDir != null) {
                Process process2 = Runtime.getRuntime().exec(execCommand, null, workDir);
                process = process2;
                Intrinsics.checkNotNullExpressionValue((Object)process2, (String)"exec(...)");
            } else {
                Process process3 = Runtime.getRuntime().exec(execCommand);
                process = process3;
                Intrinsics.checkNotNullExpressionValue((Object)process3, (String)"exec(...)");
            }
            Process process4 = process;
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(process4.getInputStream()));
            BufferedReader stdError = new BufferedReader(new InputStreamReader(process4.getErrorStream()));
            if (workDir == null) {
                ai.digital.integration.server.common.util.ProcessUtil$Companion.executeCommand$print$default(project, logOutput, "About to execute `" + command + "`", false, 8, null);
            } else {
                ai.digital.integration.server.common.util.ProcessUtil$Companion.executeCommand$print$default(project, logOutput, "About to execute `" + command + "` in work dir `" + workDir.getAbsolutePath() + "`", false, 8, null);
            }
            String input = this.readLines(stdInput, (Function1<? super String, Unit>)((Function1)arg_0 -> Companion.executeCommand$lambda$0(project, logOutput, arg_0)));
            String error = this.readLines(stdError, (Function1<? super String, Unit>)((Function1)arg_0 -> Companion.executeCommand$lambda$1(project, logOutput, arg_0)));
            if (process4.waitFor(waitTimeoutSeconds, TimeUnit.SECONDS)) {
                if (throwErrorOnFailure && process4.exitValue() != 0) {
                    throw new RuntimeException("Process '" + command + "' failed with exit value " + process4.exitValue() + ": " + error);
                }
            } else if (throwErrorOnFailure) {
                throw new RuntimeException("Process '" + command + "' not finished");
            }
            return ((CharSequence)error).length() == 0 ? input : input + System.lineSeparator() + error;
        }

        public static /* synthetic */ String executeCommand$default(Companion companion, Project project, String string, File file, boolean bl, boolean bl2, long l, int n, Object object) {
            if ((n & 4) != 0) {
                file = null;
            }
            if ((n & 8) != 0) {
                bl = true;
            }
            if ((n & 0x10) != 0) {
                bl2 = true;
            }
            if ((n & 0x20) != 0) {
                l = 10L;
            }
            return companion.executeCommand(project, string, file, bl, bl2, l);
        }

        private final String readLines(BufferedReader reader, Function1<? super String, Unit> lineHandler) {
            Object result = null;
            result = "";
            String line = null;
            line = "";
            while (true) {
                String string;
                String it = string = reader.readLine();
                boolean bl = false;
                if (it != null) {
                    line = it;
                }
                if (string == null) break;
                it = string = line;
                boolean bl2 = false;
                if (((CharSequence)result).length() > 0) {
                    result = result + System.lineSeparator();
                }
                result = result + it;
                lineHandler.invoke((Object)line);
            }
            return result;
        }

        private static final void executeCommand$print(Project $project, boolean $logOutput, String msg, boolean error) {
            if ($project != null && ((CharSequence)msg).length() > 0 && $logOutput) {
                if (error) {
                    $project.getLogger().error(msg);
                } else {
                    $project.getLogger().lifecycle(msg);
                }
            }
        }

        static /* synthetic */ void executeCommand$print$default(Project project, boolean bl, String string, boolean bl2, int n, Object object) {
            if ((n & 8) != 0) {
                bl2 = false;
            }
            ai.digital.integration.server.common.util.ProcessUtil$Companion.executeCommand$print(project, bl, string, bl2);
        }

        private static final Unit executeCommand$lambda$0(Project $project, boolean $logOutput, String line) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            ai.digital.integration.server.common.util.ProcessUtil$Companion.executeCommand$print$default($project, $logOutput, line, false, 8, null);
            return Unit.INSTANCE;
        }

        private static final Unit executeCommand$lambda$1(Project $project, boolean $logOutput, String line) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            ai.digital.integration.server.common.util.ProcessUtil$Companion.executeCommand$print($project, $logOutput, line, true);
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

