/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.util;

import ai.digital.integration.server.common.domain.MqParameters;
import ai.digital.integration.server.common.util.DockerComposeUtil;
import ai.digital.integration.server.common.util.FileUtil;
import ai.digital.integration.server.common.util.PropertyUtil;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lai/digital/integration/server/common/util/MqUtil;", "", "<init>", "()V", "Companion", "integration-server-gradle-plugin"})
public final class MqUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String RABBITMQ = "rabbitmq";
    @NotNull
    public static final String ACTIVEMQ = "activemq";
    @NotNull
    private static final MqParameters rabbitmqPararms = new MqParameters("com.rabbitmq.jms:rabbitmq-jms", "com.rabbitmq.jms.admin.RMQConnectionFactory", null, "guest", "guest");
    @NotNull
    private static final MqParameters activemqPararms = new MqParameters("org.apache.activemq:activemq-client", "org.apache.activemq.ActiveMQConnectionFactory", null, "admin", "admin");

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tJ\u0015\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016\u00a8\u0006\u0019"}, d2={"Lai/digital/integration/server/common/util/MqUtil$Companion;", "", "<init>", "()V", "RABBITMQ", "", "ACTIVEMQ", "getMqDirectory", "project", "Lorg/gradle/api/Project;", "mqName", "mqPort", "", "(Lorg/gradle/api/Project;)Ljava/lang/Integer;", "getMqRelativePath", "detectMqDependency", "Lai/digital/integration/server/common/domain/MqParameters;", "mq", "getResolvedDockerFile", "Ljava/nio/file/Path;", "rabbitmqPararms", "getRabbitmqPararms", "()Lai/digital/integration/server/common/domain/MqParameters;", "activemqPararms", "getActivemqPararms", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getMqDirectory(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return FileUtil.Companion.toPathString(DeployServerUtil.Companion.getServerDistFolderPath(project), "mq");
        }

        @NotNull
        public final String mqName(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return String.valueOf(PropertyUtil.Companion.resolveValue(project, "mq", MqUtil.RABBITMQ));
        }

        @Nullable
        public final Integer mqPort(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return PropertyUtil.Companion.resolveIntValue(project, "mqPort", null);
        }

        @NotNull
        public final String getMqRelativePath(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return "mq/docker-compose_" + this.mqName(project) + ".yaml";
        }

        @NotNull
        public final MqParameters detectMqDependency(@NotNull String mq) {
            Intrinsics.checkNotNullParameter((Object)mq, (String)"mq");
            String string = mq;
            return Intrinsics.areEqual((Object)string, (Object)MqUtil.RABBITMQ) ? this.getRabbitmqPararms() : (Intrinsics.areEqual((Object)string, (Object)MqUtil.ACTIVEMQ) ? this.getActivemqPararms() : this.getRabbitmqPararms());
        }

        @NotNull
        public final Path getResolvedDockerFile(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Path resultComposeFilePath = DockerComposeUtil.Companion.getResolvedDockerPath(project, this.getMqRelativePath(project));
            if (Intrinsics.areEqual((Object)this.mqName(project), (Object)MqUtil.RABBITMQ)) {
                DockerComposeUtil.Companion.getResolvedDockerPath(project, "mq/rabbitmq/enabled_plugins");
            }
            File mqTemplate = resultComposeFilePath.toFile();
            int port = Intrinsics.areEqual((Object)this.mqName(project), (Object)MqUtil.RABBITMQ) ? 5672 : 61616;
            Integer resolvedMqPort = PropertyUtil.Companion.resolveIntValue(project, "mqPort", port);
            Intrinsics.checkNotNull((Object)mqTemplate);
            String configuredTemplate = StringsKt.replace$default((String)StringsKt.replace$default((String)FilesKt.readText$default((File)mqTemplate, null, (int)1, null), (String)"RABBITMQ_PORT2", (String)(resolvedMqPort + ":5672"), (boolean)false, (int)4, null), (String)"ACTIVEMQ_PORT2", (String)(resolvedMqPort + ":61616"), (boolean)false, (int)4, null);
            FilesKt.writeText$default((File)mqTemplate, (String)configuredTemplate, null, (int)2, null);
            return resultComposeFilePath;
        }

        @NotNull
        public final MqParameters getRabbitmqPararms() {
            return rabbitmqPararms;
        }

        @NotNull
        public final MqParameters getActivemqPararms() {
            return activemqPararms;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

