/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.internals;

import ai.digital.integration.server.common.constant.ProductName;
import ai.digital.integration.server.common.domain.Server;
import ai.digital.integration.server.common.util.HTTPUtil;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import ai.digital.integration.server.deploy.internals.EntryPointUrlUtil;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lai/digital/integration/server/deploy/internals/DeployShutdownUtil;", "", "<init>", "()V", "Companion", "integration-server-gradle-plugin"})
public final class DeployShutdownUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\t"}, d2={"Lai/digital/integration/server/deploy/internals/DeployShutdownUtil$Companion;", "", "<init>", "()V", "waitForShutdown", "", "project", "Lorg/gradle/api/Project;", "shutdownServer", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        private final void waitForShutdown(Project project) {
            Server server = DeployServerUtil.Companion.getServer(project);
            int triesLeft = server.getPingTotalTries();
            boolean success = false;
            while (triesLeft > 0 && !success) {
                try {
                    HttpClient client = HttpClient.newHttpClient();
                    HttpRequest request = HTTPUtil.Companion.doRequest$default(HTTPUtil.Companion, EntryPointUrlUtil.composeUrl$default(new EntryPointUrlUtil(project, ProductName.DEPLOY, false, 4, null), server.getContextRoot(), false, 2, null), null, null, 6, null).POST(HttpRequest.BodyPublishers.noBody()).build();
                    HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                    project.getLogger().lifecycle("Waiting " + server.getPingRetrySleepTime() + " seconds for shutdown. (" + triesLeft + ")");
                    TimeUnit.SECONDS.sleep(server.getPingRetrySleepTime());
                    if (response.statusCode() == 200) continue;
                    project.getLogger().lifecycle("XL Deploy server successfully shutdown");
                    success = true;
                }
                catch (Exception ignored) {
                    project.getLogger().lifecycle("XL Deploy server successfully shutdown.");
                    success = true;
                    break;
                }
            }
            if (!success) {
                throw new GradleException("Server failed to stop");
            }
        }

        public final void shutdownServer(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Server server = DeployServerUtil.Companion.getServer(project);
            try {
                int port = server.getHttpPort();
                project.getLogger().lifecycle("Trying to shutdown integration server on port " + port);
                HttpClient client = HttpClient.newHttpClient();
                HttpRequest request = HTTPUtil.Companion.doRequest$default(HTTPUtil.Companion, EntryPointUrlUtil.composeUrl$default(new EntryPointUrlUtil(project, ProductName.DEPLOY, false, 4, null), "/deployit/server/shutdown", false, 2, null), null, null, 6, null).POST(HttpRequest.BodyPublishers.noBody()).build();
                client.send(request, HttpResponse.BodyHandlers.ofString());
                this.waitForShutdown(project);
                project.getLogger().lifecycle("Integration server at port " + port + " is now shutdown");
            }
            catch (Exception ignored) {
                project.getLogger().lifecycle("Integration server on port " + server.getHttpPort() + " is not running");
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

