/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.release.tasks.server.operator;

import ai.digital.integration.server.common.constant.ProductName;
import ai.digital.integration.server.common.domain.Server;
import ai.digital.integration.server.common.util.DockerComposeUtil;
import ai.digital.integration.server.common.util.WaitForBootUtil;
import ai.digital.integration.server.release.internals.ReleaseServerInitializeUtil;
import ai.digital.integration.server.release.util.ReleaseServerUtil;
import java.io.File;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0011\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\b\u001a\u00020\tH\u0002J\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\b\u0010\f\u001a\u00020\u0007H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lai/digital/integration/server/release/tasks/server/operator/StartReleaseToGetLicenceTask;", "Lorg/gradle/api/DefaultTask;", "execOperations", "Lorg/gradle/process/ExecOperations;", "<init>", "(Lorg/gradle/process/ExecOperations;)V", "allowToWriteMountedHostFolders", "", "getDockerComposeFile", "Ljava/io/File;", "start", "Ljava/lang/Process;", "launch", "Companion", "integration-server-gradle-plugin"})
public class StartReleaseToGetLicenceTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExecOperations execOperations;
    @NotNull
    public static final String NAME = "startReleaseToGetLicence";

    @Inject
    public StartReleaseToGetLicenceTask(@NotNull ExecOperations execOperations) {
        Intrinsics.checkNotNullParameter((Object)execOperations, (String)"execOperations");
        this.execOperations = execOperations;
        this.setGroup("Integration Server");
        Object[] objectArray = new Object[]{"dockerBasedStopRelease"};
        this.finalizedBy(objectArray);
    }

    private final void allowToWriteMountedHostFolders() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ReleaseServerUtil.Companion.grantPermissionsToIntegrationServerFolder(project);
    }

    private final File getDockerComposeFile() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        File file = ReleaseServerUtil.Companion.getResolvedDockerFile(project).toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        return file;
    }

    private final Process start() {
        this.execOperations.exec(new Action(this){
            final /* synthetic */ StartReleaseToGetLicenceTask this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(ExecSpec $this$exec) {
                Intrinsics.checkNotNullParameter((Object)$this$exec, (String)"$this$exec");
                $this$exec.setExecutable("docker-compose");
                Object[] objectArray = new String[4];
                objectArray[0] = "-f";
                Intrinsics.checkNotNullExpressionValue((Object)StartReleaseToGetLicenceTask.access$getDockerComposeFile(this.this$0).toString(), (String)"toString(...)");
                objectArray[2] = "up";
                objectArray[3] = "-d";
                $this$exec.setArgs(CollectionsKt.listOf((Object[])objectArray));
            }
        });
        return null;
    }

    @TaskAction
    public final void launch() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Server server = ReleaseServerUtil.Companion.getServer(project);
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        ReleaseServerInitializeUtil.Companion.prepare(project2, server);
        this.getProject().getLogger().lifecycle("About to launch Release Server on port " + server.getHttpPort() + ".");
        this.allowToWriteMountedHostFolders();
        Process process = this.start();
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
        File licenseFile = ReleaseServerUtil.Companion.getLicenseFile(project3);
        Project project4 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"getProject(...)");
        WaitForBootUtil.Companion.byFile$default(WaitForBootUtil.Companion, project4, process, licenseFile, 0, 0, 24, null);
        Project project5 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project5, (String)"getProject(...)");
        DockerComposeUtil.Companion.allowToCleanMountedFiles(project5, ProductName.RELEASE, server, this.getDockerComposeFile());
    }

    public static final /* synthetic */ File access$getDockerComposeFile(StartReleaseToGetLicenceTask $this) {
        return $this.getDockerComposeFile();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lai/digital/integration/server/release/tasks/server/operator/StartReleaseToGetLicenceTask$Companion;", "", "<init>", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

