/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks.tls;

import ai.digital.integration.server.common.domain.Tls;
import ai.digital.integration.server.common.tls.KeytoolExportKeyToCertTask;
import ai.digital.integration.server.common.tls.KeytoolGenKeyTask;
import ai.digital.integration.server.common.tls.KeytoolImportKeyToTruststoreTask;
import ai.digital.integration.server.common.util.PropertiesUtil;
import ai.digital.integration.server.common.util.TlsUtil;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import java.io.File;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007J\u0012\u0010\u0006\u001a\u00020\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\u0012\u0010\t\u001a\u00020\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002\u00a8\u0006\u000b"}, d2={"Lai/digital/integration/server/deploy/tasks/tls/TlsApplicationConfigurationOverrideTask;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "run", "", "updateDeployitConf", "tls", "Lai/digital/integration/server/common/domain/Tls;", "updateWrapperConf", "Companion", "integration-server-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nTlsApplicationConfigurationOverrideTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TlsApplicationConfigurationOverrideTask.kt\nai/digital/integration/server/deploy/tasks/tls/TlsApplicationConfigurationOverrideTask\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n1#2:97\n*E\n"})
public class TlsApplicationConfigurationOverrideTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "tlsApplicationConfigurationOverride";

    /*
     * WARNING - void declaration
     */
    public TlsApplicationConfigurationOverrideTask() {
        this.setGroup("Integration Server");
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        Tls tls = TlsUtil.Companion.getTls(project, DeployServerUtil.Companion.getServerWorkingDir(project2));
        if (tls != null) {
            String string;
            Object[] objectArray;
            int n;
            Object[] objectArray2;
            Object[] objectArray3;
            CharSequence charSequence;
            int n2;
            TaskContainer taskContainer;
            StringBuilder stringBuilder;
            Tls tls2 = tls;
            boolean bl = false;
            TaskContainer taskContainer2 = this.getProject().getTasks();
            Object[] objectArray4 = "keytoolGenKey";
            if (((CharSequence)objectArray4).length() > 0) {
                String string2;
                void it;
                char c = objectArray4.charAt(0);
                stringBuilder = new StringBuilder();
                taskContainer = taskContainer2;
                n2 = 0;
                if (Character.isLowerCase((char)it)) {
                    Locale locale = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                    string2 = CharsKt.titlecase((char)it, (Locale)locale);
                } else {
                    string2 = String.valueOf((char)it);
                }
                charSequence = string2;
                taskContainer2 = taskContainer;
                StringBuilder stringBuilder2 = stringBuilder.append((Object)charSequence);
                objectArray3 = objectArray4;
                n2 = 1;
                String string3 = objectArray3.substring(n2);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                objectArray2 = stringBuilder2.append(string3).toString();
            } else {
                objectArray2 = objectArray4;
            }
            TaskProvider taskProvider = taskContainer2.register("tls" + (String)objectArray2, KeytoolGenKeyTask.class, new Action(tls2){
                final /* synthetic */ Tls $tls;
                {
                    this.$tls = $tls;
                }

                public final void execute(KeytoolGenKeyTask $this$register) {
                    Intrinsics.checkNotNullParameter((Object)((Object)$this$register), (String)"$this$register");
                    $this$register.setKeyname("master_tls");
                    $this$register.setType("pkcs12");
                    $this$register.setTypeExtension("pk12");
                    $this$register.setWorkDir(this.$tls.confWorkDir());
                    $this$register.setKeypass(this.$tls.getKeyPassword());
                    $this$register.setStorepass(this.$tls.getKeyStorePassword());
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(...)");
            TaskProvider genKeyStore2 = taskProvider;
            TaskContainer taskContainer3 = this.getProject().getTasks();
            objectArray3 = "keytoolExportKeyToCert";
            if (((CharSequence)objectArray3).length() > 0) {
                String string4;
                void it;
                n2 = objectArray3.charAt(0);
                stringBuilder = new StringBuilder();
                taskContainer = taskContainer3;
                n = 0;
                if (Character.isLowerCase((char)it)) {
                    Locale locale = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                    string4 = CharsKt.titlecase((char)it, (Locale)locale);
                } else {
                    string4 = String.valueOf((char)it);
                }
                charSequence = string4;
                taskContainer3 = taskContainer;
                StringBuilder stringBuilder3 = stringBuilder.append((Object)charSequence);
                Object[] objectArray5 = objectArray3;
                n = 1;
                String string5 = objectArray5.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                objectArray = stringBuilder3.append(string5).toString();
            } else {
                objectArray = objectArray3;
            }
            TaskProvider taskProvider2 = taskContainer3.register("tls" + (String)objectArray, KeytoolExportKeyToCertTask.class, new Action(tls2){
                final /* synthetic */ Tls $tls;
                {
                    this.$tls = $tls;
                }

                public final void execute(KeytoolExportKeyToCertTask $this$register) {
                    Intrinsics.checkNotNullParameter((Object)((Object)$this$register), (String)"$this$register");
                    $this$register.setKeyname("master_tls");
                    $this$register.setType("pkcs12");
                    $this$register.setTypeExtension("pk12");
                    $this$register.setWorkDir(this.$tls.confWorkDir());
                    $this$register.setKeypass(this.$tls.getKeyPassword());
                    $this$register.setStorepass(this.$tls.getKeyStorePassword());
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)taskProvider2, (String)"register(...)");
            TaskProvider genCert2 = taskProvider2;
            objectArray4 = new Object[]{genKeyStore2};
            this.getProject().getTasks().getByName(genCert2.getName()).dependsOn(objectArray4);
            TaskContainer taskContainer4 = this.getProject().getTasks();
            String string6 = "keytoolImportKeyToTruststore";
            if (((CharSequence)string6).length() > 0) {
                String string7;
                void it;
                n = string6.charAt(0);
                stringBuilder = new StringBuilder();
                taskContainer = taskContainer4;
                boolean bl2 = false;
                if (Character.isLowerCase((char)it)) {
                    Locale locale = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                    string7 = CharsKt.titlecase((char)it, (Locale)locale);
                } else {
                    string7 = String.valueOf((char)it);
                }
                charSequence = string7;
                taskContainer4 = taskContainer;
                StringBuilder stringBuilder4 = stringBuilder.append((Object)charSequence);
                String string8 = string6;
                int n3 = 1;
                String string9 = string8.substring(n3);
                Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"substring(...)");
                string = stringBuilder4.append(string9).toString();
            } else {
                string = string6;
            }
            TaskProvider taskProvider3 = taskContainer4.register("tls" + string, KeytoolImportKeyToTruststoreTask.class, new Action(tls2){
                final /* synthetic */ Tls $tls;
                {
                    this.$tls = $tls;
                }

                public final void execute(KeytoolImportKeyToTruststoreTask $this$register) {
                    Intrinsics.checkNotNullParameter((Object)((Object)$this$register), (String)"$this$register");
                    $this$register.setKeyname("master_tls");
                    $this$register.setType("pkcs12");
                    $this$register.setTypeExtension("pk12");
                    $this$register.setTruststore(this.$tls.getTrustStoreName());
                    $this$register.setWorkDir(this.$tls.confWorkDir());
                    $this$register.setKeypass(this.$tls.getKeyPassword());
                    $this$register.setStorepass(this.$tls.getTruststorePassword());
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)taskProvider3, (String)"register(...)");
            TaskProvider genTrustStore2 = taskProvider3;
            objectArray3 = new Object[]{genCert2};
            this.getProject().getTasks().getByName(genTrustStore2.getName()).dependsOn(objectArray3);
            objectArray3 = new Object[]{genKeyStore2, genCert2, genTrustStore2};
            this.dependsOn(objectArray3);
        }
        Object[] objectArray = new Object[]{"serverCopyOverlays"};
        this.mustRunAfter(objectArray);
    }

    @TaskAction
    public final void run() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        Tls tls = TlsUtil.Companion.getTls(project, DeployServerUtil.Companion.getServerWorkingDir(project2));
        this.updateDeployitConf(tls);
        this.updateWrapperConf(tls);
    }

    private final void updateDeployitConf(Tls tls) {
        this.getProject().getLogger().lifecycle("Configurations TLS overriding for deployit.conf.");
        Project project = this.getProject();
        Tls tls2 = tls;
        Intrinsics.checkNotNull((Object)tls2);
        File file = project.file((Object)(tls2.confWorkDir() + "/deployit.conf"));
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file(...)");
        File deployitConf = file;
        Properties properties = PropertiesUtil.Companion.readPropertiesFile(deployitConf);
        ((Map)properties).put("ssl", "true");
        ((Map)properties).put("keystore.type", "pkcs12");
        ((Map)properties).put("keystore.password", tls.getKeyStorePassword());
        ((Map)properties).put("keystore.path", tls.keyStoreFile().getAbsolutePath());
        PropertiesUtil.Companion.writePropertiesFile(deployitConf, properties);
    }

    private final void updateWrapperConf(Tls tls) {
        this.getProject().getLogger().lifecycle("Configurations TLS overriding for xld-wrapper.conf.common.");
        Project project = this.getProject();
        Tls tls2 = tls;
        Intrinsics.checkNotNull((Object)tls2);
        File file = project.file((Object)(tls2.confWorkDir() + "/deployit.conf"));
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file(...)");
        File wrapperConf = file;
        Properties properties = PropertiesUtil.Companion.readPropertiesFile(wrapperConf);
        for (int pos = 0; pos < 20 && properties.containsKey("wrapper.java.additional." + pos); ++pos) {
        }
        PropertiesUtil.Companion.writePropertiesFile(wrapperConf, properties);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lai/digital/integration/server/deploy/tasks/tls/TlsApplicationConfigurationOverrideTask$Companion;", "", "<init>", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

