/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.internals;

import ai.digital.integration.server.common.cluster.DockerClusterHelper;
import ai.digital.integration.server.common.cluster.DockerClusterHelperCreator;
import ai.digital.integration.server.common.cluster.helm.HelmHelper;
import ai.digital.integration.server.common.cluster.operator.OperatorHelper;
import ai.digital.integration.server.common.cluster.util.OperatorUtil;
import ai.digital.integration.server.common.constant.ProductName;
import ai.digital.integration.server.common.domain.Server;
import ai.digital.integration.server.deploy.internals.DeployExtensionUtil;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import ai.digital.integration.server.deploy.internals.cluster.DeployClusterUtil;
import ai.digital.integration.server.release.tasks.cluster.ReleaseClusterUtil;
import ai.digital.integration.server.release.util.ReleaseServerUtil;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\r\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0007H\u0002J\u0010\u0010\u0015\u001a\u00020\u00112\b\b\u0002\u0010\u0014\u001a\u00020\u0007J\u0010\u0010\u0016\u001a\u00020\u00112\b\b\u0002\u0010\u0014\u001a\u00020\u0007J\u0010\u0010\u0017\u001a\u00020\u00112\b\b\u0002\u0010\u0014\u001a\u00020\u0007J\u0010\u0010\u0018\u001a\u00020\u00112\b\b\u0002\u0010\u0014\u001a\u00020\u0007J\u0018\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u00112\b\b\u0002\u0010\u0014\u001a\u00020\u0007J\b\u0010\u001b\u001a\u00020\u0007H\u0002J\b\u0010\u001c\u001a\u00020\u0007H\u0002J\b\u0010\u001d\u001a\u00020\u0007H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lai/digital/integration/server/deploy/internals/EntryPointUrlUtil;", "", "project", "Lorg/gradle/api/Project;", "productName", "Lai/digital/integration/server/common/constant/ProductName;", "clusterEnabled", "", "<init>", "(Lorg/gradle/api/Project;Lai/digital/integration/server/common/constant/ProductName;Z)V", "getProject", "()Lorg/gradle/api/Project;", "getProductName", "()Lai/digital/integration/server/common/constant/ProductName;", "getClusterEnabled", "()Z", "getPropertyValue", "", "key", "clusterValue", "auxiliaryServer", "getHttpPort", "getContextRoot", "getHttpHost", "getUrl", "composeUrl", "path", "isOperatorProvider", "isHelmProvider", "isTls", "integration-server-gradle-plugin"})
public final class EntryPointUrlUtil {
    @NotNull
    private final Project project;
    @NotNull
    private final ProductName productName;
    private final boolean clusterEnabled;

    public EntryPointUrlUtil(@NotNull Project project, @NotNull ProductName productName, boolean clusterEnabled) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)productName), (String)"productName");
        this.project = project;
        this.productName = productName;
        this.clusterEnabled = clusterEnabled;
    }

    public /* synthetic */ EntryPointUrlUtil(Project project, ProductName productName, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(project, productName, bl);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final ProductName getProductName() {
        return this.productName;
    }

    public final boolean getClusterEnabled() {
        return this.clusterEnabled;
    }

    private final String getPropertyValue(String key, String clusterValue, boolean auxiliaryServer) {
        if (this.clusterEnabled) {
            if (!auxiliaryServer) {
                return clusterValue;
            }
            return new OperatorUtil(this.project).readConfProperty(key);
        }
        return switch (WhenMappings.$EnumSwitchMapping$0[this.productName.ordinal()]) {
            case 1 -> DeployServerUtil.Companion.readDeployitConfProperty(this.project, key);
            case 2 -> ReleaseServerUtil.Companion.readReleaseServerConfProperty(this.project, key);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public final String getHttpPort(boolean auxiliaryServer) {
        if (this.isOperatorProvider() && !auxiliaryServer) {
            OperatorHelper operatorHelper = OperatorHelper.Companion.getOperatorHelper(this.project, this.productName);
            return operatorHelper.getPort();
        }
        if (this.isHelmProvider() && !auxiliaryServer) {
            HelmHelper helmHelper = HelmHelper.Companion.getHelmHelper(this.project, this.productName);
            return helmHelper.getPort();
        }
        if (auxiliaryServer) {
            Server server = new OperatorUtil(this.project).getOperatorServer();
            return String.valueOf(server.getHttpPort());
        }
        DockerClusterHelper dockerHelper = DockerClusterHelperCreator.Companion.create(this.project, this.productName);
        return this.getPropertyValue("http.port", dockerHelper.getClusterPublicPort(), auxiliaryServer);
    }

    public static /* synthetic */ String getHttpPort$default(EntryPointUrlUtil entryPointUrlUtil, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return entryPointUrlUtil.getHttpPort(bl);
    }

    @NotNull
    public final String getContextRoot(boolean auxiliaryServer) {
        if (this.isOperatorProvider() && !auxiliaryServer) {
            OperatorHelper operatorHelper = OperatorHelper.Companion.getOperatorHelper(this.project, this.productName);
            return operatorHelper.getContextRoot();
        }
        if (this.isHelmProvider() && !auxiliaryServer) {
            HelmHelper helmHelper = HelmHelper.Companion.getHelmHelper(this.project, this.productName);
            return helmHelper.getContextRoot();
        }
        if (auxiliaryServer) {
            Server server = new OperatorUtil(this.project).getOperatorServer();
            return server.getContextRoot();
        }
        return this.getPropertyValue("http.context.root", "", auxiliaryServer);
    }

    public static /* synthetic */ String getContextRoot$default(EntryPointUrlUtil entryPointUrlUtil, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return entryPointUrlUtil.getContextRoot(bl);
    }

    @NotNull
    public final String getHttpHost(boolean auxiliaryServer) {
        if (this.isOperatorProvider() && !auxiliaryServer && DeployExtensionUtil.Companion.getExtension(this.project).getClusterProfiles().operator().getActiveProviderName().isPresent()) {
            OperatorHelper operatorHelper = OperatorHelper.Companion.getOperatorHelper(this.project, this.productName);
            return operatorHelper.getFqdn();
        }
        if (this.isHelmProvider() && !auxiliaryServer && DeployExtensionUtil.Companion.getExtension(this.project).getClusterProfiles().helm().getActiveProviderName().isPresent()) {
            HelmHelper helmHelper = HelmHelper.Companion.getHelmHelper(this.project, this.productName);
            return helmHelper.getFqdn();
        }
        return "localhost";
    }

    public static /* synthetic */ String getHttpHost$default(EntryPointUrlUtil entryPointUrlUtil, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return entryPointUrlUtil.getHttpHost(bl);
    }

    @NotNull
    public final String getUrl(boolean auxiliaryServer) {
        String protocol;
        String string = this.clusterEnabled ? "http" : (protocol = this.isTls() ? "https" : "http");
        if (this.isOperatorProvider() && !auxiliaryServer) {
            OperatorHelper operatorHelper = OperatorHelper.Companion.getOperatorHelper(this.project, this.productName);
            return protocol + "://" + operatorHelper.getFqdn();
        }
        String contextRoot = this.getContextRoot(auxiliaryServer);
        String host = this.getHttpHost(auxiliaryServer);
        String port = this.getHttpPort(auxiliaryServer);
        return protocol + "://" + host + ":" + port + contextRoot;
    }

    public static /* synthetic */ String getUrl$default(EntryPointUrlUtil entryPointUrlUtil, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return entryPointUrlUtil.getUrl(bl);
    }

    @NotNull
    public final String composeUrl(@NotNull String path, boolean auxiliaryServer) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String url = this.getUrl(auxiliaryServer);
        String separator = "/";
        if (StringsKt.startsWith$default((String)path, (String)"/", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)url, (String)"/", (boolean)false, (int)2, null)) {
            separator = "";
            if (StringsKt.startsWith$default((String)path, (String)"/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)url, (String)"/", (boolean)false, (int)2, null)) {
                url = StringsKt.removeSuffix((String)url, (CharSequence)"/");
            }
        }
        return url + separator + path;
    }

    public static /* synthetic */ String composeUrl$default(EntryPointUrlUtil entryPointUrlUtil, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return entryPointUrlUtil.composeUrl(string, bl);
    }

    private final boolean isOperatorProvider() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.productName.ordinal()]) {
            case 1 -> DeployClusterUtil.Companion.isOperatorProvider(this.project);
            case 2 -> ReleaseClusterUtil.Companion.isOperatorProvider(this.project);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final boolean isHelmProvider() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.productName.ordinal()]) {
            case 1 -> DeployClusterUtil.Companion.isHelmProvider(this.project);
            case 2 -> ReleaseClusterUtil.Companion.isHelmProvider(this.project);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final boolean isTls() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.productName.ordinal()]) {
            case 1 -> DeployServerUtil.Companion.isTls(this.project);
            case 2 -> false;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProductName.values().length];
            try {
                nArray[ProductName.DEPLOY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProductName.RELEASE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

