/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.internals;

import ai.digital.integration.server.common.util.PropertiesUtil;
import ai.digital.integration.server.common.util.PropertyUtil;
import ai.digital.integration.server.deploy.domain.CentralConfigurationServer;
import ai.digital.integration.server.deploy.internals.DeployExtensionUtil;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lai/digital/integration/server/deploy/internals/CentralConfigurationServerUtil;", "", "<init>", "()V", "Companion", "integration-server-gradle-plugin"})
public final class CentralConfigurationServerUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007J\u001f\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u0010\rJ\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\tH\u0002J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\tJ\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\tJ\u0016\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\tJ\u0016\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u000fJ\u0006\u0010\u0017\u001a\u00020\u000fJ\u000e\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u0019"}, d2={"Lai/digital/integration/server/deploy/internals/CentralConfigurationServerUtil$Companion;", "", "<init>", "()V", "hasCentralConfigurationServer", "", "project", "Lorg/gradle/api/Project;", "getCentralConfigurationServer", "Lai/digital/integration/server/deploy/domain/CentralConfigurationServer;", "getDebugPort", "", "cc", "(Lorg/gradle/api/Project;Lai/digital/integration/server/deploy/domain/CentralConfigurationServer;)Ljava/lang/Integer;", "getVersion", "", "getServerPath", "Ljava/nio/file/Path;", "getBinDir", "Ljava/io/File;", "getLogDir", "readDeployitConfProperty", "key", "logFileName", "getBaseUrl", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean hasCentralConfigurationServer(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return ((CentralConfigurationServer)DeployExtensionUtil.Companion.getExtension(project).getCentralConfigurationServer().get()).getEnable();
        }

        @NotNull
        public final CentralConfigurationServer getCentralConfigurationServer(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = DeployExtensionUtil.Companion.getExtension(project).getCentralConfigurationServer().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            CentralConfigurationServer cc = (CentralConfigurationServer)object;
            cc.setVersion(this.getVersion(project, cc));
            cc.setDebugPort(this.getDebugPort(project, cc));
            return cc;
        }

        private final Integer getDebugPort(Project project, CentralConfigurationServer cc) {
            return PropertyUtil.Companion.resolveBooleanValue(project, "debug", true) ? PropertyUtil.Companion.resolveIntValue(project, "ccDebugPort", cc.getDebugPort()) : null;
        }

        private final String getVersion(Project project, CentralConfigurationServer cc) {
            String string;
            if (project.hasProperty("centralConfigurationVersion")) {
                string = String.valueOf(project.property("centralConfigurationVersion"));
            } else {
                CharSequence charSequence = cc.getVersion();
                if (!(charSequence == null || charSequence.length() == 0)) {
                    string = cc.getVersion();
                } else {
                    charSequence = DeployServerUtil.Companion.getServer(project).getVersion();
                    if (!(charSequence == null || charSequence.length() == 0)) {
                        string = DeployServerUtil.Companion.getServer(project).getVersion();
                    } else {
                        project.getLogger().error("Central Configuration Server Version is not specified");
                        System.exit(1);
                        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
                    }
                }
            }
            return string;
        }

        @NotNull
        public final Path getServerPath(@NotNull Project project, @NotNull CentralConfigurationServer cc) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)cc, (String)"cc");
            String targetDir = ((Object)DeployServerUtil.Companion.getServerDistFolderPath(project)).toString();
            String[] stringArray = new String[]{"central-configuration-" + cc.getVersion() + "-server"};
            Path path = Paths.get(targetDir, stringArray).toAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toAbsolutePath(...)");
            return path;
        }

        @NotNull
        public final File getBinDir(@NotNull Project project, @NotNull CentralConfigurationServer cc) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)cc, (String)"cc");
            String[] stringArray = new String[]{"bin"};
            File file = Paths.get(((Object)this.getServerPath(project, cc)).toString(), stringArray).toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            return file;
        }

        @NotNull
        public final File getLogDir(@NotNull Project project, @NotNull CentralConfigurationServer cc) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)cc, (String)"cc");
            String[] stringArray = new String[]{"log"};
            File file = Paths.get(((Object)this.getServerPath(project, cc)).toString(), stringArray).toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            return file;
        }

        @NotNull
        public final String readDeployitConfProperty(@NotNull Project project, @NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            File deployitConf = Paths.get(this.getServerPath(project, this.getCentralConfigurationServer(project)) + "/conf/deployit.conf", new String[0]).toFile();
            Intrinsics.checkNotNull((Object)deployitConf);
            return PropertiesUtil.Companion.readProperty(deployitConf, key);
        }

        @NotNull
        public final String logFileName() {
            return "central-config";
        }

        @NotNull
        public final String getBaseUrl(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return "http://localhost:" + this.readDeployitConfProperty(project, "http.port");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

