/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.release.tasks.cluster.operator;

import ai.digital.integration.server.common.constant.OperatorHelmProviderName;
import ai.digital.integration.server.release.internals.ReleaseExtensionUtil;
import ai.digital.integration.server.release.tasks.cluster.ReleaseClusterUtil;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0007"}, d2={"Lai/digital/integration/server/release/tasks/cluster/operator/OperatorBasedStopReleaseClusterTask;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "launch", "", "Companion", "integration-server-gradle-plugin"})
public class OperatorBasedStopReleaseClusterTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "operatorBasedStopReleaseCluster";

    public OperatorBasedStopReleaseClusterTask() {
        Object[] objectArray;
        this.setGroup("Integration Server");
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (ReleaseExtensionUtil.Companion.getExtension(project).getClusterProfiles().operator().getActiveProviderName().isPresent()) {
            String string;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "downloadAndExtractCli";
            Project project2 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            String providerName = ReleaseClusterUtil.Companion.getOperatorProvider(project2);
            if (Intrinsics.areEqual((Object)providerName, (Object)OperatorHelmProviderName.AWS_EKS.getProviderName())) {
                string = "operatorBasedAwsEksStopReleaseCluster";
            } else if (Intrinsics.areEqual((Object)providerName, (Object)OperatorHelmProviderName.AWS_OPENSHIFT.getProviderName())) {
                string = "operatorBasedAwsOpenShiftStopReleaseCluster";
            } else if (Intrinsics.areEqual((Object)providerName, (Object)OperatorHelmProviderName.AZURE_AKS.getProviderName())) {
                string = "operatorBasedAzureAksStopReleaseCluster";
            } else if (Intrinsics.areEqual((Object)providerName, (Object)OperatorHelmProviderName.GCP_GKE.getProviderName())) {
                string = "operatorBasedGcpGkeStopReleaseCluster";
            } else if (Intrinsics.areEqual((Object)providerName, (Object)OperatorHelmProviderName.ON_PREMISE.getProviderName())) {
                string = "operatorBasedOnPremStopReleaseCluster";
            } else if (Intrinsics.areEqual((Object)providerName, (Object)OperatorHelmProviderName.VMWARE_OPENSHIFT.getProviderName())) {
                string = "operatorBasedVmWareOpenShiftStopReleaseCluster";
            } else {
                throw new IllegalArgumentException("Provided operator provider name `" + providerName + "` is not supported. Choose one of " + ArraysKt.joinToString$default((Object[])OperatorHelmProviderName.values(), null, null, null, (int)0, null, null, (int)63, null));
            }
            objectArray2[1] = string;
            objectArray = this.dependsOn(objectArray2);
            Intrinsics.checkNotNull((Object)objectArray);
        } else {
            this.getProject().getLogger().warn("Active provider name is not set - OperatorBasedStopReleaseClusterTask");
        }
        objectArray = new Object[]{"stopDeployServerForOperatorInstance", "stopDeployServerForOperatorUpgrade"};
        this.finalizedBy(objectArray);
    }

    @TaskAction
    public final void launch() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        String providerName = ReleaseClusterUtil.Companion.getOperatorProvider(project);
        this.getProject().getLogger().lifecycle("Operator based Release Cluster with provider " + providerName + "  is about to stop.");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lai/digital/integration/server/release/tasks/cluster/operator/OperatorBasedStopReleaseClusterTask$Companion;", "", "<init>", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

