/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks.server;

import ai.digital.integration.server.common.cluster.util.OperatorUtil;
import ai.digital.integration.server.common.domain.Server;
import ai.digital.integration.server.common.util.CacheUtil;
import ai.digital.integration.server.common.util.OverlaysUtil;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import ai.digital.integration.server.deploy.tasks.server.DownloadAndExtractServerDistTask;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lai/digital/integration/server/deploy/tasks/server/ServerCopyOverlaysTask;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "Companion", "integration-server-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nServerCopyOverlaysTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServerCopyOverlaysTask.kt\nai/digital/integration/server/deploy/tasks/server/ServerCopyOverlaysTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,55:1\n1869#2:56\n1870#2:59\n216#3,2:57\n*S KotlinDebug\n*F\n+ 1 ServerCopyOverlaysTask.kt\nai/digital/integration/server/deploy/tasks/server/ServerCopyOverlaysTask\n*L\n31#1:56\n31#1:59\n40#1:57,2\n*E\n"})
public class ServerCopyOverlaysTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "serverCopyOverlays";

    public ServerCopyOverlaysTask() {
        this.setGroup("Integration Server");
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (!new OperatorUtil(project).isClusterEnabled()) {
            Object[] objectArray = new Object[]{"centralConfiguration"};
            this.mustRunAfter(objectArray);
            objectArray = new Object[]{"copyServerBuildArtifacts"};
            this.mustRunAfter(objectArray);
            objectArray = new Object[]{DownloadAndExtractServerDistTask.Companion.getNAME()};
            this.mustRunAfter(objectArray);
            objectArray = new Object[]{"checkUILibVersions"};
            this.finalizedBy(objectArray);
        }
        ServerCopyOverlaysTask currentTask = this;
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        Iterable $this$forEach$iv = DeployServerUtil.Companion.getServers(project2);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Server server = (Server)element$iv;
            boolean bl = false;
            this.getProject().getLogger().lifecycle("Copying overlays on Deploy server " + server.getName());
            Project project3 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
            OverlaysUtil.Companion.addDatabaseDependency(project3, server);
            Project project4 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"getProject(...)");
            OverlaysUtil.Companion.addMqDependency(project4, server);
            Project project5 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project5, (String)"getProject(...)");
            if (CacheUtil.Companion.isCacheEnabled(project5)) {
                Project project6 = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project6, (String)"getProject(...)");
                OverlaysUtil.Companion.addCacheDependency(project6, server);
            }
            Map<String, List<Object>> $this$forEach$iv2 = server.getOverlays();
            boolean $i$f$forEach2 = false;
            Iterator<Map.Entry<String, List<Object>>> iterator = $this$forEach$iv2.entrySet().iterator();
            while (iterator.hasNext()) {
                ArrayList arrayList;
                Map.Entry<String, List<Object>> element$iv2;
                Map.Entry<String, List<Object>> overlay = element$iv2 = iterator.next();
                boolean bl2 = false;
                Project project7 = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project7, (String)"getProject(...)");
                Task task2 = (Task)currentTask;
                Project project8 = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project8, (String)"getProject(...)");
                String string = DeployServerUtil.Companion.getServerWorkingDir(project8, server);
                Project project9 = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project9, (String)"getProject(...)");
                if (DeployServerUtil.Companion.isDistDownloadRequired(project9, server)) {
                    Object[] objectArray = new String[]{DownloadAndExtractServerDistTask.Companion.getNAME() + server.getName(), "downloadAndExtractCli"};
                    arrayList = CollectionsKt.arrayListOf((Object[])objectArray);
                } else {
                    arrayList = new ArrayList();
                }
                OverlaysUtil.Companion.defineOverlay(project7, task2, string, "deployIntegrationServer", overlay, arrayList, server.getName());
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lai/digital/integration/server/deploy/tasks/server/ServerCopyOverlaysTask$Companion;", "", "<init>", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

