/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.util;

import ai.digital.integration.server.common.util.ProcessUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lai/digital/integration/server/common/util/DockerUtil;", "", "<init>", "()V", "Companion", "integration-server-gradle-plugin"})
public final class DockerUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u000bJ\u001e\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005J\u0018\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J\u001e\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014\u00a8\u0006\u0015"}, d2={"Lai/digital/integration/server/common/util/DockerUtil$Companion;", "", "<init>", "()V", "execute", "", "project", "Lorg/gradle/api/Project;", "args", "", "logOutput", "", "throwErrorOnFailure", "inspect", "format", "instanceId", "findContainerIdByName", "containerName", "dockerLogs", "lastUpdate", "Ljava/time/LocalDateTime;", "integration-server-gradle-plugin"})
    @SourceDebugExtension(value={"SMAP\nDockerUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerUtil.kt\nai/digital/integration/server/common/util/DockerUtil$Companion\n+ 2 ProjectExtensions.kt\norg/gradle/kotlin/dsl/support/ProjectExtensionsKt\n+ 3 ServiceRegistryExtensions.kt\norg/gradle/kotlin/dsl/support/ServiceRegistryExtensionsKt\n*L\n1#1,49:1\n27#2:50\n22#3:51\n*S KotlinDebug\n*F\n+ 1 DockerUtil.kt\nai/digital/integration/server/common/util/DockerUtil$Companion\n*L\n22#1:50\n22#1:51\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String execute(@NotNull Project project, @NotNull List<String> args, boolean logOutput, boolean throwErrorOnFailure) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(args, (String)"args");
            return ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, project, "docker " + CollectionsKt.joinToString$default((Iterable)args, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null), null, logOutput, throwErrorOnFailure, 0L, 36, null);
        }

        public static /* synthetic */ String execute$default(Companion companion, Project project, List list, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 4) != 0) {
                bl = true;
            }
            if ((n & 8) != 0) {
                bl2 = true;
            }
            return companion.execute(project, list, bl, bl2);
        }

        @NotNull
        public final String inspect(@NotNull Project project, @NotNull String format, @NotNull String instanceId) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)format, (String)"format");
            Intrinsics.checkNotNullParameter((Object)instanceId, (String)"instanceId");
            ByteArrayOutputStream stdout = new ByteArrayOutputStream();
            Project $this$serviceOf$iv = project;
            boolean $i$f$serviceOf = false;
            ServiceRegistry serviceRegistry = ((ProjectInternal)$this$serviceOf$iv).getServices();
            Intrinsics.checkNotNullExpressionValue((Object)serviceRegistry, (String)"getServices(...)");
            ServiceRegistry $this$get$iv$iv = serviceRegistry;
            boolean $i$f$get = false;
            Object object = $this$get$iv$iv.get(ExecOperations.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            ExecOperations execOps = (ExecOperations)object;
            execOps.exec(new Action(format, instanceId, stdout){
                final /* synthetic */ String $format;
                final /* synthetic */ String $instanceId;
                final /* synthetic */ ByteArrayOutputStream $stdout;
                {
                    this.$format = $format;
                    this.$instanceId = $instanceId;
                    this.$stdout = $stdout;
                }

                public final void execute(ExecSpec $this$exec) {
                    Intrinsics.checkNotNullParameter((Object)$this$exec, (String)"$this$exec");
                    $this$exec.setExecutable("docker");
                    Object[] objectArray = new String[]{"inspect", "-f", this.$format, this.$instanceId};
                    $this$exec.setArgs(CollectionsKt.listOf((Object[])objectArray));
                    $this$exec.setStandardOutput((OutputStream)this.$stdout);
                }
            });
            String string = stdout.toString(StandardCharsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return ((Object)StringsKt.trim((CharSequence)string)).toString();
        }

        private final String findContainerIdByName(Project project, String containerName) {
            Object[] objectArray = new String[]{"ps", "-a", "-f", "name=" + containerName, "--format", "{{.ID}}"};
            ArrayList args = CollectionsKt.arrayListOf((Object[])objectArray);
            return ((Object)StringsKt.trim((CharSequence)ai.digital.integration.server.common.util.DockerUtil$Companion.execute$default(this, project, args, false, false, 8, null))).toString();
        }

        @NotNull
        public final String dockerLogs(@NotNull Project project, @NotNull String containerName, @NotNull LocalDateTime lastUpdate) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)containerName, (String)"containerName");
            Intrinsics.checkNotNullParameter((Object)lastUpdate, (String)"lastUpdate");
            DateTimeFormatter formatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
            String containerId = this.findContainerIdByName(project, containerName);
            Object[] objectArray = new String[]{"logs", containerId, "--since", lastUpdate.format(formatter)};
            ArrayList args = CollectionsKt.arrayListOf((Object[])objectArray);
            return ai.digital.integration.server.common.util.DockerUtil$Companion.execute$default(this, project, args, false, false, 8, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

