/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks.tls;

import ai.digital.integration.server.common.domain.Tls;
import ai.digital.integration.server.common.tls.KeytoolExportKeyToCertTask;
import ai.digital.integration.server.common.tls.KeytoolGenKeyTask;
import ai.digital.integration.server.common.tls.KeytoolImportKeyToTruststoreTask;
import ai.digital.integration.server.common.util.PropertiesUtil;
import ai.digital.integration.server.common.util.TlsUtil;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import ai.digital.integration.server.deploy.tasks.tls.TlsApplicationConfigurationOverrideTask;
import java.io.File;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.kotlin.dsl.GroovyInteroperabilityKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007J\u0012\u0010\u0006\u001a\u00020\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\u0012\u0010\t\u001a\u00020\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002\u00a8\u0006\u000b"}, d2={"Lai/digital/integration/server/deploy/tasks/tls/TlsApplicationConfigurationOverrideTask;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "run", "", "updateDeployitConf", "tls", "Lai/digital/integration/server/common/domain/Tls;", "updateWrapperConf", "Companion", "integration-server-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nTlsApplicationConfigurationOverrideTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TlsApplicationConfigurationOverrideTask.kt\nai/digital/integration/server/deploy/tasks/tls/TlsApplicationConfigurationOverrideTask\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,122:1\n1#2:123\n1869#3:124\n1869#3,2:125\n1869#3,2:127\n1869#3,2:129\n1869#3,2:131\n1869#3,2:133\n1870#3:135\n*S KotlinDebug\n*F\n+ 1 TlsApplicationConfigurationOverrideTask.kt\nai/digital/integration/server/deploy/tasks/tls/TlsApplicationConfigurationOverrideTask\n*L\n62#1:124\n64#1:125,2\n69#1:127,2\n74#1:129,2\n79#1:131,2\n82#1:133,2\n62#1:135\n*E\n"})
public class TlsApplicationConfigurationOverrideTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "tlsApplicationConfigurationOverride";

    public TlsApplicationConfigurationOverrideTask() {
        this.setGroup("Integration Server");
        this.configure(GroovyInteroperabilityKt.closureOf((Object)((Object)this), TlsApplicationConfigurationOverrideTask::_init_$lambda$10));
    }

    @TaskAction
    public final void run() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        Tls tls = TlsUtil.Companion.getTls(project, DeployServerUtil.Companion.getServerWorkingDir(project2));
        this.updateDeployitConf(tls);
        this.updateWrapperConf(tls);
    }

    private final void updateDeployitConf(Tls tls) {
        this.getProject().getLogger().lifecycle("Configurations TLS overriding for deployit.conf.");
        Project project = this.getProject();
        Tls tls2 = tls;
        Intrinsics.checkNotNull((Object)tls2);
        File file = project.file((Object)(tls2.confWorkDir() + "/deployit.conf"));
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file(...)");
        File deployitConf = file;
        Properties properties = PropertiesUtil.Companion.readPropertiesFile(deployitConf);
        ((Map)properties).put("ssl", "true");
        ((Map)properties).put("keystore.type", "pkcs12");
        ((Map)properties).put("keystore.password", tls.getKeyStorePassword());
        ((Map)properties).put("keystore.path", tls.keyStoreFile().getAbsolutePath());
        PropertiesUtil.Companion.writePropertiesFile(deployitConf, properties);
    }

    private final void updateWrapperConf(Tls tls) {
        this.getProject().getLogger().lifecycle("Configurations TLS overriding for xld-wrapper.conf.common.");
        Project project = this.getProject();
        Tls tls2 = tls;
        Intrinsics.checkNotNull((Object)tls2);
        File file = project.file((Object)(tls2.confWorkDir() + "/deployit.conf"));
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file(...)");
        File wrapperConf = file;
        Properties properties = PropertiesUtil.Companion.readPropertiesFile(wrapperConf);
        for (int pos = 0; pos < 20 && properties.containsKey("wrapper.java.additional." + pos); ++pos) {
        }
        PropertiesUtil.Companion.writePropertiesFile(wrapperConf, properties);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit _init_$lambda$10(TlsApplicationConfigurationOverrideTask $this$closureOf) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$closureOf), (String)"$this$closureOf");
        Project project = $this$closureOf.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = $this$closureOf.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        Tls tls = TlsUtil.Companion.getTls(project, DeployServerUtil.Companion.getServerWorkingDir(project2));
        if (tls != null) {
            Object object;
            Object[] objectArray;
            int n;
            Object[] objectArray2;
            Object[] it2;
            CharSequence charSequence;
            int n2;
            TaskContainer taskContainer;
            StringBuilder stringBuilder;
            Tls tls2 = tls;
            boolean bl = false;
            TaskContainer taskContainer2 = $this$closureOf.getProject().getTasks();
            Object[] objectArray3 = "keytoolGenKey";
            if (((CharSequence)objectArray3).length() > 0) {
                String string;
                void it2;
                char c = objectArray3.charAt(0);
                stringBuilder = new StringBuilder();
                taskContainer = taskContainer2;
                n2 = 0;
                if (Character.isLowerCase((char)it2)) {
                    Locale locale = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                    string = CharsKt.titlecase((char)it2, (Locale)locale);
                } else {
                    string = String.valueOf((char)it2);
                }
                charSequence = string;
                taskContainer2 = taskContainer;
                StringBuilder stringBuilder2 = stringBuilder.append((Object)charSequence);
                it2 = objectArray3;
                n2 = 1;
                String string2 = it2.substring(n2);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                objectArray2 = stringBuilder2.append(string2).toString();
            } else {
                objectArray2 = objectArray3;
            }
            TaskProvider taskProvider = taskContainer2.register("tls" + (String)objectArray2, KeytoolGenKeyTask.class, new Action(tls2){
                final /* synthetic */ Tls $tls;
                {
                    this.$tls = $tls;
                }

                public final void execute(KeytoolGenKeyTask $this$register) {
                    Intrinsics.checkNotNullParameter((Object)((Object)$this$register), (String)"$this$register");
                    $this$register.setKeyname("master_tls");
                    $this$register.setType("pkcs12");
                    $this$register.setTypeExtension("pk12");
                    $this$register.setWorkDir(this.$tls.confWorkDir());
                    $this$register.setKeypass(this.$tls.getKeyPassword());
                    $this$register.setStorepass(this.$tls.getKeyStorePassword());
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(...)");
            TaskProvider genKeyStore2 = taskProvider;
            TaskContainer taskContainer3 = $this$closureOf.getProject().getTasks();
            it2 = "keytoolExportKeyToCert";
            if (((CharSequence)it2).length() > 0) {
                String string;
                void it3;
                n2 = it2.charAt(0);
                stringBuilder = new StringBuilder();
                taskContainer = taskContainer3;
                n = 0;
                if (Character.isLowerCase((char)it3)) {
                    Locale locale = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                    string = CharsKt.titlecase((char)it3, (Locale)locale);
                } else {
                    string = String.valueOf((char)it3);
                }
                charSequence = string;
                taskContainer3 = taskContainer;
                StringBuilder stringBuilder3 = stringBuilder.append((Object)charSequence);
                Object[] objectArray4 = it2;
                n = 1;
                String string3 = objectArray4.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                objectArray = stringBuilder3.append(string3).toString();
            } else {
                objectArray = it2;
            }
            TaskProvider taskProvider2 = taskContainer3.register("tls" + (String)objectArray, KeytoolExportKeyToCertTask.class, new Action(tls2){
                final /* synthetic */ Tls $tls;
                {
                    this.$tls = $tls;
                }

                public final void execute(KeytoolExportKeyToCertTask $this$register) {
                    Intrinsics.checkNotNullParameter((Object)((Object)$this$register), (String)"$this$register");
                    $this$register.setKeyname("master_tls");
                    $this$register.setType("pkcs12");
                    $this$register.setTypeExtension("pk12");
                    $this$register.setWorkDir(this.$tls.confWorkDir());
                    $this$register.setKeypass(this.$tls.getKeyPassword());
                    $this$register.setStorepass(this.$tls.getKeyStorePassword());
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)taskProvider2, (String)"register(...)");
            TaskProvider genCert2 = taskProvider2;
            objectArray3 = new Object[]{genKeyStore2};
            $this$closureOf.getProject().getTasks().getByName(genCert2.getName()).dependsOn(objectArray3);
            TaskContainer taskContainer4 = $this$closureOf.getProject().getTasks();
            Iterator iterator = "keytoolImportKeyToTruststore";
            if (((CharSequence)((Object)iterator)).length() > 0) {
                String string;
                void it42;
                n = ((String)((Object)iterator)).charAt(0);
                stringBuilder = new StringBuilder();
                taskContainer = taskContainer4;
                boolean bl2 = false;
                if (Character.isLowerCase((char)it42)) {
                    Locale locale = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                    string = CharsKt.titlecase((char)it42, (Locale)locale);
                } else {
                    string = String.valueOf((char)it42);
                }
                charSequence = string;
                taskContainer4 = taskContainer;
                StringBuilder stringBuilder4 = stringBuilder.append((Object)charSequence);
                Iterator it42 = iterator;
                int n3 = 1;
                String string4 = ((String)((Object)it42)).substring(n3);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                object = stringBuilder4.append(string4).toString();
            } else {
                object = iterator;
            }
            TaskProvider taskProvider3 = taskContainer4.register("tls" + object, KeytoolImportKeyToTruststoreTask.class, new Action(tls2){
                final /* synthetic */ Tls $tls;
                {
                    this.$tls = $tls;
                }

                public final void execute(KeytoolImportKeyToTruststoreTask $this$register) {
                    Intrinsics.checkNotNullParameter((Object)((Object)$this$register), (String)"$this$register");
                    $this$register.setKeyname("master_tls");
                    $this$register.setType("pkcs12");
                    $this$register.setTypeExtension("pk12");
                    $this$register.setTruststore(this.$tls.getTrustStoreName());
                    $this$register.setWorkDir(this.$tls.confWorkDir());
                    $this$register.setKeypass(this.$tls.getKeyPassword());
                    $this$register.setStorepass(this.$tls.getTruststorePassword());
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)taskProvider3, (String)"register(...)");
            TaskProvider genTrustStore2 = taskProvider3;
            it2 = new Object[]{genCert2};
            $this$closureOf.getProject().getTasks().getByName(genTrustStore2.getName()).dependsOn(it2);
            it2 = new Object[]{genKeyStore2, genCert2, genTrustStore2};
            $this$closureOf.dependsOn(it2);
        }
        Object[] objectArray = new Object[]{"serverCopyOverlays"};
        $this$closureOf.mustRunAfter(objectArray);
        TaskContainer taskContainer = $this$closureOf.getProject().getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"getTasks(...)");
        Iterable $this$forEach$iv = (Iterable)taskContainer;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object[] objectArray5;
            Task otherTask;
            Iterable $this$forEach$iv2;
            Task task2 = (Task)element$iv;
            boolean bl = false;
            String string = task2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (StringsKt.startsWith$default((String)string, (String)"pekkoSecurePekko_ssl_master", (boolean)false, (int)2, null)) {
                TaskCollection taskCollection = $this$closureOf.getProject().getTasks().matching((Spec)1.2.1.INSTANCE);
                Intrinsics.checkNotNullExpressionValue((Object)taskCollection, (String)"matching(...)");
                $this$forEach$iv2 = (Iterable)taskCollection;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    otherTask = (Task)element$iv2;
                    boolean bl3 = false;
                    objectArray5 = new Object[]{otherTask};
                    task2.mustRunAfter(objectArray5);
                }
            }
            String string5 = task2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getName(...)");
            if (StringsKt.startsWith$default((String)string5, (String)"pekkoSecurePekko_ssl_master", (boolean)false, (int)2, null)) {
                TaskCollection taskCollection = $this$closureOf.getProject().getTasks().matching((Spec)1.2.3.INSTANCE);
                Intrinsics.checkNotNullExpressionValue((Object)taskCollection, (String)"matching(...)");
                $this$forEach$iv2 = (Iterable)taskCollection;
                boolean $i$f$forEach3 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    otherTask = (Task)element$iv2;
                    boolean bl4 = false;
                    objectArray5 = new Object[]{otherTask};
                    task2.mustRunAfter(objectArray5);
                }
            }
            String string6 = task2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getName(...)");
            if (StringsKt.startsWith$default((String)string6, (String)"pekkoSecurePekko_ssl_worker", (boolean)false, (int)2, null)) {
                TaskCollection taskCollection = $this$closureOf.getProject().getTasks().matching((Spec)1.2.5.INSTANCE);
                Intrinsics.checkNotNullExpressionValue((Object)taskCollection, (String)"matching(...)");
                $this$forEach$iv2 = (Iterable)taskCollection;
                boolean $i$f$forEach4 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    otherTask = (Task)element$iv2;
                    boolean bl5 = false;
                    objectArray5 = new Object[]{otherTask};
                    task2.mustRunAfter(objectArray5);
                }
            }
            String string7 = task2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getName(...)");
            if (!StringsKt.startsWith$default((String)string7, (String)"tls", (boolean)false, (int)2, null)) continue;
            TaskCollection taskCollection = $this$closureOf.getProject().getTasks().matching((Spec)1.2.7.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)taskCollection, (String)"matching(...)");
            $this$forEach$iv2 = (Iterable)taskCollection;
            boolean $i$f$forEach5 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                otherTask = (Task)element$iv2;
                boolean bl6 = false;
                objectArray5 = new Object[]{otherTask};
                task2.mustRunAfter(objectArray5);
            }
            TaskCollection taskCollection2 = $this$closureOf.getProject().getTasks().matching((Spec)1.2.9.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)taskCollection2, (String)"matching(...)");
            $this$forEach$iv2 = (Iterable)taskCollection2;
            $i$f$forEach5 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                otherTask = (Task)element$iv2;
                boolean bl7 = false;
                objectArray5 = new Object[]{otherTask};
                task2.mustRunAfter(objectArray5);
            }
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lai/digital/integration/server/deploy/tasks/tls/TlsApplicationConfigurationOverrideTask$Companion;", "", "<init>", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

