/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks.centralConfiguration;

import ai.digital.integration.server.common.util.HTTPUtil;
import ai.digital.integration.server.deploy.domain.CentralConfigurationServer;
import ai.digital.integration.server.deploy.internals.CentralConfigurationServerUtil;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\r"}, d2={"Lai/digital/integration/server/deploy/tasks/centralConfiguration/ShutdownCentralConfigurationServerTask;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "shutdown", "", "shutdownServer", "project", "Lorg/gradle/api/Project;", "waitForShutdown", "centralConfigurationServer", "Lai/digital/integration/server/deploy/domain/CentralConfigurationServer;", "Companion", "integration-server-gradle-plugin"})
public class ShutdownCentralConfigurationServerTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "shutdownCentralConfigurationServer";

    public ShutdownCentralConfigurationServerTask() {
        this.setGroup("Integration Server");
        this.onlyIf(new Spec(){

            public final boolean isSatisfiedBy(Task it) {
                Project project = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                return CentralConfigurationServerUtil.Companion.hasCentralConfigurationServer(project);
            }
        });
        this.getProject().afterEvaluate((Action)2.INSTANCE);
    }

    @TaskAction
    public final void shutdown() {
        this.getProject().getLogger().lifecycle("About to shut down central configuration server.");
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.shutdownServer(project);
    }

    private final void shutdownServer(Project project) {
        CentralConfigurationServer server = CentralConfigurationServerUtil.Companion.getCentralConfigurationServer(project);
        String port = CentralConfigurationServerUtil.Companion.readDeployitConfProperty(project, "http.port");
        try {
            project.getLogger().lifecycle("Trying to shutdown central configuration server on port " + port);
            HttpClient client = HttpClient.newHttpClient();
            String shutdownUrl = CentralConfigurationServerUtil.Companion.getBaseUrl(project) + "/actuator/shutdown";
            HttpRequest request = HTTPUtil.Companion.doRequest(shutdownUrl, "_xl-deploy-config-admin_", "admin").POST(HttpRequest.BodyPublishers.noBody()).build();
            client.send(request, HttpResponse.BodyHandlers.ofString());
            this.waitForShutdown(project, server);
            project.getLogger().lifecycle("Central Configuration Server at port " + port + " is now shutdown");
        }
        catch (Exception ignored) {
            project.getLogger().lifecycle("Central Configuration Server on port " + port + " is not running");
        }
    }

    private final void waitForShutdown(Project project, CentralConfigurationServer centralConfigurationServer) {
        int triesLeft = centralConfigurationServer.getPingTotalTries();
        String url = CentralConfigurationServerUtil.Companion.getBaseUrl(project);
        boolean success = false;
        while (triesLeft > 0 && !success) {
            try {
                HttpClient client = HttpClient.newHttpClient();
                HttpRequest request = HTTPUtil.Companion.doRequest$default(HTTPUtil.Companion, url, null, null, 6, null).POST(HttpRequest.BodyPublishers.noBody()).build();
                HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                project.getLogger().lifecycle("Waiting " + centralConfigurationServer.getPingRetrySleepTime() + " seconds for shutdown. (" + triesLeft + ")");
                TimeUnit.SECONDS.sleep(centralConfigurationServer.getPingRetrySleepTime());
                if (response.statusCode() == 200 || response.statusCode() == 401) continue;
                project.getLogger().lifecycle("Central Configuration Server successfully shutdown");
                success = true;
            }
            catch (Exception ignored) {
                project.getLogger().lifecycle("Central Configuration Server successfully shutdown.");
                success = true;
                break;
            }
        }
        if (!success) {
            throw new GradleException("Central Configuration Server failed to stop");
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lai/digital/integration/server/deploy/tasks/centralConfiguration/ShutdownCentralConfigurationServerTask$Companion;", "", "<init>", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

