/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.cluster.setup;

import ai.digital.integration.server.common.cluster.Helper;
import ai.digital.integration.server.common.cluster.setup.OnPremHelper;
import ai.digital.integration.server.common.constant.ClusterProfileName;
import ai.digital.integration.server.common.constant.ProductName;
import ai.digital.integration.server.common.domain.profiles.HelmProfile;
import ai.digital.integration.server.common.domain.profiles.OperatorProfile;
import ai.digital.integration.server.common.domain.profiles.Profile;
import ai.digital.integration.server.common.domain.providers.OnPremiseProvider;
import ai.digital.integration.server.common.util.ProcessUtil;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.provider.Property;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\b\u0016\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\f\u001a\u00020\rH\u0016J\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\u000fH\u0002JD\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010 \u001a\u00020\u0013J\u0012\u0010!\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0006\u0010\"\u001a\u00020\u000fJ\b\u0010#\u001a\u00020\u000fH\u0002J\b\u0010$\u001a\u00020\u0013H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006%"}, d2={"Lai/digital/integration/server/common/cluster/setup/OnPremHelper;", "Lai/digital/integration/server/common/cluster/Helper;", "project", "Lorg/gradle/api/Project;", "productName", "Lai/digital/integration/server/common/constant/ProductName;", "profile", "Lai/digital/integration/server/common/domain/profiles/Profile;", "<init>", "(Lorg/gradle/api/Project;Lai/digital/integration/server/common/constant/ProductName;Lai/digital/integration/server/common/domain/profiles/Profile;)V", "getProfile", "()Lai/digital/integration/server/common/domain/profiles/Profile;", "getProvider", "Lai/digital/integration/server/common/domain/providers/OnPremiseProvider;", "launchCluster", "", "validateMinikubeCli", "createCluster", "name", "", "driver", "clusterNodeCpus", "Lorg/gradle/api/provider/Property;", "", "clusterNodeMemory", "kubernetesVersion", "skipExisting", "", "onPremClusterName", "shouldSkipExisting", "updateContext", "updateEtcHosts", "fqdn", "getMinikubeIp", "destroyClusterOnShutdown", "deleteCluster", "getFqdn", "integration-server-gradle-plugin"})
public class OnPremHelper
extends Helper {
    @NotNull
    private final Profile profile;

    public OnPremHelper(@NotNull Project project, @NotNull ProductName productName, @NotNull Profile profile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)productName), (String)"productName");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        super(project, productName);
        this.profile = profile;
    }

    @NotNull
    public final Profile getProfile() {
        return this.profile;
    }

    @Override
    @NotNull
    public OnPremiseProvider getProvider() {
        OnPremiseProvider onPremiseProvider;
        String profileName = this.getProfileName();
        if (Intrinsics.areEqual((Object)profileName, (Object)ClusterProfileName.OPERATOR.getProfileName())) {
            Profile profile = this.profile;
            Intrinsics.checkNotNull((Object)profile, (String)"null cannot be cast to non-null type ai.digital.integration.server.common.domain.profiles.OperatorProfile");
            OperatorProfile operatorProfile = (OperatorProfile)profile;
            onPremiseProvider = operatorProfile.getOnPremise();
        } else if (Intrinsics.areEqual((Object)profileName, (Object)ClusterProfileName.HELM.getProfileName())) {
            Profile profile = this.profile;
            Intrinsics.checkNotNull((Object)profile, (String)"null cannot be cast to non-null type ai.digital.integration.server.common.domain.profiles.HelmProfile");
            HelmProfile helmProfile = (HelmProfile)profile;
            onPremiseProvider = helmProfile.getOnPremise();
        } else {
            throw new IllegalArgumentException("Provided profile name `" + profileName + "` is not supported");
        }
        return onPremiseProvider;
    }

    public final void launchCluster() {
        OnPremiseProvider onPremiseProvider = this.getProvider();
        Object object = onPremiseProvider.getName().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        String name = (String)object;
        Object object2 = onPremiseProvider.getSkipExisting().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        boolean skipExisting = (Boolean)object2;
        Object object3 = onPremiseProvider.getKubernetesVersion().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
        String kubernetesVersion = (String)object3;
        Object object4 = onPremiseProvider.getDriver().get();
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"get(...)");
        String driver = (String)object4;
        this.validateMinikubeCli();
        this.createCluster(name, driver, onPremiseProvider.getClusterNodeCpus(), onPremiseProvider.getClusterNodeMemory(), kubernetesVersion, skipExisting);
        this.updateContext(name);
    }

    private final void validateMinikubeCli() {
        ProcessUtil.Companion companion = ProcessUtil.Companion;
        Project project = this.getProject();
        String result = ProcessUtil.Companion.executeCommand$default(companion, project, "minikube version", null, false, false, 0L, 36, null);
        if (!StringsKt.contains$default((CharSequence)result, (CharSequence)"minikube version", (boolean)false, (int)2, null)) {
            throw new RuntimeException("No minikube-cli \"minikube\" in the path. Please verify your installation");
        }
    }

    private final void createCluster(String name, String driver, Property<Integer> clusterNodeCpus, Property<Integer> clusterNodeMemory, String kubernetesVersion, boolean skipExisting) {
        String clusterName = this.onPremClusterName(name);
        boolean shouldSkipExisting = this.shouldSkipExisting(name, skipExisting);
        if (shouldSkipExisting) {
            Object[] objectArray = new Object[]{clusterName};
            this.getProject().getLogger().lifecycle("Skipping creation of the existing minikube cluster: {}", objectArray);
        } else {
            Object[] objectArray = new Object[]{clusterName};
            this.getProject().getLogger().lifecycle("Create minikube cluster: {}", objectArray);
            String additions2 = "" + clusterNodeCpus.map((Transformer)createCluster.additions.1.INSTANCE).getOrElse((Object)"") + clusterNodeMemory.map((Transformer)createCluster.additions.2.INSTANCE).getOrElse((Object)"");
            ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "minikube start --driver=" + driver + " --kubernetes-version \"" + kubernetesVersion + "\" -p " + clusterName + " " + additions2, null, false, false, 0L, 60, null);
            ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "minikube addons enable ingress -p " + clusterName, null, false, false, 0L, 60, null);
            ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "minikube addons enable ingress-dns -p " + clusterName, null, false, false, 0L, 60, null);
        }
    }

    private final String onPremClusterName(String name) {
        return name;
    }

    private final boolean shouldSkipExisting(String name, boolean skipExisting) {
        boolean bl;
        String clusterName = this.onPremClusterName(name);
        if (skipExisting) {
            String string;
            ProcessUtil.Companion companion = ProcessUtil.Companion;
            Object object = this.getProject();
            String profileListResult = ProcessUtil.Companion.executeCommand$default(companion, object, string = "minikube profile list | grep " + clusterName, null, false, false, 0L, 36, null);
            if (StringsKt.contains$default((CharSequence)profileListResult, (CharSequence)clusterName, (boolean)false, (int)2, null)) {
                object = ProcessUtil.Companion;
                string = this.getProject();
                String profileResult = ProcessUtil.Companion.executeCommand$default((ProcessUtil.Companion)object, (Project)string, "minikube profile", null, false, false, 0L, 36, null);
                if (!StringsKt.contains$default((CharSequence)profileResult, (CharSequence)clusterName, (boolean)false, (int)2, null)) {
                    ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "minikube profile " + clusterName, null, false, false, 0L, 52, null);
                }
                bl = true;
            } else {
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private final void updateContext(String name) {
        String clusterName = this.onPremClusterName(name);
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "minikube update-context -p " + clusterName, null, false, false, 0L, 44, null);
    }

    public final void updateEtcHosts(@NotNull String name, @NotNull String fqdn) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)fqdn, (String)"fqdn");
        File infoScriptPath = Helper.getTemplate$default(this, "operator/on-perm/info_etc_hosts.sh", null, 2, null);
        File scriptPath = Helper.getTemplate$default(this, "operator/on-perm/update_etc_hosts.sh", null, 2, null);
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "chmod 755 \"" + infoScriptPath.getAbsolutePath() + "\"", null, false, false, 0L, 60, null);
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "chmod 755 \"" + scriptPath.getAbsolutePath() + "\"", null, false, false, 0L, 60, null);
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "\"" + infoScriptPath.getAbsolutePath() + "\"", null, false, false, 0L, 44, null);
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "sudo \"" + scriptPath.getAbsolutePath() + "\" " + this.getMinikubeIp(name) + " \"" + fqdn + "\"", null, false, false, 0L, 44, null);
    }

    public static /* synthetic */ void updateEtcHosts$default(OnPremHelper onPremHelper, String string, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: updateEtcHosts");
        }
        if ((n & 2) != 0) {
            string2 = onPremHelper.getFqdn();
        }
        onPremHelper.updateEtcHosts(string, string2);
    }

    private final String getMinikubeIp(String name) {
        String string;
        String clusterName = this.onPremClusterName(name);
        try {
            String ip = ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "minikube -p " + clusterName + " ip", null, false, false, 0L, 52, null);
            Object[] objectArray = new Object[]{clusterName, ip};
            this.getProject().getLogger().lifecycle("Get cluster IP for {}: {}", objectArray);
        }
        catch (RuntimeException e) {
            string = null;
        }
        return string;
    }

    public final void destroyClusterOnShutdown() {
        if (((Boolean)this.getProvider().getDestroyClusterOnShutdown().get()).booleanValue()) {
            this.deleteCluster();
            this.getProject().getLogger().lifecycle("Current cluster context is being deleted");
            this.getKubectlHelper().deleteCurrentContext();
        }
    }

    private final void deleteCluster() {
        OnPremiseProvider onPremiseProvider = this.getProvider();
        Object object = onPremiseProvider.getName().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        String name = (String)object;
        String clusterName = this.onPremClusterName(name);
        Object[] objectArray = new Object[]{clusterName};
        this.getProject().getLogger().lifecycle("Minikube cluster is being deleted {} ", objectArray);
        ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, this.getProject(), "minikube delete -p " + clusterName, null, false, false, 0L, 44, null);
    }

    @Override
    @NotNull
    public String getFqdn() {
        return this.getHost() + ".digitalai-testing.com";
    }
}

