/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks.worker;

import ai.digital.integration.server.common.util.HTTPUtil;
import ai.digital.integration.server.deploy.domain.Worker;
import ai.digital.integration.server.deploy.internals.CentralConfigurationServerUtil;
import ai.digital.integration.server.deploy.internals.WorkerUtil;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u0007\u001a\u00020\u0004H\u0007\u00a8\u0006\t"}, d2={"Lai/digital/integration/server/deploy/tasks/worker/PrepareWorkersTask;", "Lorg/gradle/api/DefaultTask;", "()V", "createConfFile", "", "worker", "Lai/digital/integration/server/deploy/domain/Worker;", "prepare", "Companion", "integration-server-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nPrepareWorkersTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrepareWorkersTask.kt\nai/digital/integration/server/deploy/tasks/worker/PrepareWorkersTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,47:1\n1863#2,2:48\n*S KotlinDebug\n*F\n+ 1 PrepareWorkersTask.kt\nai/digital/integration/server/deploy/tasks/worker/PrepareWorkersTask\n*L\n29#1:48,2\n*E\n"})
public class PrepareWorkersTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "prepareWorkersTask";

    public PrepareWorkersTask() {
        this.setGroup("Integration Server");
        this.onlyIf(new Spec(){

            public final boolean isSatisfiedBy(Task it) {
                Project project = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                return WorkerUtil.Companion.hasWorkers(project);
            }
        });
        this.onlyIf(new Spec(){

            public final boolean isSatisfiedBy(Task it) {
                Project project = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                return CentralConfigurationServerUtil.Companion.hasCentralConfigurationServer(project);
            }
        });
    }

    @TaskAction
    public final void prepare() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        Iterable $this$forEach$iv = WorkerUtil.Companion.getWorkers(project);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Worker worker = (Worker)element$iv;
            boolean bl = false;
            this.createConfFile(worker);
        }
    }

    private final void createConfFile(Worker worker) {
        this.getProject().getLogger().lifecycle("Creating deployit.conf file for " + worker.getName());
        Project project = this.getProject();
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        File file = project.file((Object)(WorkerUtil.Companion.getWorkerWorkingDir(project2, worker) + "/conf/deployit.conf"));
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.file(\"${WorkerUt\u2026er)}/conf/deployit.conf\")");
        File file2 = file;
        if (!file2.getParentFile().exists()) {
            file2.getParentFile().mkdirs();
        }
        file2.createNewFile();
        FilesKt.appendText$default((File)file2, (String)("http.port=" + HTTPUtil.Companion.findFreePort() + "\n"), null, (int)2, null);
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
        FilesKt.appendText$default((File)file2, (String)("xl.spring.cloud.uri=" + CentralConfigurationServerUtil.Companion.getBaseUrl(project3) + "/centralConfiguration/\n"), null, (int)2, null);
        FilesKt.appendText$default((File)file2, (String)"xl.spring.cloud.external-config=true\n", null, (int)2, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/digital/integration/server/deploy/tasks/worker/PrepareWorkersTask$Companion;", "", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

