/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks.server.operator;

import ai.digital.integration.server.common.cluster.util.OperatorUtil;
import ai.digital.integration.server.common.constant.ProductName;
import ai.digital.integration.server.common.domain.Server;
import ai.digital.integration.server.common.util.DockerComposeUtil;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;
import org.gradle.kotlin.dsl.GroovyInteroperabilityKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u0007\u001a\u00020\u0006H\u0007J\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lai/digital/integration/server/deploy/tasks/server/operator/StartDeployServerForOperatorInstanceTask;", "Lorg/gradle/api/DefaultTask;", "()V", "clusterUtil", "Lai/digital/integration/server/common/cluster/util/OperatorUtil;", "allowToWriteMountedHostFolders", "", "launch", "start", "server", "Lai/digital/integration/server/common/domain/Server;", "Companion", "integration-server-gradle-plugin"})
public class StartDeployServerForOperatorInstanceTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OperatorUtil clusterUtil;
    @NotNull
    public static final String NAME = "startDeployServerForOperatorInstance";

    public StartDeployServerForOperatorInstanceTask() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        this.clusterUtil = new OperatorUtil(project);
        this.setGroup("Integration Server");
        Object[] objectArray = new String[]{"operatorCentralConfiguration", "prepareOperatorServer", "serverCopyOverlays"};
        final List dependencies = CollectionsKt.mutableListOf((Object[])objectArray);
        this.configure(GroovyInteroperabilityKt.closureOf((Object)((Object)this), (Function1)((Function1)new Function1<StartDeployServerForOperatorInstanceTask, Unit>(){

            public final void invoke(StartDeployServerForOperatorInstanceTask $this$closureOf) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$closureOf), (String)"$this$closureOf");
                Object[] objectArray = new Object[]{dependencies};
                $this$closureOf.dependsOn(objectArray);
            }
        })));
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void start(Server server) {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        Integer currentPort = DeployServerUtil.Companion.getDockerContainerPort(project, server, 4516);
        if (currentPort != null) {
            int n = server.getHttpPort();
            if (currentPort == n) {
                this.getProject().getLogger().lifecycle("Deploy Server " + server.getName() + " " + server.getVersion() + " on port " + server.getHttpPort() + " is already running. Not starting it!");
                return;
            }
        }
        this.getProject().getLogger().lifecycle("Deploy Server " + server.getName() + " " + server.getVersion() + " on port " + server.getHttpPort() + " is not running. Starting it!");
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        DeployServerUtil.Companion.runDockerBasedInstance(project2, server);
    }

    private final void allowToWriteMountedHostFolders() {
        this.clusterUtil.grantPermissionsToIntegrationServerFolder();
    }

    @TaskAction
    public final void launch() {
        Server server = this.clusterUtil.getOperatorServer();
        this.getProject().getLogger().lifecycle("About to launch Deploy Server " + server.getName() + " " + server.getVersion() + " on port " + server.getHttpPort() + ".");
        this.allowToWriteMountedHostFolders();
        this.start(server);
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        new OperatorUtil(project).waitForBoot(server);
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        File dockerComposeFile = DeployServerUtil.Companion.getResolvedDockerFile(project2, server).toFile();
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
        Intrinsics.checkNotNullExpressionValue((Object)dockerComposeFile, (String)"dockerComposeFile");
        DockerComposeUtil.Companion.allowToCleanMountedFiles(project3, ProductName.DEPLOY, server, dockerComposeFile);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/digital/integration/server/deploy/tasks/server/operator/StartDeployServerForOperatorInstanceTask$Companion;", "", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

