/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks.satellite;

import ai.digital.integration.server.common.domain.Server;
import ai.digital.integration.server.common.util.ProcessUtil;
import ai.digital.integration.server.common.util.WaitForBootUtil;
import ai.digital.integration.server.deploy.domain.Satellite;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import ai.digital.integration.server.deploy.internals.EnvironmentUtil;
import ai.digital.integration.server.deploy.internals.SatelliteUtil;
import java.io.File;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00052\u00020\u0001:\u0001\u0005B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0006"}, d2={"Lai/digital/integration/server/deploy/tasks/satellite/StartSatelliteTask;", "Lorg/gradle/api/DefaultTask;", "()V", "launch", "", "Companion", "integration-server-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nStartSatelliteTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StartSatelliteTask.kt\nai/digital/integration/server/deploy/tasks/satellite/StartSatelliteTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,72:1\n1863#2,2:73\n*S KotlinDebug\n*F\n+ 1 StartSatelliteTask.kt\nai/digital/integration/server/deploy/tasks/satellite/StartSatelliteTask\n*L\n31#1:73,2\n*E\n"})
public class StartSatelliteTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "startSatellite";

    public StartSatelliteTask() {
        this.setGroup("Integration Server");
        Object[] objectArray = new Object[]{"downloadAndExtractSatelliteServer"};
        this.dependsOn(objectArray);
        objectArray = new Object[]{"prepareSatellites"};
        this.dependsOn(objectArray);
        objectArray = new Object[]{"satelliteOverlays"};
        this.dependsOn(objectArray);
        objectArray = new Object[]{"satelliteSyncPlugins"};
        this.dependsOn(objectArray);
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        if (DeployServerUtil.Companion.isTls(project)) {
            objectArray = new Object[]{"tlsApplicationConfigurationOverride"};
            this.dependsOn(objectArray);
        }
    }

    @TaskAction
    public final void launch() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        Iterable $this$forEach$iv = SatelliteUtil.Companion.getSatellites(project);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File file;
            Satellite satellite = (Satellite)element$iv;
            boolean bl = false;
            Project project2 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
            File binDir = SatelliteUtil.Companion.getBinDir(project2, satellite);
            this.getProject().getLogger().lifecycle("Launching Satellite '" + satellite.getName() + " from " + binDir + "'.");
            Project project3 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
            Map<String, String> environment = EnvironmentUtil.Companion.getEnv(project3, "JDK_JAVA_OPTIONS", satellite.getDebugSuspend(), satellite.getDebugPort(), "xl-satellite.log");
            this.getProject().getLogger().info("Starting worker with environment: " + environment);
            Pair[] pairArray = new Pair[5];
            pairArray[0] = TuplesKt.to((Object)"command", (Object)"run");
            pairArray[1] = TuplesKt.to((Object)"environment", environment);
            pairArray[2] = TuplesKt.to((Object)"workDir", (Object)binDir);
            CharSequence charSequence = satellite.getStdoutFileName();
            pairArray[3] = TuplesKt.to((Object)"discardIO", (Object)(charSequence == null || charSequence.length() == 0 ? 1 : 0));
            charSequence = satellite.getStdoutFileName();
            if (!(charSequence == null || charSequence.length() == 0)) {
                Project project4 = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"project");
                file = new File(SatelliteUtil.Companion.getSatelliteLogDir(project4, satellite) + "/" + satellite.getStdoutFileName());
            } else {
                file = null;
            }
            pairArray[4] = TuplesKt.to((Object)"redirectTo", (Object)file);
            Process process = ProcessUtil.Companion.exec(MapsKt.mapOf((Pair[])pairArray));
            this.getProject().getLogger().lifecycle("Satellite '" + satellite.getName() + "' successfully started on PID [" + process.pid() + "] with command [" + process.info().commandLine().orElse("") + "].");
            Project project5 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project5, (String)"project");
            Server server = DeployServerUtil.Companion.getServer(project5);
            Project project6 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project6, (String)"project");
            String string = "Satellite " + satellite.getName();
            Project project7 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project7, (String)"project");
            WaitForBootUtil.Companion.byLog(project6, string, SatelliteUtil.Companion.getSatelliteLog(project7, satellite), "XL Satellite has started", process, server.getPingRetrySleepTime(), server.getPingTotalTries());
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/digital/integration/server/deploy/tasks/satellite/StartSatelliteTask$Companion;", "", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

