/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.util;

import ai.digital.integration.server.common.util.ProcessUtil;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.konan.file.File;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lai/digital/integration/server/common/util/JavaUtil;", "", "()V", "Companion", "integration-server-gradle-plugin"})
public final class JavaUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001c\u0010\f\u001a\u00020\r2\u0014\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000fJ\"\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0005\u00a8\u0006\u0012"}, d2={"Lai/digital/integration/server/common/util/JavaUtil$Companion;", "", "()V", "debugJvmArg", "", "", "project", "Lorg/gradle/api/Project;", "debugPort", "", "debugSuspend", "", "execJava", "Ljava/lang/Process;", "config", "", "jvmPath", "integrationServerJVMPath", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Process execJava(@NotNull Map<String, ? extends Object> config) {
            Intrinsics.checkNotNullParameter(config, (String)"config");
            Object object = config.getOrDefault("jvmPath", File.Companion.getJavaHome() + File.Companion.getSeparator() + "bin" + File.Companion.getSeparator() + "java");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
            String jvmPath = (String)object;
            Object object2 = config.getOrDefault("jvmArgs", CollectionsKt.emptyList());
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.String>");
            List jvmArgs = (List)object2;
            Object object3 = config.getOrDefault("programArgs", CollectionsKt.emptyList());
            Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.String>");
            List programArgs = (List)object3;
            Object object4 = config.get("mainClass");
            Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type kotlin.String");
            String mainClass = (String)object4;
            Object object5 = config.getOrDefault("environment", MapsKt.emptyMap());
            Intrinsics.checkNotNull((Object)object5, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.String>");
            Map configEnvironment = (Map)object5;
            Map environment = new LinkedHashMap();
            environment.putAll(configEnvironment);
            List params2 = new ArrayList();
            params2.addAll(jvmArgs);
            params2.add(mainClass);
            params2.addAll(programArgs);
            Map command = new LinkedHashMap();
            command.putAll(config);
            command.put("command", jvmPath);
            command.put("runLocalShell", false);
            command.put("params", params2);
            command.put("environment", environment);
            return ProcessUtil.Companion.exec(command);
        }

        @NotNull
        public final List<String> debugJvmArg(@NotNull Project project, int debugPort, boolean debugSuspend) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            project.getLogger().lifecycle("Enabled debug mode on port " + debugPort);
            Object[] objectArray = new String[]{"-Xdebug", DeployServerUtil.Companion.createDebugString(debugSuspend, debugPort)};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        @NotNull
        public final Map<String, String> jvmPath(@NotNull Project project, @NotNull String integrationServerJVMPath) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)integrationServerJVMPath, (String)"integrationServerJVMPath");
            String jvmPath = integrationServerJVMPath + File.Companion.getSeparator() + "bin" + File.Companion.getSeparator() + "java";
            project.getLogger().lifecycle("Using JVM from location: " + jvmPath);
            return MapsKt.mapOf((Pair)TuplesKt.to((Object)"jvmPath", (Object)jvmPath));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

