/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lai/digital/integration/server/common/util/ProcessUtil;", "", "()V", "Companion", "integration-server-gradle-plugin"})
public final class ProcessUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u000b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001c\u0010\u000f\u001a\u00020\u00102\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0012J\"\u0010\u0013\u001a\u00020\u00042\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u0015J.\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u000eJ8\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\b2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u00152\b\b\u0002\u0010\u0019\u001a\u00020\u000e2\b\b\u0002\u0010\u001d\u001a\u00020\u000e2\b\b\u0002\u0010\u001e\u001a\u00020\u001fJB\u0010\u001a\u001a\u00020\b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001b\u001a\u00020\b2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u00152\b\b\u0002\u0010\u0019\u001a\u00020\u000e2\b\b\u0002\u0010\u001d\u001a\u00020\u000e2\b\b\u0002\u0010\u001e\u001a\u00020\u001fJ$\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\"2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00040$H\u0002\u00a8\u0006%"}, d2={"Lai/digital/integration/server/common/util/ProcessUtil$Companion;", "", "()V", "chMod", "", "project", "Lorg/gradle/api/Project;", "mode", "", "fileName", "createRunCommand", "", "baseCommand", "runLocalShell", "", "exec", "Ljava/lang/Process;", "config", "", "execAndCheck", "logFile", "Ljava/io/File;", "execute", "arguments", "", "logOutput", "executeCommand", "command", "workDir", "throwErrorOnFailure", "waitTimeoutSeconds", "", "readLines", "reader", "Ljava/io/BufferedReader;", "lineHandler", "Lkotlin/Function1;", "integration-server-gradle-plugin"})
    @SourceDebugExtension(value={"SMAP\nProcessUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProcessUtil.kt\nai/digital/integration/server/common/util/ProcessUtil$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,194:1\n1#2:195\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final List<String> createRunCommand(String baseCommand, boolean runLocalShell) {
            List list;
            if (runLocalShell) {
                if (Os.isFamily((String)"windows")) {
                    Object[] objectArray = new String[]{"cmd", "/c", baseCommand + ".cmd"};
                    list = CollectionsKt.mutableListOf((Object[])objectArray);
                } else {
                    Object[] objectArray = new String[]{"./" + baseCommand + ".sh"};
                    list = CollectionsKt.mutableListOf((Object[])objectArray);
                }
            } else {
                Object[] objectArray = new String[]{baseCommand};
                list = CollectionsKt.mutableListOf((Object[])objectArray);
            }
            return list;
        }

        public final void execAndCheck(@NotNull Map<String, ? extends Object> config, @NotNull File logFile) {
            Intrinsics.checkNotNullParameter(config, (String)"config");
            Intrinsics.checkNotNullParameter((Object)logFile, (String)"logFile");
            if (this.exec(config).exitValue() == 1) {
                throw new RuntimeException("Running process was not successfully executed. Check logs [" + logFile + "] for more information.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final String execute(@NotNull Project project, @NotNull String exec, @NotNull List<String> arguments, boolean logOutput) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)exec, (String)"exec");
            Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
            project.getLogger().lifecycle("About to execute `" + exec + " " + CollectionsKt.joinToString$default((Iterable)arguments, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + "`");
            if (logOutput) {
                try (ByteArrayOutputStream stdout = new ByteArrayOutputStream();){
                    project.exec(new Action(arguments, exec, stdout){
                        final /* synthetic */ List<String> $arguments;
                        final /* synthetic */ String $exec;
                        final /* synthetic */ ByteArrayOutputStream $stdout;
                        {
                            this.$arguments = $arguments;
                            this.$exec = $exec;
                            this.$stdout = $stdout;
                        }

                        public final void execute(ExecSpec $this$exec) {
                            Intrinsics.checkNotNullParameter((Object)$this$exec, (String)"$this$exec");
                            $this$exec.setArgs(this.$arguments);
                            $this$exec.setExecutable(this.$exec);
                            $this$exec.setStandardOutput((OutputStream)this.$stdout);
                        }
                    });
                    String output = stdout.toString(StandardCharsets.UTF_8);
                    project.getLogger().lifecycle(output);
                    Intrinsics.checkNotNullExpressionValue((Object)output, (String)"output");
                    String string = output;
                    return string;
                }
            }
            try (NullOutputStream stdout = new NullOutputStream();){
                project.exec(new Action(arguments, exec, stdout){
                    final /* synthetic */ List<String> $arguments;
                    final /* synthetic */ String $exec;
                    final /* synthetic */ NullOutputStream $stdout;
                    {
                        this.$arguments = $arguments;
                        this.$exec = $exec;
                        this.$stdout = $stdout;
                    }

                    public final void execute(ExecSpec $this$exec) {
                        Intrinsics.checkNotNullParameter((Object)$this$exec, (String)"$this$exec");
                        $this$exec.setArgs(this.$arguments);
                        $this$exec.setExecutable(this.$exec);
                        $this$exec.setStandardOutput((OutputStream)this.$stdout);
                        $this$exec.setErrorOutput((OutputStream)this.$stdout);
                    }
                });
            }
            return "";
        }

        public static /* synthetic */ String execute$default(Companion companion, Project project, String string, List list, boolean bl, int n, Object object) {
            if ((n & 8) != 0) {
                bl = true;
            }
            return companion.execute(project, string, list, bl);
        }

        @NotNull
        public final Process exec(@NotNull Map<String, ? extends Object> config) {
            Intrinsics.checkNotNullParameter(config, (String)"config");
            Object object = config.getOrDefault("runLocalShell", (Object)true);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
            boolean runLocalShell = (Boolean)object;
            Object object2 = config.get("command");
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.String");
            List<String> command = this.createRunCommand((String)object2, runLocalShell);
            if (config.get("params") != null) {
                Object object3 = config.get("params");
                Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.String>");
                command.addAll((List)object3);
            }
            ProcessBuilder processBuilder = new ProcessBuilder(command);
            if (config.get("environment") != null) {
                Map<String, String> map = processBuilder.environment();
                Object object4 = config.get("environment");
                Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.String>");
                map.putAll((Map)object4);
            }
            if (config.get("workDir") != null) {
                Object object5 = config.get("workDir");
                Intrinsics.checkNotNull((Object)object5, (String)"null cannot be cast to non-null type java.io.File");
                processBuilder.directory((File)object5);
            }
            if (config.get("inheritIO") != null) {
                processBuilder.inheritIO();
            }
            if (config.get("discardIO") != null) {
                processBuilder.redirectOutput(ProcessBuilder.Redirect.DISCARD);
                processBuilder.redirectError(ProcessBuilder.Redirect.DISCARD);
            }
            if (config.get("redirectTo") != null) {
                processBuilder.redirectErrorStream(true);
                Object object6 = config.get("redirectTo");
                Intrinsics.checkNotNull((Object)object6, (String)"null cannot be cast to non-null type java.io.File");
                File redirectTo = (File)object6;
                if (!redirectTo.getParentFile().isDirectory()) {
                    redirectTo.getParentFile().mkdirs();
                }
                processBuilder.redirectOutput(ProcessBuilder.Redirect.to(redirectTo));
            }
            Process process = processBuilder.start();
            if (config.get("wait") != null) {
                process.waitFor();
            }
            Intrinsics.checkNotNullExpressionValue((Object)process, (String)"process");
            return process;
        }

        public final void chMod(@NotNull Project project, @NotNull String mode, @NotNull String fileName) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            project.exec(new Action(mode, fileName){
                final /* synthetic */ String $mode;
                final /* synthetic */ String $fileName;
                {
                    this.$mode = $mode;
                    this.$fileName = $fileName;
                }

                public final void execute(ExecSpec $this$exec) {
                    Intrinsics.checkNotNullParameter((Object)$this$exec, (String)"$this$exec");
                    $this$exec.setExecutable("chmod");
                    Object[] objectArray = new String[]{"-R", this.$mode, this.$fileName};
                    $this$exec.setArgs(CollectionsKt.listOf((Object[])objectArray));
                }
            });
        }

        @NotNull
        public final String executeCommand(@NotNull String command, @Nullable File workDir, boolean logOutput, boolean throwErrorOnFailure, long waitTimeoutSeconds) {
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            return this.executeCommand(null, command, workDir, logOutput, throwErrorOnFailure, waitTimeoutSeconds);
        }

        public static /* synthetic */ String executeCommand$default(Companion companion, String string, File file, boolean bl, boolean bl2, long l, int n, Object object) {
            if ((n & 2) != 0) {
                file = null;
            }
            if ((n & 4) != 0) {
                bl = true;
            }
            if ((n & 8) != 0) {
                bl2 = true;
            }
            if ((n & 0x10) != 0) {
                l = 10L;
            }
            return companion.executeCommand(string, file, bl, bl2, l);
        }

        @NotNull
        public final String executeCommand(@Nullable Project project, @NotNull String command, @Nullable File workDir, boolean logOutput, boolean throwErrorOnFailure, long waitTimeoutSeconds) {
            Process process;
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            String[] stringArray = new String[]{"sh", "-c", command};
            String[] execCommand = stringArray;
            if (workDir != null) {
                Process process2 = Runtime.getRuntime().exec(execCommand, null, workDir);
                process = process2;
                Intrinsics.checkNotNullExpressionValue((Object)process2, (String)"getRuntime().exec(execCommand, null, workDir)");
            } else {
                Process process3 = Runtime.getRuntime().exec(execCommand);
                process = process3;
                Intrinsics.checkNotNullExpressionValue((Object)process3, (String)"getRuntime().exec(execCommand)");
            }
            Process process4 = process;
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(process4.getInputStream()));
            BufferedReader stdError = new BufferedReader(new InputStreamReader(process4.getErrorStream()));
            if (workDir == null) {
                ai.digital.integration.server.common.util.ProcessUtil$Companion.executeCommand$print$default(project, logOutput, "About to execute `" + command + "`", false, 8, null);
            } else {
                ai.digital.integration.server.common.util.ProcessUtil$Companion.executeCommand$print$default(project, logOutput, "About to execute `" + command + "` in work dir `" + workDir.getAbsolutePath() + "`", false, 8, null);
            }
            String input2 = this.readLines(stdInput, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(project, logOutput){
                final /* synthetic */ Project $project;
                final /* synthetic */ boolean $logOutput;
                {
                    this.$project = $project;
                    this.$logOutput = $logOutput;
                    super(1);
                }

                public final void invoke(String line) {
                    Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                    ai.digital.integration.server.common.util.ProcessUtil$Companion.executeCommand$print$default(this.$project, this.$logOutput, line, false, 8, null);
                }
            }));
            String error2 = this.readLines(stdError, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(project, logOutput){
                final /* synthetic */ Project $project;
                final /* synthetic */ boolean $logOutput;
                {
                    this.$project = $project;
                    this.$logOutput = $logOutput;
                    super(1);
                }

                public final void invoke(String line) {
                    Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                    ai.digital.integration.server.common.util.ProcessUtil$Companion.access$executeCommand$print(this.$project, this.$logOutput, line, true);
                }
            }));
            if (process4.waitFor(waitTimeoutSeconds, TimeUnit.SECONDS)) {
                if (throwErrorOnFailure && process4.exitValue() != 0) {
                    throw new RuntimeException("Process '" + command + "' failed with exit value " + process4.exitValue() + ": " + error2);
                }
            } else if (throwErrorOnFailure) {
                throw new RuntimeException("Process '" + command + "' not finished");
            }
            return ((CharSequence)error2).length() == 0 ? input2 : input2 + System.lineSeparator() + error2;
        }

        public static /* synthetic */ String executeCommand$default(Companion companion, Project project, String string, File file, boolean bl, boolean bl2, long l, int n, Object object) {
            if ((n & 4) != 0) {
                file = null;
            }
            if ((n & 8) != 0) {
                bl = true;
            }
            if ((n & 0x10) != 0) {
                bl2 = true;
            }
            if ((n & 0x20) != 0) {
                l = 10L;
            }
            return companion.executeCommand(project, string, file, bl, bl2, l);
        }

        private final String readLines(BufferedReader reader, Function1<? super String, Unit> lineHandler) {
            Object result = null;
            result = "";
            String line = null;
            line = "";
            while (true) {
                String string;
                String it = string = reader.readLine();
                boolean bl = false;
                if (it != null) {
                    line = it;
                }
                if (string == null) break;
                it = string = line;
                boolean bl2 = false;
                if (((CharSequence)result).length() > 0) {
                    result = result + System.lineSeparator();
                }
                result = result + it;
                lineHandler.invoke((Object)line);
            }
            return result;
        }

        private static final void executeCommand$print(Project $project, boolean $logOutput, String msg, boolean error2) {
            if ($project != null && ((CharSequence)msg).length() > 0 && $logOutput) {
                if (error2) {
                    $project.getLogger().error(msg);
                } else {
                    $project.getLogger().lifecycle(msg);
                }
            }
        }

        static /* synthetic */ void executeCommand$print$default(Project project, boolean bl, String string, boolean bl2, int n, Object object) {
            if ((n & 8) != 0) {
                bl2 = false;
            }
            ai.digital.integration.server.common.util.ProcessUtil$Companion.executeCommand$print(project, bl, string, bl2);
        }

        public static final /* synthetic */ void access$executeCommand$print(Project $project, boolean $logOutput, String msg, boolean error2) {
            ai.digital.integration.server.common.util.ProcessUtil$Companion.executeCommand$print($project, $logOutput, msg, error2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

