/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks.provision;

import ai.digital.integration.server.common.constant.ProductName;
import ai.digital.integration.server.common.domain.DevOpsAsCode;
import ai.digital.integration.server.common.domain.Server;
import ai.digital.integration.server.common.util.HTTPUtil;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import ai.digital.integration.server.deploy.internals.EntryPointUrlUtil;
import ai.digital.integration.server.deploy.internals.WorkerUtil;
import java.io.File;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.Charsets;
import org.gradle.api.DefaultTask;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\u0018\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u000b"}, d2={"Lai/digital/integration/server/deploy/tasks/provision/RunDevOpsAsCodeTask;", "Lorg/gradle/api/DefaultTask;", "()V", "launch", "", "launchDevOpAsCodeScripts", "project", "Lorg/gradle/api/Project;", "server", "Lai/digital/integration/server/common/domain/Server;", "Companion", "integration-server-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nRunDevOpsAsCodeTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RunDevOpsAsCodeTask.kt\nai/digital/integration/server/deploy/tasks/provision/RunDevOpsAsCodeTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,84:1\n1863#2:85\n1864#2:88\n37#3,2:86\n*S KotlinDebug\n*F\n+ 1 RunDevOpsAsCodeTask.kt\nai/digital/integration/server/deploy/tasks/provision/RunDevOpsAsCodeTask\n*L\n37#1:85\n37#1:88\n62#1:86,2\n*E\n"})
public class RunDevOpsAsCodeTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "runDevOpsAsCode";

    public RunDevOpsAsCodeTask() {
        this.setGroup("Integration Server");
        Object[] objectArray = new Object[]{"startDeployServerInstance"};
        this.dependsOn(objectArray);
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        if (WorkerUtil.Companion.hasWorkers(project)) {
            objectArray = new Object[]{"startWorkers"};
            this.dependsOn(objectArray);
        }
    }

    private final void launchDevOpAsCodeScripts(Project project, Server server) {
        block4: {
            if (server.getDevOpsAsCodes() == null) break block4;
            NamedDomainObjectContainer<DevOpsAsCode> namedDomainObjectContainer = server.getDevOpsAsCodes();
            if (namedDomainObjectContainer != null) {
                Iterable $this$forEach$iv = (Iterable)namedDomainObjectContainer;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    DevOpsAsCode devOpsAsCode = (DevOpsAsCode)element$iv;
                    boolean bl = false;
                    if (devOpsAsCode.getDevOpAsCodeScript() != null) {
                        File script;
                        boolean bl2 = false;
                        HttpClient client = HttpClient.newHttpClient();
                        List headers = new ArrayList();
                        RunDevOpsAsCodeTask.launchDevOpAsCodeScripts$lambda$1$lambda$0$addHeaders(headers, "X-Xebialabs-Scm-Author", devOpsAsCode.getScmAuthor());
                        RunDevOpsAsCodeTask.launchDevOpAsCodeScripts$lambda$1$lambda$0$addHeaders(headers, "X-Xebialabs-Scm-Commit", devOpsAsCode.getScmCommit());
                        RunDevOpsAsCodeTask.launchDevOpAsCodeScripts$lambda$1$lambda$0$addHeaders(headers, "X-Xebialabs-Scm-Date", devOpsAsCode.getScmDate());
                        RunDevOpsAsCodeTask.launchDevOpAsCodeScripts$lambda$1$lambda$0$addHeaders(headers, "X-Xebialabs-Scm-Filename", devOpsAsCode.getScmFile());
                        RunDevOpsAsCodeTask.launchDevOpAsCodeScripts$lambda$1$lambda$0$addHeaders(headers, "X-Xebialabs-Scm-Message", devOpsAsCode.getScmMessage());
                        RunDevOpsAsCodeTask.launchDevOpAsCodeScripts$lambda$1$lambda$0$addHeaders(headers, "X-Xebialabs-Scm-Remote", devOpsAsCode.getScmRemote());
                        RunDevOpsAsCodeTask.launchDevOpAsCodeScripts$lambda$1$lambda$0$addHeaders(headers, "X-Xebialabs-Scm-Type", devOpsAsCode.getScmType());
                        HttpRequest.Builder builder = HTTPUtil.Companion.doRequest$default(HTTPUtil.Companion, EntryPointUrlUtil.composeUrl$default(new EntryPointUrlUtil(project, ProductName.DEPLOY, false, 4, null), "/deployit/devops-as-code/apply", false, 2, null), null, null, 6, null);
                        SpreadBuilder spreadBuilder = new SpreadBuilder(3);
                        spreadBuilder.add((Object)"Content-Type");
                        spreadBuilder.add((Object)"text/vnd.yaml");
                        Collection $this$toTypedArray$iv = headers;
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        spreadBuilder.addSpread((Object)thisCollection$iv.toArray(new String[0]));
                        HttpRequest.Builder builder2 = builder.headers((String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()]));
                        File file = script.toPath().toFile();
                        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"script.toPath().toFile()");
                        HttpRequest request = builder2.POST(HttpRequest.BodyPublishers.ofString(FilesKt.readText((File)file, (Charset)Charsets.UTF_8))).build();
                        HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                        if (response.statusCode() == 200) {
                            project.getLogger().info("YAML " + devOpsAsCode.getDevOpAsCodeScript() + " has been applied.");
                            continue;
                        }
                        project.getLogger().error(response.body());
                    }
                }
            }
        }
    }

    @TaskAction
    public final void launch() {
        this.getProject().getLogger().lifecycle("Running Dev Ops as Code provision script on the Deploy server.");
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        this.launchDevOpAsCodeScripts(project, DeployServerUtil.Companion.getServer(project2));
    }

    private static final void launchDevOpAsCodeScripts$lambda$1$lambda$0$addHeaders(List<String> headers, String key, String value2) {
        if (value2 != null) {
            Object[] objectArray = new String[]{key, value2};
            headers.addAll(CollectionsKt.arrayListOf((Object[])objectArray));
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/digital/integration/server/deploy/tasks/provision/RunDevOpsAsCodeTask$Companion;", "", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

