/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.release.tasks.cluster.operator;

import ai.digital.integration.server.common.cluster.operator.OperatorHelper;
import ai.digital.integration.server.common.constant.ProductName;
import ai.digital.integration.server.common.util.GitUtil;
import ai.digital.integration.server.release.internals.ReleaseExtensionUtil;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J\b\u0010\n\u001a\u00020\u0004H\u0007\u00a8\u0006\f"}, d2={"Lai/digital/integration/server/release/tasks/cluster/operator/ProvideReleaseKubernetesOperatorTask;", "Lorg/gradle/api/DefaultTask;", "()V", "cloneRepository", "", "branch", "", "copyCurrentRepository", "operatorHelper", "Lai/digital/integration/server/common/cluster/operator/OperatorHelper;", "launch", "Companion", "integration-server-gradle-plugin"})
public class ProvideReleaseKubernetesOperatorTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "provideReleaseKubernetesOperator";

    public ProvideReleaseKubernetesOperatorTask() {
        this.getProject().afterEvaluate(new Action(){

            public final void execute(Project $this$afterEvaluate) {
                Intrinsics.checkNotNullParameter((Object)$this$afterEvaluate, (String)"$this$afterEvaluate");
                Project project = $this$afterEvaluate.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                if (ReleaseExtensionUtil.Companion.getExtension(project).getClusterProfiles().operator().getActiveProviderName().isPresent()) {
                    Project project2 = $this$afterEvaluate.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
                    OperatorHelper operatorHelper = OperatorHelper.Companion.getOperatorHelper(project2, ProductName.RELEASE);
                    if (operatorHelper.getProvider().getOperatorPackageVersion().isPresent()) {
                        $this$afterEvaluate.getProject().getBuildscript().getDependencies().add("operatorDist", (Object)("ai.digital.release.operator:" + operatorHelper.getProviderHomePath() + ":" + operatorHelper.getProvider().getOperatorPackageVersion().get() + "@zip"));
                        String taskName = "downloadAndExtractOperator" + operatorHelper.getProviderHomePath();
                        TaskProvider taskProvider = $this$afterEvaluate.getProject().getTasks().register(taskName, Copy.class, new Action(operatorHelper){
                            final /* synthetic */ OperatorHelper $operatorHelper;
                            {
                                this.$operatorHelper = $operatorHelper;
                            }

                            public final void execute(Copy $this$register) {
                                Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$this$register");
                                Object[] objectArray = new Object[]{$this$register.getProject().zipTree((Object)$this$register.getProject().getBuildscript().getConfigurations().getByName("operatorDist").getSingleFile())};
                                $this$register.from(objectArray);
                                $this$register.into((Object)this.$operatorHelper.getProviderHomeDir());
                            }
                        });
                        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"operatorHelper = Operato\u2026())\n                    }");
                        TaskProvider task2 = taskProvider;
                        Object[] objectArray = new Object[]{task2};
                        this.dependsOn(objectArray);
                    }
                } else {
                    $this$afterEvaluate.getProject().getLogger().warn("Active provider name is not set - ProvideReleaseKubernetesOperatorTask");
                }
            }
        });
    }

    @TaskAction
    public final void launch() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        OperatorHelper operatorHelper = OperatorHelper.Companion.getOperatorHelper(project, ProductName.RELEASE);
        if (operatorHelper.getProvider().getOperatorBranch().isPresent()) {
            Object object = operatorHelper.getProvider().getOperatorBranch().getOrElse((Object)"master");
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"operatorHelper.getProvid\u2026ranch.getOrElse(\"master\")");
            String branch = (String)object;
            this.getProject().getLogger().lifecycle("Checking out xl-release-kubernetes-operator branch " + branch);
            this.cloneRepository(branch);
        } else if (operatorHelper.getProvider().getOperatorPackageVersion().isPresent()) {
            Object object = operatorHelper.getProvider().getOperatorPackageVersion().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"operatorHelper.getProvid\u2026ratorPackageVersion.get()");
            String version = (String)object;
            this.getProject().getLogger().lifecycle("Downloading package xl-release-kubernetes-operator version " + version);
        } else {
            this.getProject().getLogger().lifecycle("Using current repository as operator source");
            this.copyCurrentRepository(operatorHelper);
        }
    }

    private final void cloneRepository(String branch) {
        Path path = ((Directory)this.getProject().getLayout().getBuildDirectory().get()).getAsFile().toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"project.layout.buildDire\u2026ory.get().asFile.toPath()");
        GitUtil.Companion.checkout("xl-release-kubernetes-operator", path, branch);
    }

    private final void copyCurrentRepository(OperatorHelper operatorHelper) {
        String providerHomePath = operatorHelper.getProviderHomePath();
        File file = this.getProject().getRootDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.rootDir");
        FilesKt.copyRecursively$default((File)FilesKt.resolve((File)file, (String)providerHomePath), (File)new File(operatorHelper.getProviderHomeDir()), (boolean)true, null, (int)4, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/digital/integration/server/release/tasks/cluster/operator/ProvideReleaseKubernetesOperatorTask$Companion;", "", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

