/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks.server.docker;

import ai.digital.integration.server.common.constant.ProductName;
import ai.digital.integration.server.common.domain.Server;
import ai.digital.integration.server.common.util.DockerComposeUtil;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\b\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\n"}, d2={"Lai/digital/integration/server/deploy/tasks/server/docker/DockerBasedStopDeployTask;", "Lorg/gradle/api/DefaultTask;", "()V", "getDockerComposeFile", "Ljava/io/File;", "server", "Lai/digital/integration/server/common/domain/Server;", "run", "", "Companion", "integration-server-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nDockerBasedStopDeployTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerBasedStopDeployTask.kt\nai/digital/integration/server/deploy/tasks/server/docker/DockerBasedStopDeployTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,46:1\n1863#2,2:47\n*S KotlinDebug\n*F\n+ 1 DockerBasedStopDeployTask.kt\nai/digital/integration/server/deploy/tasks/server/docker/DockerBasedStopDeployTask\n*L\n34#1:47,2\n*E\n"})
public class DockerBasedStopDeployTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "dockerBasedStopDeploy";

    public DockerBasedStopDeployTask() {
        Object[] objectArray = new Object[]{"prepareDeploy"};
        this.dependsOn(objectArray);
        this.setGroup("Integration Server");
        this.onlyIf(new Spec(){

            public final boolean isSatisfiedBy(Task it) {
                Project project = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                return DeployServerUtil.Companion.isDockerBased(project);
            }
        });
    }

    @InputFiles
    @NotNull
    public final File getDockerComposeFile(@NotNull Server server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        File file = DeployServerUtil.Companion.getResolvedDockerFile(project, server).toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"DeployServerUtil.getReso\u2026project, server).toFile()");
        return file;
    }

    @TaskAction
    public final void run() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        Iterable $this$forEach$iv = DeployServerUtil.Companion.getServers(project);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Server server = (Server)element$iv;
            boolean bl = false;
            this.getProject().getLogger().lifecycle("Stopping Deploy Server from a docker image " + DeployServerUtil.Companion.getDockerImageVersion(server));
            Project project2 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
            DockerComposeUtil.Companion.allowToCleanMountedFiles(project2, ProductName.DEPLOY, server, this.getDockerComposeFile(server));
            this.getProject().exec(new Action(this, server){
                final /* synthetic */ DockerBasedStopDeployTask this$0;
                final /* synthetic */ Server $server;
                {
                    this.this$0 = $receiver;
                    this.$server = $server;
                }

                public final void execute(ExecSpec $this$exec) {
                    Intrinsics.checkNotNullParameter((Object)$this$exec, (String)"$this$exec");
                    $this$exec.setExecutable("docker-compose");
                    Object[] objectArray = new String[]{"-f", this.this$0.getDockerComposeFile(this.$server).getPath(), "down", "-v"};
                    $this$exec.setArgs((List)CollectionsKt.arrayListOf((Object[])objectArray));
                }
            });
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/digital/integration/server/deploy/tasks/server/docker/DockerBasedStopDeployTask$Companion;", "", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

