/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.internals;

import ai.digital.integration.server.common.constant.ProductName;
import ai.digital.integration.server.common.domain.Cluster;
import ai.digital.integration.server.common.domain.Server;
import ai.digital.integration.server.common.util.DockerComposeUtil;
import ai.digital.integration.server.common.util.DockerUtil;
import ai.digital.integration.server.common.util.FileUtil;
import ai.digital.integration.server.common.util.IntegrationServerUtil;
import ai.digital.integration.server.common.util.JavaUtil;
import ai.digital.integration.server.common.util.PropertiesUtil;
import ai.digital.integration.server.common.util.PropertyUtil;
import ai.digital.integration.server.common.util.WaitForBootUtil;
import ai.digital.integration.server.deploy.internals.DeployExtensionUtil;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import ai.digital.integration.server.deploy.internals.EntryPointUrlUtil;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.specs.Spec;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lai/digital/integration/server/deploy/internals/DeployServerUtil;", "", "()V", "Companion", "integration-server-gradle-plugin"})
public final class DeployServerUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\f\u001a\u00020\u0004H\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u0006J\u001f\u0010\u0014\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010\u0015J%\u0010\u0016\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u0018J\u000e\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u000eJ\u000e\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u000eJ\u0018\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u000e\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000eJ\u0010\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u001f\u001a\u00020 2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000eJ\u000e\u0010!\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\"\u001a\u00020 2\u0006\u0010\u0005\u001a\u00020\u0006J\u001a\u0010#\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u000e\u0010$\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010$\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000eJ\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000e0&2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010'\u001a\u00020(2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010)\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010*\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010+\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000eJ\u000e\u0010,\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u000eJ\u000e\u0010,\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010-\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010.\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010/\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u00100\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u00101\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u00102\u001a\u00020\u0004J\u0016\u00103\u001a\u00020(2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000eJ&\u00104\u001a\u00020(2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u00105\u001a\u00020\u00042\u0006\u00106\u001a\u000207J\u000e\u00108\u001a\u0002092\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010:\u001a\u00020(2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000eJ*\u0010;\u001a\u00020(2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010<\u001a\u0004\u0018\u0001092\u0006\u0010\u000f\u001a\u00020\u000e2\b\b\u0002\u0010=\u001a\u00020\tJ\u001c\u0010>\u001a\u00020\u00132\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00040&2\u0006\u0010@\u001a\u00020\u0004\u00a8\u0006A"}, d2={"Lai/digital/integration/server/deploy/internals/DeployServerUtil$Companion;", "", "()V", "clusterMode", "", "project", "Lorg/gradle/api/Project;", "createDebugString", "debugSuspend", "", "debugPort", "", "dockerServerRelativePath", "enrichServer", "Lai/digital/integration/server/common/domain/Server;", "server", "getCluster", "Lai/digital/integration/server/common/domain/Cluster;", "getConfDir", "Ljava/io/File;", "getDebugPort", "(Lorg/gradle/api/Project;Lai/digital/integration/server/common/domain/Server;)Ljava/lang/Integer;", "getDockerContainerPort", "privatePort", "(Lorg/gradle/api/Project;Lai/digital/integration/server/common/domain/Server;I)Ljava/lang/Integer;", "getDockerImageVersion", "getDockerServiceName", "getHttpPort", "getLogDir", "getOldDockerServerPath", "getPreviousInstallationServer", "getResolvedDockerFile", "Ljava/nio/file/Path;", "getServer", "getServerDistFolderPath", "getServerVersion", "getServerWorkingDir", "getServers", "", "grantPermissionsToIntegrationServerFolder", "", "isClusterEnabled", "isDeployServerDefined", "isDistDownloadRequired", "isDockerBased", "isNoLicense", "isPekkoSecured", "isPreviousInstallationServerDefined", "isTls", "readDeployitConfProperty", "key", "runDockerBasedInstance", "saveServerLogsToFile", "containerName", "lastUpdate", "Ljava/time/LocalDateTime;", "startServerFromClasspath", "Ljava/lang/Process;", "stopDockerContainer", "waitForBoot", "process", "auxiliaryServer", "writeArgsToFile", "args", "prefix", "integration-server-gradle-plugin"})
    @SourceDebugExtension(value={"SMAP\nDeployServerUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeployServerUtil.kt\nai/digital/integration/server/deploy/internals/DeployServerUtil$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,362:1\n230#2,2:363\n1557#2:365\n1628#2,3:366\n230#2,2:369\n230#2,2:374\n1#3:371\n1317#4,2:372\n*S KotlinDebug\n*F\n+ 1 DeployServerUtil.kt\nai/digital/integration/server/deploy/internals/DeployServerUtil$Companion\n*L\n33#1:363,2\n39#1:365\n39#1:366,3\n45#1:369,2\n289#1:374,2\n184#1:372,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isTls(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return this.getServer(project).getTls();
        }

        public final boolean isPekkoSecured(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return this.getServer(project).getPekkoSecured();
        }

        private final boolean isNoLicense(Project project) {
            return this.getServer(project).getNoLicense();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Server getServer(@NotNull Project project) {
            Object t;
            Object element$iv2;
            Companion companion;
            Project project2;
            block1: {
                void $this$first$iv;
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Iterable iterable = (Iterable)DeployExtensionUtil.Companion.getExtension(project).getServers();
                project2 = project;
                companion = this;
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    Server server = (Server)element$iv2;
                    boolean bl = false;
                    if (!(!server.getPreviousInstallation())) continue;
                    break block1;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            Object t2 = t = element$iv2;
            Intrinsics.checkNotNullExpressionValue(t2, (String)"DeployExtensionUtil.getE\u2026llation\n                }");
            return companion.enrichServer(project2, (Server)t2);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Server> getServers(@NotNull Project project) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Iterable $this$map$iv = (Iterable)DeployExtensionUtil.Companion.getExtension(project).getServers();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void server;
                Server server2 = (Server)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Companion.enrichServer(project, (Server)server));
            }
            return (List)destination$iv$iv;
        }

        @NotNull
        public final Server getPreviousInstallationServer(@NotNull Project project) {
            Object element$iv2;
            block1: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Iterable $this$first$iv = (Iterable)DeployExtensionUtil.Companion.getExtension(project).getServers();
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    Server server = (Server)element$iv2;
                    boolean bl = false;
                    if (!server.getPreviousInstallation()) continue;
                    break block1;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            Object t = element$iv2;
            Intrinsics.checkNotNullExpressionValue(t, (String)"DeployExtensionUtil.getE\u2026er.previousInstallation }");
            return (Server)t;
        }

        public final boolean isPreviousInstallationServerDefined(@NotNull Project project) {
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Iterable iterable = (Iterable)DeployExtensionUtil.Companion.getExtension(project).getServers();
                for (Object t : iterable) {
                    Server server = (Server)t;
                    boolean bl = false;
                    if (!server.getPreviousInstallation()) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            return v0 != null;
        }

        private final Server enrichServer(Project project, Server server) {
            server.setDebugPort(this.getDebugPort(project, server));
            server.setHttpPort(this.getHttpPort(project, server));
            server.setVersion(this.getServerVersion(project, server));
            if (this.isPreviousInstallationServerDefined(project)) {
                server.setHttpPort(this.getPreviousInstallationServer(project).getHttpPort());
            }
            String string = server.getDockerImage();
            if (string != null) {
                String it = string;
                boolean bl = false;
                server.setRuntimeDirectory(null);
            }
            if (!StringsKt.startsWith$default((String)server.getContextRoot(), (String)"/", (boolean)false, (int)2, null)) {
                server.setContextRoot("/" + server + ".contextRoot");
            }
            return server;
        }

        @NotNull
        public final String getServerWorkingDir(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return this.getServerWorkingDir(project, this.getServer(project));
        }

        @NotNull
        public final String getServerWorkingDir(@NotNull Project project, @NotNull Server server) {
            String string;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            if (this.isDockerBased(server)) {
                Path workDir = IntegrationServerUtil.Companion.getRelativePathInIntegrationServerDist(project, "deploy-" + server.getVersion());
                string = ((Object)workDir.toAbsolutePath()).toString();
            } else if (server.getRuntimeDirectory() == null) {
                String targetDir = ((Object)this.getServerDistFolderPath(project)).toString();
                String[] stringArray = new String[]{"xl-deploy-" + server.getVersion() + "-server"};
                string = ((Object)Paths.get(targetDir, stringArray).toAbsolutePath()).toString();
            } else {
                String string2 = project.getProjectDir().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"project.projectDir.toString()");
                String target = string2;
                String[] stringArray = new String[]{server.getRuntimeDirectory()};
                string = ((Object)Paths.get(target, stringArray).toAbsolutePath()).toString();
            }
            return string;
        }

        @NotNull
        public final Path getServerDistFolderPath(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Path path = Paths.get(IntegrationServerUtil.Companion.getDist(project), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(IntegrationServerUtil.getDist(project))");
            return path;
        }

        public final boolean isDockerBased(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return this.isDockerBased(this.getServer(project));
        }

        public final boolean isDockerBased(@NotNull Server server) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            CharSequence charSequence = server.getDockerImage();
            return !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence));
        }

        @NotNull
        public final Cluster getCluster(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = DeployExtensionUtil.Companion.getExtension(project).getCluster().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"DeployExtensionUtil.getE\u2026on(project).cluster.get()");
            return (Cluster)object;
        }

        public final boolean isClusterEnabled(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return this.getCluster(project).getEnable();
        }

        @NotNull
        public final String clusterMode(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            String mode = "default";
            if (project.hasProperty("clusterMode") && !Intrinsics.areEqual((Object)(mode = String.valueOf(project.property("clusterMode"))), (Object)"full") && !Intrinsics.areEqual((Object)mode, (Object)"hot-standby") && !Intrinsics.areEqual((Object)mode, (Object)"default")) {
                throw new GradleException("full, hot-standby, default are only valid for cluster mode property");
            }
            return mode;
        }

        private final String getServerVersion(Project project, Server server) {
            CharSequence charSequence = server.getVersion();
            if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                return server.getVersion();
            }
            return project.hasProperty("xlDeployVersion") ? String.valueOf(project.property("xlDeployVersion")) : server.getVersion();
        }

        private final int getHttpPort(Project project, Server server) {
            int n;
            if (project.hasProperty("serverHttpPort")) {
                Integer n2 = Integer.valueOf(String.valueOf(project.property("serverHttpPort")));
                Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"valueOf(project.property\u2026verHttpPort\").toString())");
                n = ((Number)n2).intValue();
            } else {
                n = server.getHttpPort();
            }
            return n;
        }

        private final Integer getDebugPort(Project project, Server server) {
            return PropertyUtil.Companion.resolveBooleanValue(project, "debug", true) ? PropertyUtil.Companion.resolveIntValue(project, "serverDebugPort", server.getDebugPort()) : null;
        }

        @NotNull
        public final String createDebugString(boolean debugSuspend, int debugPort) {
            String suspend = debugSuspend ? "y" : "n";
            return "-Xrunjdwp:transport=dt_socket,server=y,suspend=" + suspend + ",address=" + debugPort;
        }

        public final boolean isDeployServerDefined(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return DeployExtensionUtil.Companion.getExtension(project).getServers().size() > 0;
        }

        public final boolean isDistDownloadRequired(@NotNull Project project, @NotNull Server server) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            return server.getRuntimeDirectory() == null && !this.isDockerBased(project);
        }

        @NotNull
        public final String readDeployitConfProperty(@NotNull Project project, @NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            File deployitConf = Paths.get(this.getServerWorkingDir(project) + "/conf/deployit.conf", new String[0]).toFile();
            Intrinsics.checkNotNullExpressionValue((Object)deployitConf, (String)"deployitConf");
            return PropertiesUtil.Companion.readProperty(deployitConf, key);
        }

        @NotNull
        public final File getLogDir(@NotNull Project project, @NotNull Server server) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            String[] stringArray = new String[]{"log"};
            File logDir = Paths.get(this.getServerWorkingDir(project, server), stringArray).toFile();
            logDir.mkdirs();
            Intrinsics.checkNotNullExpressionValue((Object)logDir, (String)"logDir");
            return logDir;
        }

        @NotNull
        public final File getLogDir(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Server server = this.getServer(project);
            return this.getLogDir(project, server);
        }

        @NotNull
        public final File getConfDir(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Server server = this.getServer(project);
            String[] stringArray = new String[]{"conf"};
            File file = Paths.get(this.getServerWorkingDir(project, server), stringArray).toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"get(getServerWorkingDir(\u2026server), \"conf\").toFile()");
            return file;
        }

        public final void grantPermissionsToIntegrationServerFolder(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (this.isDockerBased(project)) {
                String workDir = IntegrationServerUtil.Companion.getDist(project);
                Sequence $this$forEach$iv = (Sequence)FilesKt.walk$default((File)new File(workDir), null, (int)1, null);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    File it = (File)element$iv;
                    boolean bl = false;
                    FileUtil.Companion.grantRWPermissions(it);
                }
            }
        }

        public final void waitForBoot(@NotNull Project project, @Nullable Process process, @NotNull Server server, boolean auxiliaryServer) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            boolean clusterEnabled = this.isClusterEnabled(project);
            String url = this.isNoLicense(project) ? new EntryPointUrlUtil(project, ProductName.DEPLOY, false, 4, null).composeUrl("/productregistration", auxiliaryServer) : new EntryPointUrlUtil(project, ProductName.DEPLOY, false, 4, null).composeUrl("/deployit/metadata/type", auxiliaryServer);
            LocalDateTime lastLogUpdate2 = WaitForBootUtil.Companion.byPort(project, "Deploy", url, process, server.getPingRetrySleepTime(), server.getPingTotalTries(), (Function1<? super LocalDateTime, LocalDateTime>)((Function1)new Function1<LocalDateTime, LocalDateTime>(server, clusterEnabled, project){
                final /* synthetic */ Server $server;
                final /* synthetic */ boolean $clusterEnabled;
                final /* synthetic */ Project $project;
                {
                    this.$server = $server;
                    this.$clusterEnabled = $clusterEnabled;
                    this.$project = $project;
                    super(1);
                }

                public final LocalDateTime invoke(LocalDateTime it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return ai.digital.integration.server.deploy.internals.DeployServerUtil$Companion.access$waitForBoot$saveLogs(this.$server, this.$clusterEnabled, this.$project, it);
                }
            }));
            ai.digital.integration.server.deploy.internals.DeployServerUtil$Companion.waitForBoot$saveLogs(server, clusterEnabled, project, lastLogUpdate2);
        }

        public static /* synthetic */ void waitForBoot$default(Companion companion, Project project, Process process, Server server, boolean bl, int n, Object object) {
            if ((n & 8) != 0) {
                bl = false;
            }
            companion.waitForBoot(project, process, server, bl);
        }

        public final void saveServerLogsToFile(@NotNull Project project, @NotNull Server server, @NotNull String containerName, @NotNull LocalDateTime lastUpdate) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            Intrinsics.checkNotNullParameter((Object)containerName, (String)"containerName");
            Intrinsics.checkNotNullParameter((Object)lastUpdate, (String)"lastUpdate");
            String logContent = DockerUtil.Companion.dockerLogs(project, containerName, lastUpdate);
            File logDir = this.getLogDir(project, server);
            File file = new File(logDir, containerName + ".log");
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            FilesKt.writeText((File)file, (String)logContent, (Charset)charset);
        }

        @NotNull
        public final File writeArgsToFile(@NotNull List<String> args, @NotNull String prefix) {
            Intrinsics.checkNotNullParameter(args, (String)"args");
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            File tempFile = File.createTempFile(prefix, ".args");
            Intrinsics.checkNotNullExpressionValue((Object)tempFile, (String)"tempFile");
            Iterable iterable = args;
            String string = System.lineSeparator();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lineSeparator()");
            FilesKt.writeText$default((File)tempFile, (String)CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, null, (int)62, null), null, (int)2, null);
            tempFile.deleteOnExit();
            return tempFile;
        }

        @NotNull
        public final Process startServerFromClasspath(@NotNull Project project) {
            String it;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            project.getLogger().lifecycle("startServerFromClasspath.");
            Server server = this.getServer(project);
            String string = project.getConfigurations().getByName("integrationTestServer").filter((Spec)startServerFromClasspath.classpath.1.INSTANCE).getAsPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.configurations.g\u2026}\n                .asPath");
            String classpath2 = string;
            project.getLogger().lifecycle("Launching Deploy Server from classpath " + classpath2 + ".");
            List jvmArgs = new ArrayList();
            jvmArgs.add("-classpath");
            jvmArgs.add(classpath2);
            CollectionsKt.addAll((Collection)jvmArgs, (Object[])server.getJvmArgs());
            Integer n = server.getDebugPort();
            if (n != null) {
                int it2 = ((Number)n).intValue();
                boolean bl = false;
                jvmArgs.addAll((Collection)JavaUtil.Companion.debugJvmArg(project, it2, server.getDebugSuspend()));
            }
            File jvmArgsFile = this.writeArgsToFile(jvmArgs, "jvmArgs");
            Pair[] it2 = new Pair[]{TuplesKt.to((Object)"discardIO", (Object)(server.getStdoutFileName() == null ? 1 : 0)), TuplesKt.to((Object)"jvmArgs", (Object)CollectionsKt.listOf((Object)("@" + jvmArgsFile.getAbsolutePath()))), TuplesKt.to((Object)"mainClass", (Object)"com.xebialabs.deployit.DeployitBootstrapper"), TuplesKt.to((Object)"programArgs", (Object)CollectionsKt.listOf((Object)"-force-upgrades")), TuplesKt.to((Object)"workDir", (Object)new File(this.getServerWorkingDir(project)))};
            Map config = MapsKt.mutableMapOf((Pair[])it2);
            String string2 = server.getStdoutFileName();
            if (string2 != null) {
                it = string2;
                boolean bl = false;
                config.put("redirectTo", new File(Companion.getLogDir(project, server) + "/" + it));
            }
            Object v = project.getProperties().get("integrationServerJVMPath");
            if (v != null) {
                it = v;
                boolean bl = false;
                config.putAll(JavaUtil.Companion.jvmPath(project, it));
            }
            project.getLogger().lifecycle("Starting integration test server on port " + server.getHttpPort() + " from runtime dir " + server.getRuntimeDirectory());
            Process process = JavaUtil.Companion.execJava(config);
            project.getLogger().lifecycle("Launched server on PID [" + process.pid() + "] with command [" + process.info().commandLine().orElse("") + "].");
            return process;
        }

        @NotNull
        public final String getDockerImageVersion(@NotNull Server server) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            return server.getDockerImage() + ":" + server.getVersion();
        }

        @NotNull
        public final String getDockerServiceName(@NotNull Server server) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            return "deploy-" + server.getVersion();
        }

        private final String getOldDockerServerPath(Project project) {
            if (this.isPreviousInstallationServerDefined(project)) {
                Object element$iv2;
                String rootPath;
                block2: {
                    rootPath = IntegrationServerUtil.Companion.getDist(project);
                    Iterable $this$first$iv = (Iterable)DeployExtensionUtil.Companion.getExtension(project).getServers();
                    boolean $i$f$first = false;
                    for (Object element$iv2 : $this$first$iv) {
                        Server oldServer = (Server)element$iv2;
                        boolean bl = false;
                        if (!oldServer.getPreviousInstallation()) continue;
                        break block2;
                    }
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                Server oldDockerServer = (Server)element$iv2;
                return rootPath + "/deploy-" + oldDockerServer.getVersion();
            }
            return ".";
        }

        @NotNull
        public final Path getResolvedDockerFile(@NotNull Project project, @NotNull Server server) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            InputStream dockerComposeStream2 = ((Object)((Object)getResolvedDockerFile.dockerComposeStream.1.INSTANCE)).getClass().getClassLoader().getResourceAsStream(this.dockerServerRelativePath());
            String newPath = "deploy-" + server.getVersion() + "/server-docker-compose.yaml";
            Path destinationPath = IntegrationServerUtil.Companion.getRelativePathInIntegrationServerDist(project, newPath);
            InputStream inputStream = dockerComposeStream2;
            if (inputStream != null) {
                InputStream it = inputStream;
                boolean bl = false;
                FileUtil.Companion.copyFile(it, destinationPath);
            }
            Path resultComposeFilePath = DockerComposeUtil.Companion.getResolvedDockerPath(project, newPath);
            File serverTemplate = resultComposeFilePath.toFile();
            boolean forceUpgrade = this.isPreviousInstallationServerDefined(project) && !server.getPreviousInstallation();
            Intrinsics.checkNotNullExpressionValue((Object)serverTemplate, (String)"serverTemplate");
            String configuredTemplate = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)FilesKt.readText((File)serverTemplate, (Charset)Charsets.UTF_8), (String)"{{DEPLOY_SERVER_HTTP_PORT}}", (String)String.valueOf(server.getHttpPort()), (boolean)false, (int)4, null), (String)"{{DEPLOY_IMAGE_VERSION}}", (String)this.getDockerImageVersion(server), (boolean)false, (int)4, null), (String)"{{DEPLOY_PLUGINS_TO_EXCLUDE}}", (String)CollectionsKt.joinToString$default((Iterable)server.getDefaultOfficialPluginsToExclude(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null), (boolean)false, (int)4, null), (String)"{{DEPLOY_VERSION}}", (String)String.valueOf(server.getVersion()), (boolean)false, (int)4, null), (String)"{{DEPLOY_FORCE_UPGRADE}}", (String)String.valueOf(forceUpgrade), (boolean)false, (int)4, null), (String)"{{INTEGRATION_SERVER_ROOT_VOLUME}}", (String)this.getOldDockerServerPath(project), (boolean)false, (int)4, null);
            FilesKt.writeText$default((File)serverTemplate, (String)configuredTemplate, null, (int)2, null);
            return resultComposeFilePath;
        }

        private final String dockerServerRelativePath() {
            return "deploy/server-docker-compose.yaml";
        }

        public final void runDockerBasedInstance(@NotNull Project project, @NotNull Server server) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            project.exec(new Action(project, server){
                final /* synthetic */ Project $project;
                final /* synthetic */ Server $server;
                {
                    this.$project = $project;
                    this.$server = $server;
                }

                public final void execute(ExecSpec $this$exec) {
                    Intrinsics.checkNotNullParameter((Object)$this$exec, (String)"$this$exec");
                    $this$exec.setExecutable("docker-compose");
                    Object[] objectArray = new String[4];
                    objectArray[0] = "-f";
                    Intrinsics.checkNotNullExpressionValue((Object)DeployServerUtil.Companion.getResolvedDockerFile(this.$project, this.$server).toFile().toString(), (String)"getResolvedDockerFile(pr\u2026rver).toFile().toString()");
                    objectArray[2] = "up";
                    objectArray[3] = "-d";
                    $this$exec.setArgs(CollectionsKt.listOf((Object[])objectArray));
                }
            });
        }

        public final void stopDockerContainer(@NotNull Project project, @NotNull Server server) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            project.getLogger().lifecycle("Trying to stop " + server.getVersion() + " container");
            project.exec(new Action(project, server){
                final /* synthetic */ Project $project;
                final /* synthetic */ Server $server;
                {
                    this.$project = $project;
                    this.$server = $server;
                }

                public final void execute(ExecSpec $this$exec) {
                    Intrinsics.checkNotNullParameter((Object)$this$exec, (String)"$this$exec");
                    $this$exec.setExecutable("docker-compose");
                    Object[] objectArray = new String[]{"-f", DeployServerUtil.Companion.getResolvedDockerFile(this.$project, this.$server).toFile().getPath(), "stop"};
                    $this$exec.setArgs((List)CollectionsKt.arrayListOf((Object[])objectArray));
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final Integer getDockerContainerPort(@NotNull Project project, @NotNull Server server, int privatePort) {
            Integer n;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            Closeable closeable = new ByteArrayOutputStream();
            Throwable throwable = null;
            try {
                Integer n2;
                ByteArrayOutputStream it = (ByteArrayOutputStream)closeable;
                boolean bl = false;
                project.exec(new Action(project, server, privatePort, it){
                    final /* synthetic */ Project $project;
                    final /* synthetic */ Server $server;
                    final /* synthetic */ int $privatePort;
                    final /* synthetic */ ByteArrayOutputStream $it;
                    {
                        this.$project = $project;
                        this.$server = $server;
                        this.$privatePort = $privatePort;
                        this.$it = $it;
                    }

                    public final void execute(ExecSpec $this$exec) {
                        Intrinsics.checkNotNullParameter((Object)$this$exec, (String)"$this$exec");
                        $this$exec.setExecutable("docker-compose");
                        Object[] objectArray = new String[5];
                        objectArray[0] = "-f";
                        Intrinsics.checkNotNullExpressionValue((Object)DeployServerUtil.Companion.getResolvedDockerFile(this.$project, this.$server).toFile().toString(), (String)"getResolvedDockerFile(pr\u2026rver).toFile().toString()");
                        objectArray[2] = "port";
                        objectArray[3] = "deploy-" + this.$server.getVersion();
                        objectArray[4] = String.valueOf(this.$privatePort);
                        $this$exec.setArgs((List)CollectionsKt.arrayListOf((Object[])objectArray));
                        $this$exec.setStandardOutput((OutputStream)this.$it);
                        $this$exec.setErrorOutput((OutputStream)this.$it);
                        $this$exec.setIgnoreExitValue(true);
                    }
                });
                String hostAndPort = it.toString(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)hostAndPort, (String)"hostAndPort");
                String string = hostAndPort.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                if (StringsKt.contains$default((CharSequence)string, (CharSequence)"no container found", (boolean)false, (int)2, null)) {
                    n2 = null;
                } else {
                    char[] cArray = new char[]{':'};
                    n2 = Integer.parseInt(((Object)StringsKt.trim((CharSequence)((String)StringsKt.split$default((CharSequence)hostAndPort, (char[])cArray, (boolean)false, (int)0, (int)6, null).get(1)))).toString());
                }
                n = n2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return n;
        }

        private static final LocalDateTime waitForBoot$saveLogs(Server $server, boolean clusterEnabled, Project $project, LocalDateTime lastUpdate) {
            if (Companion.isDockerBased($server) || clusterEnabled) {
                Companion.saveServerLogsToFile($project, $server, "deploy-" + $server.getVersion(), lastUpdate);
            }
            LocalDateTime localDateTime = LocalDateTime.now();
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"now()");
            return localDateTime;
        }

        public static final /* synthetic */ LocalDateTime access$waitForBoot$saveLogs(Server $server, boolean clusterEnabled, Project $project, LocalDateTime lastUpdate) {
            return ai.digital.integration.server.deploy.internals.DeployServerUtil$Companion.waitForBoot$saveLogs($server, clusterEnabled, $project, lastUpdate);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

