/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks.centralConfiguration;

import ai.digital.integration.server.common.util.YamlFileUtil;
import ai.digital.integration.server.deploy.domain.CentralConfigurationServer;
import ai.digital.integration.server.deploy.internals.CentralConfigurationServerUtil;
import java.io.File;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00052\u00020\u0001:\u0001\u0005B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0006"}, d2={"Lai/digital/integration/server/deploy/tasks/centralConfiguration/CentralConfigurationServerYamlPatchTask;", "Lorg/gradle/api/DefaultTask;", "()V", "yamlPatches", "", "Companion", "integration-server-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nCentralConfigurationServerYamlPatchTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CentralConfigurationServerYamlPatchTask.kt\nai/digital/integration/server/deploy/tasks/centralConfiguration/CentralConfigurationServerYamlPatchTask\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,35:1\n216#2,2:36\n*S KotlinDebug\n*F\n+ 1 CentralConfigurationServerYamlPatchTask.kt\nai/digital/integration/server/deploy/tasks/centralConfiguration/CentralConfigurationServerYamlPatchTask\n*L\n30#1:36,2\n*E\n"})
public class CentralConfigurationServerYamlPatchTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "centralConfigurationServerYamlPatch";

    public CentralConfigurationServerYamlPatchTask() {
        this.setGroup("Integration Server");
        this.onlyIf(new Spec(){

            public final boolean isSatisfiedBy(Task it) {
                Project project = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                return CentralConfigurationServerUtil.Companion.hasCentralConfigurationServer(project);
            }
        });
        Object[] objectArray = new Object[]{"prepareCentralConfigurationServer"};
        this.mustRunAfter(objectArray);
        objectArray = new Object[]{"centralConfigurationServerOverlays"};
        this.mustRunAfter(objectArray);
    }

    @TaskAction
    public final void yamlPatches() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        CentralConfigurationServer server = CentralConfigurationServerUtil.Companion.getCentralConfigurationServer(project);
        this.getProject().getLogger().lifecycle("Applying patches on YAML files for " + server.getName() + ".");
        Map<String, Map<String, Object>> $this$forEach$iv = server.getYamlPatches();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, Map<String, Object>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Map<String, Object>> element$iv;
            Map.Entry<String, Map<String, Object>> yamlPatch = element$iv = iterator.next();
            boolean bl = false;
            Project project2 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
            File file = new File(CentralConfigurationServerUtil.Companion.getServerPath(project2, server) + "/" + yamlPatch.getKey());
            YamlFileUtil.Companion.overlayFileWithJackson$default(YamlFileUtil.Companion, file, MapsKt.toMutableMap(yamlPatch.getValue()), null, false, 12, null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/digital/integration/server/deploy/tasks/centralConfiguration/CentralConfigurationServerYamlPatchTask$Companion;", "", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

