/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.cluster.util;

import ai.digital.integration.server.common.constant.ProductName;
import ai.digital.integration.server.common.domain.Server;
import ai.digital.integration.server.common.util.FileUtil;
import ai.digital.integration.server.common.util.IntegrationServerUtil;
import ai.digital.integration.server.common.util.PropertiesUtil;
import ai.digital.integration.server.common.util.WaitForBootUtil;
import ai.digital.integration.server.deploy.internals.DeployExtensionUtil;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import ai.digital.integration.server.deploy.internals.EntryPointUrlUtil;
import ai.digital.integration.server.release.internals.ReleaseExtensionUtil;
import ai.digital.integration.server.release.util.ReleaseServerUtil;
import java.io.File;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.Locale;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000b\u001a\u00020\fJ\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0012J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015J\u000e\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0019"}, d2={"Lai/digital/integration/server/common/cluster/util/OperatorUtil;", "", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "productName", "Lai/digital/integration/server/common/constant/ProductName;", "getProductName", "()Lai/digital/integration/server/common/constant/ProductName;", "getProject", "()Lorg/gradle/api/Project;", "getOperatorServer", "Lai/digital/integration/server/common/domain/Server;", "getServers", "Lorg/gradle/api/NamedDomainObjectContainer;", "grantPermissionsToIntegrationServerFolder", "", "isClusterEnabled", "", "isDockerBased", "readConfProperty", "", "key", "waitForBoot", "server", "integration-server-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nOperatorUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OperatorUtil.kt\nai/digital/integration/server/common/cluster/util/OperatorUtil\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,111:1\n1317#2,2:112\n230#3,2:114\n*S KotlinDebug\n*F\n+ 1 OperatorUtil.kt\nai/digital/integration/server/common/cluster/util/OperatorUtil\n*L\n79#1:112,2\n52#1:114,2\n*E\n"})
public final class OperatorUtil {
    @NotNull
    private final Project project;
    @NotNull
    private final ProductName productName;

    public OperatorUtil(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.productName = DeployExtensionUtil.Companion.getExtension(this.project).getServers().size() > 0 ? ProductName.DEPLOY : ProductName.RELEASE;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final ProductName getProductName() {
        return this.productName;
    }

    public final boolean isClusterEnabled() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.productName.ordinal()]) {
            case 1 -> DeployServerUtil.Companion.isClusterEnabled(this.project);
            case 2 -> ReleaseServerUtil.Companion.isClusterEnabled(this.project);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public final NamedDomainObjectContainer<Server> getServers() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.productName.ordinal()]) {
            case 1 -> DeployExtensionUtil.Companion.getExtension(this.project).getServers();
            case 2 -> ReleaseExtensionUtil.Companion.getExtension(this.project).getServers();
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public final Server getOperatorServer() {
        Server operatorServer;
        block11: {
            Integer httpPort;
            NamedDomainObjectContainer<Server> servers = switch (WhenMappings.$EnumSwitchMapping$0[this.productName.ordinal()]) {
                case 1 -> DeployExtensionUtil.Companion.getExtension(this.project).getServers();
                case 2 -> ReleaseExtensionUtil.Companion.getExtension(this.project).getServers();
                default -> throw new NoWhenBranchMatchedException();
            };
            Object object = (switch (WhenMappings.$EnumSwitchMapping$0[this.productName.ordinal()]) {
                case 1 -> DeployExtensionUtil.Companion.getExtension(this.project).getOperatorServer();
                case 2 -> ReleaseExtensionUtil.Companion.getExtension(this.project).getOperatorServer();
                default -> throw new NoWhenBranchMatchedException();
            }).get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"when (productName) {\n   \u2026torServer\n        }.get()");
            Server opServerConfig = (Server)object;
            Server server = OperatorUtil.getOperatorServer$findServer(servers);
            operatorServer = new Server("operatorServer");
            String string = opServerConfig.getVersion();
            if (string == null) {
                string = server.getVersion();
            }
            operatorServer.setVersion(string);
            operatorServer.setHttpPort(opServerConfig.getHttpPort());
            String string2 = opServerConfig.getDockerImage();
            if (string2 == null) {
                string2 = server.getDockerImage();
            }
            operatorServer.setDockerImage(string2);
            operatorServer.setPingRetrySleepTime(opServerConfig.getPingRetrySleepTime());
            operatorServer.setPingTotalTries(opServerConfig.getPingTotalTries());
            operatorServer.setRuntimeDirectory(null);
            if (!DeployServerUtil.Companion.getResolvedDockerFile(this.project, operatorServer).toFile().isFile()) break block11;
            Integer n = httpPort = DeployServerUtil.Companion.getDockerContainerPort(this.project, operatorServer, 4516);
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl = false;
                operatorServer.setHttpPort(httpPort);
            }
        }
        return operatorServer;
    }

    public final void grantPermissionsToIntegrationServerFolder() {
        String workDir = IntegrationServerUtil.Companion.getDist(this.project);
        Sequence $this$forEach$iv = (Sequence)FilesKt.walk$default((File)new File(workDir), null, (int)1, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            FileUtil.Companion.grantRWPermissions(it);
        }
    }

    public final boolean isDockerBased() {
        return !DeployServerUtil.Companion.isDockerBased(this.getOperatorServer());
    }

    public final void waitForBoot(@NotNull Server server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        String url = new EntryPointUrlUtil(this.project, ProductName.DEPLOY, true).composeUrl("/deployit/metadata/type", true);
        LocalDateTime lastLogUpdate2 = WaitForBootUtil.Companion.byPort(this.project, "Deploy", url, null, server.getPingRetrySleepTime(), server.getPingTotalTries(), (Function1<? super LocalDateTime, LocalDateTime>)((Function1)new Function1<LocalDateTime, LocalDateTime>(this, server){
            final /* synthetic */ OperatorUtil this$0;
            final /* synthetic */ Server $server;
            {
                this.this$0 = $receiver;
                this.$server = $server;
                super(1);
            }

            public final LocalDateTime invoke(LocalDateTime it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return OperatorUtil.access$waitForBoot$saveLogs(this.this$0, this.$server, it);
            }
        }));
        OperatorUtil.waitForBoot$saveLogs(this, server, lastLogUpdate2);
    }

    @NotNull
    public final String readConfProperty(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String workdir = DeployServerUtil.Companion.getServerWorkingDir(this.project, this.getOperatorServer());
        File deployitConf = Paths.get(workdir + "/conf/deployit.conf", new String[0]).toFile();
        Intrinsics.checkNotNullExpressionValue((Object)deployitConf, (String)"deployitConf");
        return PropertiesUtil.Companion.readProperty(deployitConf, key);
    }

    private static final Server getOperatorServer$findServer(NamedDomainObjectContainer<Server> servers) {
        Object element$iv2;
        block1: {
            Iterable $this$first$iv = (Iterable)servers;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                Server server = (Server)element$iv2;
                boolean bl = false;
                if (!(!server.getPreviousInstallation())) continue;
                break block1;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        Object t = element$iv2;
        Intrinsics.checkNotNullExpressionValue(t, (String)"servers.first { server -\u2026nstallation\n            }");
        return (Server)t;
    }

    private static final LocalDateTime waitForBoot$saveLogs(OperatorUtil this$0, Server $server, LocalDateTime lastUpdate) {
        String string = ProductName.DEPLOY.toString().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String name = string;
        DeployServerUtil.Companion.saveServerLogsToFile(this$0.project, $server, name + "-" + $server.getVersion(), lastUpdate);
        LocalDateTime localDateTime = LocalDateTime.now();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"now()");
        return localDateTime;
    }

    public static final /* synthetic */ LocalDateTime access$waitForBoot$saveLogs(OperatorUtil this$0, Server $server, LocalDateTime lastUpdate) {
        return OperatorUtil.waitForBoot$saveLogs(this$0, $server, lastUpdate);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProductName.values().length];
            try {
                nArray[ProductName.DEPLOY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProductName.RELEASE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

