/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.util;

import ai.digital.integration.server.common.util.CacheParameters;
import ai.digital.integration.server.common.util.DockerComposeUtil;
import ai.digital.integration.server.common.util.FileUtil;
import ai.digital.integration.server.common.util.PropertyUtil;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import ai.digital.integration.server.deploy.internals.WorkerUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lai/digital/integration/server/common/util/CacheUtil;", "", "()V", "Companion", "integration-server-gradle-plugin"})
public final class CacheUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String DEFAULT_CACHE_PROVIDER = "infinispan";
    @NotNull
    private static final Map<String, String> cacheDependenciesVersions;
    @NotNull
    private static final CacheParameters infinispanCacheParameters;

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)DEFAULT_CACHE_PROVIDER, (Object)"14.0.17.Final")};
        cacheDependenciesVersions = MapsKt.mutableMapOf((Pair[])pairArray);
        infinispanCacheParameters = new CacheParameters("org.infinispan:infinispan-jcache-remote");
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\bJ\u0010\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u0004J\u0006\u0010\u000f\u001a\u00020\u0004J\u0006\u0010\u0010\u001a\u00020\u0004J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lai/digital/integration/server/common/util/CacheUtil$Companion;", "", "()V", "DEFAULT_CACHE_PROVIDER", "", "cacheDependenciesVersions", "", "infinispanCacheParameters", "Lai/digital/integration/server/common/util/CacheParameters;", "getBaseDirectory", "project", "Lorg/gradle/api/Project;", "getCacheDependency", "getCacheDependencyVersion", "name", "getCacheProviderName", "getComposeFileRelativePath", "getResolvedDockerFile", "Ljava/nio/file/Path;", "isCacheEnabled", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isCacheEnabled(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return PropertyUtil.Companion.resolveBooleanValue(project, "useCache", false) && (DeployServerUtil.Companion.getServers(project).size() > 1 || WorkerUtil.Companion.hasWorkers(project));
        }

        @NotNull
        public final String getBaseDirectory(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return FileUtil.Companion.toPathString(DeployServerUtil.Companion.getServerDistFolderPath(project), "cache");
        }

        @NotNull
        public final String getComposeFileRelativePath() {
            return "cache/docker-compose_infinispan.yaml";
        }

        @NotNull
        public final Path getResolvedDockerFile(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Path resultComposeFilePath = DockerComposeUtil.Companion.getResolvedDockerPath(project, this.getComposeFileRelativePath());
            File cacheTemplate = resultComposeFilePath.toFile();
            int port = 11222;
            Integer resolvedCachePort = PropertyUtil.Companion.resolveIntValue(project, "cachePort", port);
            Intrinsics.checkNotNullExpressionValue((Object)cacheTemplate, (String)"cacheTemplate");
            String configuredTemplate = StringsKt.replace$default((String)FilesKt.readText$default((File)cacheTemplate, null, (int)1, null), (String)"CACHE_PORT", (String)(resolvedCachePort + ":" + port), (boolean)false, (int)4, null);
            FilesKt.writeText$default((File)cacheTemplate, (String)configuredTemplate, null, (int)2, null);
            return resultComposeFilePath;
        }

        @NotNull
        public final CacheParameters getCacheDependency() {
            return infinispanCacheParameters;
        }

        @Nullable
        public final String getCacheDependencyVersion(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return (String)cacheDependenciesVersions.get(name);
        }

        @NotNull
        public final String getCacheProviderName() {
            return CacheUtil.DEFAULT_CACHE_PROVIDER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

