/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks.worker;

import ai.digital.integration.server.common.domain.Server;
import ai.digital.integration.server.common.domain.Tls;
import ai.digital.integration.server.common.util.JavaUtil;
import ai.digital.integration.server.common.util.ProcessUtil;
import ai.digital.integration.server.common.util.TlsUtil;
import ai.digital.integration.server.common.util.WaitForBootUtil;
import ai.digital.integration.server.deploy.domain.Worker;
import ai.digital.integration.server.deploy.internals.CentralConfigurationServerUtil;
import ai.digital.integration.server.deploy.internals.DeployExtensionUtil;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import ai.digital.integration.server.deploy.internals.EnvironmentUtil;
import ai.digital.integration.server.deploy.internals.WorkerUtil;
import ai.digital.integration.server.deploy.tasks.worker.StartWorkersTask;
import java.io.File;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u000eH\u0002\u00a8\u0006\u0013"}, d2={"Lai/digital/integration/server/deploy/tasks/worker/StartWorkersTask;", "Lorg/gradle/api/DefaultTask;", "()V", "getBinDir", "Ljava/io/File;", "worker", "Lai/digital/integration/server/deploy/domain/Worker;", "getLogDir", "launch", "", "logFileName", "", "workerName", "startWorker", "Ljava/lang/Process;", "startWorkerFromClasspath", "waitForBoot", "process", "Companion", "integration-server-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nStartWorkersTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StartWorkersTask.kt\nai/digital/integration/server/deploy/tasks/worker/StartWorkersTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,166:1\n1863#2,2:167\n*S KotlinDebug\n*F\n+ 1 StartWorkersTask.kt\nai/digital/integration/server/deploy/tasks/worker/StartWorkersTask\n*L\n150#1:167,2\n*E\n"})
public class StartWorkersTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "startWorkers";

    public StartWorkersTask() {
        Object[] objectArray;
        this.setGroup("Integration Server");
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        if (WorkerUtil.Companion.hasNonSlimWorkers(project)) {
            objectArray = new Object[]{"copyIntegrationServer"};
            this.dependsOn(objectArray);
        }
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        if (WorkerUtil.Companion.hasSlimWorkers(project2)) {
            objectArray = new Object[]{"downloadAndExtractWorkerServer"};
            this.dependsOn(objectArray);
            objectArray = new Object[]{"syncServerPluginsWithWorker"};
            this.dependsOn(objectArray);
        }
        objectArray = new Object[]{"setWorkerLogbackLevels"};
        this.dependsOn(objectArray);
        objectArray = new Object[]{"startMq"};
        this.dependsOn(objectArray);
        objectArray = new Object[]{"startCache"};
        this.dependsOn(objectArray);
        objectArray = new Object[]{"workerOverlays"};
        this.dependsOn(objectArray);
        objectArray = new Object[]{"serverYamlPatch"};
        this.dependsOn(objectArray);
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
        if (CentralConfigurationServerUtil.Companion.hasCentralConfigurationServer(project3)) {
            objectArray = new Object[]{"prepareWorkersTask"};
            this.dependsOn(objectArray);
        }
        this.onlyIf(new Spec(){

            public final boolean isSatisfiedBy(Task it) {
                Project project = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                return WorkerUtil.Companion.hasWorkers(project);
            }
        });
    }

    private final File getBinDir(Worker worker) {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        String[] stringArray = new String[]{"bin"};
        File file = Paths.get(WorkerUtil.Companion.getWorkerWorkingDir(project, worker), stringArray).toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"get(WorkerUtil.getWorker\u2026 worker), \"bin\").toFile()");
        return file;
    }

    private final File getLogDir(Worker worker) {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        String[] stringArray = new String[]{"log"};
        File file = Paths.get(WorkerUtil.Companion.getWorkerWorkingDir(project, worker), stringArray).toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"get(WorkerUtil.getWorker\u2026 worker), \"log\").toFile()");
        return file;
    }

    private final String logFileName(String workerName) {
        return "deploy-worker-" + workerName;
    }

    private final Process startWorker(Worker worker) {
        this.getProject().getLogger().lifecycle("Launching worker " + worker + ".name");
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        String hostName = DeployServerUtil.Companion.readDeployitConfProperty(project, "server.hostname");
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        String port = DeployServerUtil.Companion.readDeployitConfProperty(project2, "server.port");
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
        List<String> params2 = WorkerUtil.Companion.composeProgramParams(project3, worker, hostName, port, true);
        Project project4 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"project");
        Map<String, String> environment = EnvironmentUtil.Companion.getEnv(project4, "JDK_JAVA_OPTIONS", worker.getDebugSuspend(), worker.getDebugPort(), this.logFileName(worker.getName()));
        this.getProject().getLogger().info("Starting worker with environment: " + environment);
        Pair[] pairArray = new Pair[6];
        pairArray[0] = TuplesKt.to((Object)"command", (Object)"run");
        pairArray[1] = TuplesKt.to((Object)"params", params2);
        pairArray[2] = TuplesKt.to((Object)"environment", environment);
        pairArray[3] = TuplesKt.to((Object)"workDir", (Object)this.getBinDir(worker));
        CharSequence charSequence = worker.getStdoutFileName();
        pairArray[4] = TuplesKt.to((Object)"discardIO", (Object)(charSequence == null || charSequence.length() == 0 ? 1 : 0));
        charSequence = worker.getStdoutFileName();
        pairArray[5] = TuplesKt.to((Object)"redirectTo", (Object)(!(charSequence == null || charSequence.length() == 0) ? new File(this.getLogDir(worker) + "/" + worker.getStdoutFileName()) : null));
        return ProcessUtil.Companion.exec(MapsKt.mapOf((Pair[])pairArray));
    }

    private final Process startWorkerFromClasspath(Worker worker) {
        Object[] objectArray;
        String string = this.getProject().getConfigurations().getByName("integrationTestServer").filter((Spec)startWorkerFromClasspath.classpath.1.INSTANCE).getAsPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.configurations.g\u2026(\"-sources.jar\") }.asPath");
        String classpath2 = string;
        this.getLogger().debug("XL Deploy Worker classpath: \n" + classpath2);
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        String hostName = DeployServerUtil.Companion.readDeployitConfProperty(project, "server.hostname");
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        String port = DeployServerUtil.Companion.readDeployitConfProperty(project2, "server.port");
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
        List<String> programArgs = WorkerUtil.Companion.composeProgramParams(project3, worker, hostName, port, false);
        List jvmArgs = CollectionsKt.toMutableList((Collection)ArraysKt.toList((Object[])worker.getJvmArgs()));
        jvmArgs.add("-DLOGFILE=" + this.logFileName(worker.getName()));
        Integer n = worker.getDebugPort();
        if (n != null) {
            int dPort = ((Number)n).intValue();
            boolean bl = false;
            Project project4 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"project");
            jvmArgs.addAll((Collection)JavaUtil.Companion.debugJvmArg(project4, dPort, worker.getDebugSuspend()));
        }
        Project project5 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project5, (String)"project");
        if (DeployServerUtil.Companion.isTls(project5)) {
            Project project6 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project6, (String)"project");
            Project project7 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project7, (String)"project");
            Tls tls = TlsUtil.Companion.getTls(project6, DeployServerUtil.Companion.getServerWorkingDir(project7));
            objectArray = new String[2];
            Object object = tls;
            objectArray[0] = "-Djavax.net.ssl.trustStore=" + (object != null && (object = ((Tls)object).trustStoreFile()) != null ? ((File)object).getAbsolutePath() : null);
            Tls tls2 = tls;
            objectArray[1] = "-Djavax.net.ssl.trustStorePassword=" + (tls2 != null ? tls2.getTruststorePassword() : null);
            CollectionsKt.addAll((Collection)jvmArgs, (Object[])objectArray);
        }
        objectArray = new Pair[7];
        objectArray[0] = TuplesKt.to((Object)"classpath", (Object)classpath2);
        CharSequence charSequence = worker.getStdoutFileName();
        objectArray[1] = TuplesKt.to((Object)"discardIO", (Object)(!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? 1 : 0));
        objectArray[2] = TuplesKt.to((Object)"jvmArgs", (Object)jvmArgs);
        objectArray[3] = TuplesKt.to((Object)"mainClass", (Object)"com.xebialabs.deployit.TaskExecutionEngineBootstrapper");
        objectArray[4] = TuplesKt.to((Object)"programArgs", programArgs);
        charSequence = worker.getStdoutFileName();
        objectArray[5] = TuplesKt.to((Object)"redirectTo", (Object)(!(charSequence == null || charSequence.length() == 0) ? new File(this.getLogDir(worker) + "/" + worker.getStdoutFileName()) : null));
        Project project8 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project8, (String)"project");
        objectArray[6] = TuplesKt.to((Object)"workDir", (Object)new File(WorkerUtil.Companion.getWorkerWorkingDir(project8, worker)));
        Map config = MapsKt.mutableMapOf((Pair[])objectArray);
        if (this.getProject().hasProperty("integrationServerJVMPath")) {
            Project project9 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project9, (String)"project");
            config.putAll(JavaUtil.Companion.jvmPath(project9, String.valueOf(this.getProject().property("integrationServerJVMPath"))));
        }
        this.getProject().getLogger().lifecycle("Starting Worker " + worker.getName() + " for project " + this.getProject().getName() + " on a port: " + worker.getPort());
        return JavaUtil.Companion.execJava(config);
    }

    private final void waitForBoot(Worker worker, Process process) {
        Project project = this.getProject();
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        File file = project.file((Object)(WorkerUtil.Companion.getWorkerWorkingDir(project2, worker) + "/log/" + this.logFileName(worker.getName()) + ".log"));
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.file(\"${WorkerUt\u2026eName(worker.name)}.log\")");
        File workerLog = file;
        String containsLine = "Registered successfully with Actor[pekko://task-sys@127.0.0.1";
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
        Server server = DeployServerUtil.Companion.getServer(project3);
        Project project4 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"project");
        WaitForBootUtil.Companion.byLog(project4, "worker " + worker.getName(), workerLog, containsLine, process, server.getPingRetrySleepTime(), server.getPingTotalTries());
    }

    @TaskAction
    public final void launch() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        NamedDomainObjectContainer<Worker> workers = DeployExtensionUtil.Companion.getExtension(project).getWorkers();
        Iterable $this$forEach$iv = (Iterable)workers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Worker worker = (Worker)element$iv;
            boolean bl = false;
            Project project2 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
            Intrinsics.checkNotNullExpressionValue((Object)worker, (String)"worker");
            Process process = WorkerUtil.Companion.hasRuntimeDirectory(project2, worker) ? this.startWorkerFromClasspath(worker) : this.startWorker(worker);
            this.getProject().getLogger().lifecycle("Worker '" + worker.getName() + "' successfully started on PID [" + process.pid() + "] with command [" + process.info().commandLine().orElse("") + "].");
            this.waitForBoot(worker, process);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/digital/integration/server/deploy/tasks/worker/StartWorkersTask$Companion;", "", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

