/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks.worker;

import ai.digital.integration.server.common.util.ProcessUtil;
import ai.digital.integration.server.deploy.domain.Worker;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import ai.digital.integration.server.deploy.internals.WorkerUtil;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.io.FileUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lai/digital/integration/server/deploy/tasks/worker/CopyIntegrationServerTask;", "Lorg/gradle/api/DefaultTask;", "()V", "copyServer", "", "copyServerDirToWorkerDir", "worker", "Lai/digital/integration/server/deploy/domain/Worker;", "Companion", "integration-server-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nCopyIntegrationServerTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CopyIntegrationServerTask.kt\nai/digital/integration/server/deploy/tasks/worker/CopyIntegrationServerTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,45:1\n774#2:46\n865#2,2:47\n774#2:49\n865#2,2:50\n1863#2,2:52\n*S KotlinDebug\n*F\n+ 1 CopyIntegrationServerTask.kt\nai/digital/integration/server/deploy/tasks/worker/CopyIntegrationServerTask\n*L\n27#1:46\n27#1:47,2\n28#1:49\n28#1:50,2\n29#1:52,2\n*E\n"})
public class CopyIntegrationServerTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "copyIntegrationServer";

    public CopyIntegrationServerTask() {
        this.setGroup("Integration Server");
        Object[] objectArray = new Object[]{"serverYamlPatch"};
        this.dependsOn(objectArray);
        this.onlyIf(new Spec(){

            public final boolean isSatisfiedBy(Task it) {
                Project project = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                return WorkerUtil.Companion.hasWorkers(project);
            }
        });
    }

    @TaskAction
    public final void copyServer() {
        Worker worker;
        Iterable $this$filterTo$iv$iv;
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        Iterable $this$filter$iv = WorkerUtil.Companion.getWorkers(project);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            worker = (Worker)element$iv$iv;
            boolean bl = false;
            if (!(!worker.getSlimDistribution())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            worker = (Worker)element$iv$iv;
            boolean bl = false;
            Project project2 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
            if (!WorkerUtil.Companion.isExternalRuntimeWorker(project2, worker)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Worker worker2 = (Worker)element$iv;
            boolean bl = false;
            this.copyServerDirToWorkerDir(worker2);
        }
    }

    private final void copyServerDirToWorkerDir(Worker worker) {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        File sourceDir = Paths.get(DeployServerUtil.Companion.getServerWorkingDir(project), new String[0]).toFile();
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        File destinationDir = Paths.get(WorkerUtil.Companion.getWorkerWorkingDir(project2, worker), new String[0]).toFile();
        FileUtils.copyDirectory((File)sourceDir, (File)destinationDir);
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
        String[] stringArray = new String[]{"bin"};
        ProcessUtil.Companion.chMod(project3, "755", ((Object)Paths.get(destinationDir.getAbsolutePath(), stringArray)).toString());
        stringArray = new String[]{"log"};
        FileUtils.cleanDirectory((File)Paths.get(destinationDir.getAbsolutePath(), stringArray).toFile());
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/digital/integration/server/deploy/tasks/worker/CopyIntegrationServerTask$Companion;", "", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

