/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.cluster;

import ai.digital.integration.server.common.cluster.Helper;
import ai.digital.integration.server.common.constant.ClusterProfileName;
import ai.digital.integration.server.common.constant.ProductName;
import ai.digital.integration.server.common.domain.Server;
import ai.digital.integration.server.common.domain.profiles.IngressType;
import ai.digital.integration.server.common.domain.profiles.OperatorHelmProfile;
import ai.digital.integration.server.common.domain.providers.Provider;
import ai.digital.integration.server.common.util.FileUtil;
import ai.digital.integration.server.common.util.IntegrationServerUtil;
import ai.digital.integration.server.common.util.KubeCtlHelper;
import ai.digital.integration.server.common.util.ProcessUtil;
import ai.digital.integration.server.common.util.PropertiesUtil;
import ai.digital.integration.server.common.util.ServerUtil;
import ai.digital.integration.server.common.util.WaitForBootUtil;
import ai.digital.integration.server.common.util.YamlFileUtil;
import ai.digital.integration.server.deploy.domain.Worker;
import ai.digital.integration.server.deploy.internals.DeployExtensionUtil;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import ai.digital.integration.server.deploy.internals.WorkerUtil;
import ai.digital.integration.server.deploy.internals.cluster.DeployClusterUtil;
import ai.digital.integration.server.release.internals.ReleaseExtensionUtil;
import ai.digital.integration.server.release.tasks.cluster.ReleaseClusterUtil;
import ai.digital.integration.server.release.util.ReleaseServerUtil;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\n\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eJ\u000e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000eJ\u0006\u0010\u0012\u001a\u00020\u000eJ\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u0016\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u000eJ\b\u0010\u0018\u001a\u00020\u000eH\u0016J\u0006\u0010\u0019\u001a\u00020\u000eJ\b\u0010\u001a\u001a\u00020\u000eH\u0016J\u0006\u0010\u001b\u001a\u00020\u001cJ\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0006\u0010\u001f\u001a\u00020\u000eJ\b\u0010 \u001a\u00020\u000eH\u0016J\b\u0010!\u001a\u00020\u000eH\u0016J\b\u0010\"\u001a\u00020#H\u0016J\u0006\u0010$\u001a\u00020\u000eJ\b\u0010%\u001a\u00020\u001eH\u0016J\u0010\u0010&\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020\u001eH\u0016J\u0010\u0010(\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020\u001eH\u0016J\b\u0010)\u001a\u00020\u000eH\u0016J\u0006\u0010*\u001a\u00020\u000eJ\n\u0010+\u001a\u0004\u0018\u00010\u000eH\u0016J\b\u0010,\u001a\u00020\u000eH\u0016J\u0010\u0010-\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020\u001eH\u0016J\u0006\u0010.\u001a\u00020\u000eJ\u0006\u0010/\u001a\u000200J\u0006\u00101\u001a\u00020\u000eJ\b\u00102\u001a\u000203H&J\u0006\u00104\u001a\u00020\u000eJ\u0010\u00105\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020\u001eH\u0016J\u0006\u00106\u001a\u000207J\u0006\u00108\u001a\u00020\u000eJ\u0006\u00109\u001a\u00020\u000eJ\b\u0010:\u001a\u00020\u000eH\u0016J\u001a\u0010;\u001a\u00020\u00142\u0006\u0010<\u001a\u00020\u000e2\n\b\u0002\u0010=\u001a\u0004\u0018\u00010\u000eJ\u0010\u0010>\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020\u001eH\u0016J\b\u0010?\u001a\u00020@H\u0016J\u0016\u0010A\u001a\u00020\f2\u0006\u0010B\u001a\u00020\u000e2\u0006\u0010C\u001a\u00020\u000eJ \u0010D\u001a\u00020\f2\u0006\u0010E\u001a\u00020\u000e2\u0006\u0010F\u001a\u00020\u001e2\b\b\u0002\u0010G\u001a\u00020@J\u000e\u0010H\u001a\u00020\f2\u0006\u0010F\u001a\u00020\u001eJ\u000e\u0010I\u001a\u00020\f2\u0006\u0010F\u001a\u00020\u001eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006J"}, d2={"Lai/digital/integration/server/common/cluster/Helper;", "", "project", "Lorg/gradle/api/Project;", "productName", "Lai/digital/integration/server/common/constant/ProductName;", "(Lorg/gradle/api/Project;Lai/digital/integration/server/common/constant/ProductName;)V", "getProductName", "()Lai/digital/integration/server/common/constant/ProductName;", "getProject", "()Lorg/gradle/api/Project;", "clusterMetadata", "", "metaDataPath", "", "contextRoot", "exec", "command", "getCentralConfigImageRepository", "getConfigDir", "Ljava/io/File;", "getContextRootPath", "file", "pathKey", "getCrName", "getDbConnectionCount", "getDbStorageClass", "getDeployWorker", "Lai/digital/integration/server/deploy/domain/Worker;", "getDeployWorkerCount", "", "getDeployWorkerImageRepository", "getFqdn", "getHost", "getKubectlHelper", "Lai/digital/integration/server/common/util/KubeCtlHelper;", "getLicense", "getMasterCount", "getMasterPodName", "position", "getMasterPodNameSuffix", "getMqStorageClass", "getName", "getNamespace", "getPort", "getPostgresPodName", "getPrefixName", "getProfile", "Lai/digital/integration/server/common/domain/profiles/OperatorHelmProfile;", "getProfileName", "getProvider", "Lai/digital/integration/server/common/domain/providers/Provider;", "getProviderWorkDir", "getRabbitMqPodName", "getServer", "Lai/digital/integration/server/common/domain/Server;", "getServerImageRepository", "getServerVersion", "getStorageClass", "getTemplate", "relativePath", "targetFilename", "getWorkerPodName", "hasIngress", "", "waitForBoot", "pContextRoot", "fqdn", "waitForDeployment", "ingressType", "deploymentTimeoutSeconds", "skipOperator", "waitForMasterPods", "waitForWorkerPods", "integration-server-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Helper.kt\nai/digital/integration/server/common/cluster/Helper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,289:1\n1#2:290\n13409#3,2:291\n1863#4,2:293\n1863#4,2:295\n*S KotlinDebug\n*F\n+ 1 Helper.kt\nai/digital/integration/server/common/cluster/Helper\n*L\n242#1:291,2\n252#1:293,2\n261#1:295,2\n*E\n"})
public abstract class Helper {
    @NotNull
    private final Project project;
    @NotNull
    private final ProductName productName;

    public Helper(@NotNull Project project, @NotNull ProductName productName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)productName), (String)"productName");
        this.project = project;
        this.productName = productName;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final ProductName getProductName() {
        return this.productName;
    }

    @NotNull
    public abstract Provider getProvider();

    @NotNull
    public KubeCtlHelper getKubectlHelper() {
        return new KubeCtlHelper(this.project, this.getNamespace(), false, 4, null);
    }

    public int getMasterCount() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.productName.ordinal()]) {
            case 1 -> DeployServerUtil.Companion.getServers(this.project).size();
            case 2 -> ReleaseExtensionUtil.Companion.getExtension(this.project).getServers().size();
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public int getDeployWorkerCount() {
        return WorkerUtil.Companion.getNumberOfWorkers(this.project);
    }

    @NotNull
    public String getStorageClass() {
        Object object = this.getProvider().getStorageClass().getOrElse((Object)"standard");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getProvider().storageClass.getOrElse(\"standard\")");
        return (String)object;
    }

    @NotNull
    public String getDbStorageClass() {
        return this.getStorageClass();
    }

    @NotNull
    public String getMqStorageClass() {
        return this.getStorageClass();
    }

    @NotNull
    public String getFqdn() {
        Object object = this.getProvider().getHost().getOrElse(this.getProvider().getName().get());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getProvider().host.getOr\u2026getProvider().name.get())");
        return (String)object;
    }

    @NotNull
    public String getHost() {
        Object object = this.getProvider().getHost().getOrElse(this.getProvider().getName().get());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getProvider().host.getOr\u2026getProvider().name.get())");
        return (String)object;
    }

    @NotNull
    public String getPort() {
        return "80";
    }

    public boolean hasIngress() {
        return true;
    }

    @NotNull
    public String getWorkerPodName(int position) {
        return "pod/" + this.getCrName() + "-digitalai-" + this.getName() + "-worker-" + position;
    }

    @NotNull
    public String getMasterPodName(int position) {
        return "pod/" + this.getCrName() + "-digitalai-" + this.getName() + "-" + this.getMasterPodNameSuffix(position);
    }

    @NotNull
    public String getPostgresPodName(int position) {
        return "pod/" + this.getCrName() + "-postgresql-" + position;
    }

    @NotNull
    public String getRabbitMqPodName(int position) {
        return "pod/" + this.getCrName() + "-rabbitmq-" + position;
    }

    @Nullable
    public String getNamespace() {
        return (String)this.getProfile().getNamespace().getOrNull();
    }

    @NotNull
    public String getCrName() {
        Object object;
        block3: {
            block2: {
                object = this.getNamespace();
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                String string = "-" + it;
                object = string;
                if (string != null) break block3;
            }
            object = "";
        }
        String operatorNamespace = object;
        return "dai-" + this.getPrefixName() + operatorNamespace;
    }

    @NotNull
    public String getMasterPodNameSuffix(int position) {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.productName.ordinal()]) {
            case 1 -> "master-" + position;
            case 2 -> String.valueOf(position);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public final String getContextRootPath(@NotNull File file, @NotNull String pathKey) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)pathKey, (String)"pathKey");
        Object object = YamlFileUtil.Companion.readFileKey$default(YamlFileUtil.Companion, file, pathKey, false, 4, null);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
        String pathValue = (String)object;
        String expectedPathValue = switch (WhenMappings.$EnumSwitchMapping$0[this.productName.ordinal()]) {
            case 1 -> "/xl-deploy";
            case 2 -> "/xl-release";
            default -> throw new NoWhenBranchMatchedException();
        };
        return StringsKt.startsWith$default((String)pathValue, (String)expectedPathValue, (boolean)false, (int)2, null) ? expectedPathValue : "/";
    }

    @NotNull
    public final String getProfileName() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.productName.ordinal()]) {
            case 1 -> DeployClusterUtil.Companion.getProfile(this.project);
            case 2 -> ReleaseClusterUtil.Companion.getProfile(this.project);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public final OperatorHelmProfile getProfile() {
        String profileName = this.getProfileName();
        if (Intrinsics.areEqual((Object)profileName, (Object)ClusterProfileName.OPERATOR.getProfileName())) {
            return switch (WhenMappings.$EnumSwitchMapping$0[this.productName.ordinal()]) {
                case 1 -> DeployExtensionUtil.Companion.getExtension(this.project).getClusterProfiles().operator();
                case 2 -> ReleaseExtensionUtil.Companion.getExtension(this.project).getClusterProfiles().operator();
                default -> throw new NoWhenBranchMatchedException();
            };
        }
        if (Intrinsics.areEqual((Object)profileName, (Object)ClusterProfileName.HELM.getProfileName())) {
            return switch (WhenMappings.$EnumSwitchMapping$0[this.productName.ordinal()]) {
                case 1 -> DeployExtensionUtil.Companion.getExtension(this.project).getClusterProfiles().helm();
                case 2 -> ReleaseExtensionUtil.Companion.getExtension(this.project).getClusterProfiles().helm();
                default -> throw new NoWhenBranchMatchedException();
            };
        }
        throw new IllegalArgumentException("Provided profile name `" + profileName + "` is not supported");
    }

    @NotNull
    public final String getProviderWorkDir() {
        String path = ((Directory)this.project.getLayout().getBuildDirectory().dir(this.getProvider().getName().get() + "-work").get()).getAsFile().getAbsolutePath();
        new File(path).mkdirs();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
        return path;
    }

    @NotNull
    public final String getServerImageRepository() {
        String string = this.getServer().getDockerImage();
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @NotNull
    public final String getCentralConfigImageRepository() {
        String string = this.getServer().getCentralConfigDockerImage();
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @NotNull
    public final String getDeployWorkerImageRepository() {
        String string = this.getDeployWorker().getDockerImage();
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @NotNull
    public final String getServerVersion() {
        String string = this.getServer().getVersion();
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @NotNull
    public final Server getServer() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.productName.ordinal()]) {
            case 1 -> DeployServerUtil.Companion.getServer(this.project);
            case 2 -> ReleaseServerUtil.Companion.getServer(this.project);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public final Worker getDeployWorker() {
        return WorkerUtil.Companion.getWorkers(this.project).get(0);
    }

    @NotNull
    public final String getDbConnectionCount() {
        int defaultMaxDbConnections = switch (WhenMappings.$EnumSwitchMapping$0[this.productName.ordinal()]) {
            case 1 -> 44 * (this.getMasterCount() + this.getDeployWorkerCount());
            case 2 -> 33 * this.getMasterCount();
            default -> throw new NoWhenBranchMatchedException();
        };
        return String.valueOf(((Number)this.getProvider().getMaxDbConnections().getOrElse((Object)defaultMaxDbConnections)).intValue());
    }

    @NotNull
    public final String getLicense() {
        String licenseFileName = switch (WhenMappings.$EnumSwitchMapping$0[this.productName.ordinal()]) {
            case 1 -> "deployit-license.lic";
            case 2 -> "xl-release-license.lic";
            default -> throw new NoWhenBranchMatchedException();
        };
        File licenseFile = new File(this.getConfigDir(), licenseFileName);
        String content = Files.readString(licenseFile.toPath());
        Base64.Encoder encoder = Base64.getEncoder();
        Intrinsics.checkNotNullExpressionValue((Object)content, (String)"content");
        String string = content;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        String string2 = encoder.encodeToString(byArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getEncoder().encodeToString(content.toByteArray())");
        return string2;
    }

    @NotNull
    public final String getName() {
        String string = this.productName.toString().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return string;
    }

    @NotNull
    public final String getPrefixName() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.productName.ordinal()]) {
            case 1 -> "xld";
            case 2 -> "xlr";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public final File getTemplate(@NotNull String relativePath, @Nullable String targetFilename) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        File file = new File(relativePath);
        InputStream fileStream2 = ((Object)((Object)getTemplate.fileStream.1.INSTANCE)).getClass().getClassLoader().getResourceAsStream(relativePath);
        String string = this.getProviderWorkDir();
        String[] stringArray = new String[1];
        String string2 = targetFilename;
        if (string2 == null) {
            string2 = file.getName();
        }
        stringArray[0] = string2;
        Path resultComposeFilePath = Paths.get(string, stringArray);
        InputStream inputStream = fileStream2;
        if (inputStream != null) {
            InputStream it = inputStream;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)resultComposeFilePath, (String)"resultComposeFilePath");
            FileUtil.Companion.copyFile(it, resultComposeFilePath);
        }
        File file2 = resultComposeFilePath.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"resultComposeFilePath.toFile()");
        return file2;
    }

    public static /* synthetic */ File getTemplate$default(Helper helper, String string, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getTemplate");
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        return helper.getTemplate(string, string2);
    }

    public final void clusterMetadata(@NotNull String metaDataPath, @NotNull String contextRoot) {
        Intrinsics.checkNotNullParameter((Object)metaDataPath, (String)"metaDataPath");
        Intrinsics.checkNotNullParameter((Object)contextRoot, (String)"contextRoot");
        Path path = IntegrationServerUtil.Companion.getRelativePathInIntegrationServerDist(this.project, metaDataPath);
        path.getParent().toFile().mkdirs();
        Properties props = new Properties();
        ((Map)props).put("cluster.port", this.getPort());
        ((Map)props).put("cluster.context-root", contextRoot);
        ((Map)props).put("cluster.host", this.getHost());
        ((Map)props).put("cluster.fqdn", this.getFqdn());
        File file = path.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"path.toFile()");
        PropertiesUtil.Companion.writePropertiesFile(file, props);
    }

    @NotNull
    public final String exec(@NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        return ProcessUtil.Companion.executeCommand$default(ProcessUtil.Companion, command, null, false, false, 0L, 30, null);
    }

    public final void waitForDeployment(@NotNull String ingressType, int deploymentTimeoutSeconds, boolean skipOperator) {
        Object[] objectArray;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)ingressType, (String)"ingressType");
                if (!this.hasIngress()) break block5;
                switch (WhenMappings.$EnumSwitchMapping$1[IngressType.valueOf(ingressType).ordinal()]) {
                    case 1: {
                        String[] stringArray = new String[]{"deployment.apps/" + this.getCrName() + "-nginx-ingress-controller", "deployment.apps/" + this.getCrName() + "-nginx-ingress-controller-default-backend"};
                        objectArray = stringArray;
                        break block6;
                    }
                    case 2: {
                        String[] stringArray = new String[]{"deployment.apps/" + this.getCrName() + "-haproxy-ingress"};
                        objectArray = stringArray;
                        break block6;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            objectArray = new String[]{};
        }
        Object[] resources = objectArray;
        Object[] $this$forEach$iv = ArraysKt.plus((Object[])resources, (Object)("deployment.apps/" + this.getPrefixName() + "-operator-controller-manager"));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String resource = (String)element$iv;
            boolean bl = false;
            if (skipOperator || this.getKubectlHelper().wait(resource, "Available", deploymentTimeoutSeconds)) continue;
            throw new RuntimeException("Resource " + resource + "  is not available");
        }
    }

    public static /* synthetic */ void waitForDeployment$default(Helper helper, String string, int n, boolean bl, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: waitForDeployment");
        }
        if ((n2 & 4) != 0) {
            bl = false;
        }
        helper.waitForDeployment(string, n, bl);
    }

    /*
     * WARNING - void declaration
     */
    public final void waitForMasterPods(int deploymentTimeoutSeconds) {
        int n = this.getMasterCount();
        ArrayList<String> arrayList = new ArrayList<String>(n);
        int n2 = 0;
        while (n2 < n) {
            void position;
            int n3;
            int n4 = n3 = n2++;
            ArrayList<String> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(this.getMasterPodName((int)position));
        }
        List resources = arrayList;
        Iterable $this$forEach$iv = resources;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String resource = (String)element$iv;
            boolean bl = false;
            if (this.getKubectlHelper().wait(resource, "Ready", deploymentTimeoutSeconds)) continue;
            throw new RuntimeException("Resource " + resource + " is not ready");
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void waitForWorkerPods(int deploymentTimeoutSeconds) {
        int n = this.getDeployWorkerCount();
        ArrayList<String> arrayList = new ArrayList<String>(n);
        int n2 = 0;
        while (n2 < n) {
            void position;
            int n3;
            int n4 = n3 = n2++;
            ArrayList<String> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(this.getWorkerPodName((int)position));
        }
        List resources = arrayList;
        Iterable $this$forEach$iv = resources;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String resource = (String)element$iv;
            boolean bl = false;
            if (this.getKubectlHelper().wait(resource, "Ready", deploymentTimeoutSeconds)) continue;
            throw new RuntimeException("Resource " + resource + " is not ready");
        }
    }

    private final File getConfigDir() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.productName.ordinal()]) {
            case 1 -> DeployServerUtil.Companion.getConfDir(this.project);
            case 2 -> ReleaseServerUtil.Companion.getConfDir(this.project);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public final void waitForBoot(@NotNull String pContextRoot, @NotNull String fqdn) {
        String string;
        Intrinsics.checkNotNullParameter((Object)pContextRoot, (String)"pContextRoot");
        Intrinsics.checkNotNullParameter((Object)fqdn, (String)"fqdn");
        boolean bl = Intrinsics.areEqual((Object)pContextRoot, (Object)"/");
        if (bl) {
            string = "";
        } else if (!bl) {
            string = pContextRoot;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String contextRoot = string;
        String url = switch (WhenMappings.$EnumSwitchMapping$0[this.productName.ordinal()]) {
            case 1 -> "http://" + fqdn + contextRoot + "/deployit/metadata/type";
            case 2 -> "http://" + fqdn + contextRoot + "/api/extension/metadata";
            default -> throw new NoWhenBranchMatchedException();
        };
        Server server = new ServerUtil(this.project, this.productName).getServer();
        WaitForBootUtil.Companion.byPort$default(WaitForBootUtil.Companion, this.project, this.getName(), url, null, server.getPingRetrySleepTime(), server.getPingTotalTries(), null, 64, null);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ProductName.values().length];
            try {
                nArray[ProductName.DEPLOY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProductName.RELEASE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[IngressType.values().length];
            try {
                nArray[IngressType.NGINX.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IngressType.HAPROXY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

