/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.internals;

import ai.digital.integration.server.common.constant.ProductName;
import ai.digital.integration.server.common.domain.Server;
import ai.digital.integration.server.common.util.HTTPUtil;
import ai.digital.integration.server.deploy.internals.DeployServerUtil;
import ai.digital.integration.server.deploy.internals.EntryPointUrlUtil;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lai/digital/integration/server/deploy/internals/DeployShutdownUtil;", "", "<init>", "()V", "Companion", "integration-server-gradle-plugin"})
public final class DeployShutdownUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0016\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\f"}, d2={"Lai/digital/integration/server/deploy/internals/DeployShutdownUtil$Companion;", "", "<init>", "()V", "waitForShutdown", "", "project", "Lorg/gradle/api/Project;", "killProcessByPort", "port", "", "shutdownServer", "integration-server-gradle-plugin"})
    @SourceDebugExtension(value={"SMAP\nDeployShutdownUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeployShutdownUtil.kt\nai/digital/integration/server/deploy/internals/DeployShutdownUtil$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,172:1\n774#2:173\n865#2,2:174\n774#2:176\n865#2,2:177\n1869#2,2:179\n*S KotlinDebug\n*F\n+ 1 DeployShutdownUtil.kt\nai/digital/integration/server/deploy/internals/DeployShutdownUtil$Companion\n*L\n91#1:173\n91#1:174,2\n107#1:176\n107#1:177,2\n116#1:179,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final void waitForShutdown(Project project) {
            Server server = DeployServerUtil.Companion.getServer(project);
            boolean success = false;
            for (int triesLeft = server.getPingTotalTries(); triesLeft > 0 && !success; --triesLeft) {
                try {
                    HttpClient client = HttpClient.newHttpClient();
                    HttpRequest request = HTTPUtil.Companion.doRequest$default(HTTPUtil.Companion, EntryPointUrlUtil.composeUrl$default(new EntryPointUrlUtil(project, ProductName.DEPLOY, false, 4, null), server.getContextRoot(), false, 2, null), null, null, 6, null).POST(HttpRequest.BodyPublishers.noBody()).build();
                    HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                    project.getLogger().lifecycle("Waiting " + server.getPingRetrySleepTime() + " seconds for shutdown. (" + triesLeft + ")");
                    TimeUnit.SECONDS.sleep(server.getPingRetrySleepTime());
                    if (response.statusCode() == 200) continue;
                    project.getLogger().lifecycle("XL Deploy server successfully shutdown");
                    success = true;
                    continue;
                }
                catch (Exception ignored) {
                    project.getLogger().lifecycle("XL Deploy server successfully shutdown.");
                    success = true;
                    break;
                }
            }
            if (!success) {
                throw new GradleException("Server failed to stop");
            }
        }

        public final void killProcessByPort(@NotNull Project project, int port) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            try {
                project.getLogger().lifecycle("Attempting to kill process on port " + port);
                String string = System.getProperty("os.name");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
                String string2 = string.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                String osName = string2;
                if (StringsKt.contains$default((CharSequence)osName, (CharSequence)"windows", (boolean)false, (int)2, null)) {
                    String[] stringArray = new String[]{"cmd", "/c", "netstat -ano | findstr :" + port};
                    ProcessBuilder findProcess = new ProcessBuilder(stringArray);
                    findProcess.redirectErrorStream(true);
                    Process findResult = findProcess.start();
                    InputStream inputStream = findResult.getInputStream();
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
                    InputStream inputStream2 = inputStream;
                    Charset charset = Charsets.UTF_8;
                    Reader reader = new InputStreamReader(inputStream2, charset);
                    int n = 8192;
                    String output = TextStreamsKt.readText((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)));
                    findResult.waitFor();
                    Regex pidPattern = new Regex("LISTENING\\s+(\\d+)");
                    MatchResult match = Regex.find$default((Regex)pidPattern, (CharSequence)output, (int)0, (int)2, null);
                    if (match != null) {
                        String pid = (String)match.getGroupValues().get(1);
                        project.getLogger().lifecycle("Found process " + pid + " on port " + port + ", attempting to kill");
                        String[] stringArray2 = new String[]{"taskkill", "/F", "/PID", pid};
                        ProcessBuilder killProcess = new ProcessBuilder(stringArray2);
                        killProcess.redirectErrorStream(true);
                        Process killResult = killProcess.start();
                        killResult.waitFor(10L, TimeUnit.SECONDS);
                        project.getLogger().lifecycle("Forcefully killed process " + pid);
                    } else {
                        project.getLogger().lifecycle("No process found listening on port " + port);
                    }
                } else if (StringsKt.contains$default((CharSequence)osName, (CharSequence)"linux", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)osName, (CharSequence)"mac", (boolean)false, (int)2, null)) {
                    String it;
                    Object element$iv$iv;
                    Iterator iterator;
                    Object $this$filterTo$iv$iv22;
                    boolean $i$f$filterTo;
                    Object $this$filter$iv;
                    List list;
                    Object lsofResult;
                    List pids = new ArrayList();
                    try {
                        String[] output = new String[]{"sh", "-c", "lsof -ti:" + port + " 2>/dev/null || true"};
                        ProcessBuilder lsofProcess = new ProcessBuilder(output);
                        lsofProcess.redirectErrorStream(false);
                        lsofResult = lsofProcess.start();
                        String[] stringArray = ((Process)lsofResult).getInputStream();
                        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getInputStream(...)");
                        Object match = stringArray;
                        Charset pid = Charsets.UTF_8;
                        Object killProcess = new InputStreamReader((InputStream)match, pid);
                        int killResult = 8192;
                        String lsofOutput = ((Object)StringsKt.trim((CharSequence)TextStreamsKt.readText((Reader)(killProcess instanceof BufferedReader ? (BufferedReader)killProcess : new BufferedReader((Reader)killProcess, killResult))))).toString();
                        ((Process)lsofResult).waitFor(5L, TimeUnit.SECONDS);
                        if (((CharSequence)lsofOutput).length() > 0) {
                            match = new String[]{"\n"};
                            match = StringsKt.split$default((CharSequence)lsofOutput, (String[])match, (boolean)false, (int)0, (int)6, null);
                            list = pids;
                            boolean $i$f$filter = false;
                            killProcess = $this$filter$iv;
                            Collection destination$iv$iv = new ArrayList();
                            $i$f$filterTo = false;
                            iterator = $this$filterTo$iv$iv22.iterator();
                            while (iterator.hasNext()) {
                                element$iv$iv = iterator.next();
                                it = (String)element$iv$iv;
                                boolean bl = false;
                                boolean bl2 = !StringsKt.isBlank((CharSequence)it);
                                if (!bl2) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            list.addAll((List)destination$iv$iv);
                        }
                    }
                    catch (Exception e) {
                        project.getLogger().debug("lsof command failed: " + e.getMessage());
                    }
                    if (pids.isEmpty()) {
                        try {
                            lsofResult = new String[]{"sh", "-c", "fuser " + port + "/tcp 2>/dev/null || true"};
                            ProcessBuilder fuserProcess = new ProcessBuilder((String[])lsofResult);
                            fuserProcess.redirectErrorStream(false);
                            Process fuserResult = fuserProcess.start();
                            InputStream inputStream = fuserResult.getInputStream();
                            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
                            $this$filter$iv = inputStream;
                            Charset $i$f$filter = Charsets.UTF_8;
                            $this$filterTo$iv$iv22 = new InputStreamReader((InputStream)$this$filter$iv, $i$f$filter);
                            int destination$iv$iv = 8192;
                            String fuserOutput = ((Object)StringsKt.trim((CharSequence)TextStreamsKt.readText((Reader)($this$filterTo$iv$iv22 instanceof BufferedReader ? (BufferedReader)$this$filterTo$iv$iv22 : new BufferedReader((Reader)$this$filterTo$iv$iv22, destination$iv$iv))))).toString();
                            fuserResult.waitFor(5L, TimeUnit.SECONDS);
                            if (((CharSequence)fuserOutput).length() > 0) {
                                $this$filter$iv = fuserOutput;
                                $i$f$filter = new Regex("\\s+");
                                int $this$filterTo$iv$iv22 = 0;
                                $this$filter$iv = $i$f$filter.split((CharSequence)$this$filter$iv, $this$filterTo$iv$iv22);
                                list = pids;
                                boolean $i$f$filter2 = false;
                                $this$filterTo$iv$iv22 = $this$filter$iv;
                                Collection destination$iv$iv2 = new ArrayList();
                                $i$f$filterTo = false;
                                iterator = $this$filterTo$iv$iv22.iterator();
                                while (iterator.hasNext()) {
                                    element$iv$iv = iterator.next();
                                    it = (String)element$iv$iv;
                                    boolean bl = false;
                                    boolean bl3 = !StringsKt.isBlank((CharSequence)it);
                                    if (!bl3) continue;
                                    destination$iv$iv2.add(element$iv$iv);
                                }
                                list.addAll((List)destination$iv$iv2);
                            }
                        }
                        catch (Exception e) {
                            project.getLogger().debug("fuser command failed: " + e.getMessage());
                        }
                    }
                    if (!((Collection)pids).isEmpty()) {
                        Iterable $this$forEach$iv = pids;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            String pid = (String)element$iv;
                            boolean bl = false;
                            try {
                                project.getLogger().lifecycle("Found process " + pid + " on port " + port + ", attempting to kill");
                                String[] destination$iv$iv2 = new String[]{"kill", "-9", pid};
                                ProcessBuilder killProcess = new ProcessBuilder(destination$iv$iv2);
                                killProcess.redirectErrorStream(true);
                                Process killResult = killProcess.start();
                                killResult.waitFor(5L, TimeUnit.SECONDS);
                                project.getLogger().lifecycle("Forcefully killed process " + pid);
                            }
                            catch (Exception e) {
                                project.getLogger().warn("Failed to kill process " + pid + ": " + e.getMessage());
                            }
                        }
                    } else {
                        project.getLogger().lifecycle("No process found listening on port " + port);
                    }
                }
                TimeUnit.SECONDS.sleep(2L);
            }
            catch (Exception e) {
                project.getLogger().warn("Failed to kill process on port " + port + ": " + e.getMessage());
            }
        }

        public final void shutdownServer(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Server server = DeployServerUtil.Companion.getServer(project);
            int port = server.getHttpPort();
            boolean gracefulShutdownSucceeded = false;
            try {
                project.getLogger().lifecycle("Trying to shutdown integration server on port " + port);
                HttpClient client = HttpClient.newHttpClient();
                HttpRequest request = HTTPUtil.Companion.doRequest$default(HTTPUtil.Companion, EntryPointUrlUtil.composeUrl$default(new EntryPointUrlUtil(project, ProductName.DEPLOY, false, 4, null), "/deployit/server/shutdown", false, 2, null), null, null, 6, null).POST(HttpRequest.BodyPublishers.noBody()).build();
                client.send(request, HttpResponse.BodyHandlers.ofString());
                this.waitForShutdown(project);
                project.getLogger().lifecycle("Integration server at port " + port + " is now shutdown");
                gracefulShutdownSucceeded = true;
            }
            catch (Exception ignored) {
                project.getLogger().lifecycle("Integration server on port " + port + " is not responding to graceful shutdown");
            }
            if (!gracefulShutdownSucceeded) {
                this.killProcessByPort(project, port);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

