/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.common.tasks.database;

import ai.digital.integration.server.common.domain.DbParameters;
import ai.digital.integration.server.common.util.DbConfigurationUtil;
import ai.digital.integration.server.common.util.DbUtil;
import ai.digital.integration.server.common.util.IntegrationServerUtil;
import ai.digital.integration.server.common.util.PostgresDbUtil;
import ai.digital.integration.server.deploy.internals.DeployExtensionUtil;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.xml.FlatXmlDataSet;
import org.dbunit.dataset.xml.FlatXmlDataSetBuilder;
import org.dbunit.operation.DatabaseOperation;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\n\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\b\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\f"}, d2={"Lai/digital/integration/server/common/tasks/database/ImportDbUnitDataTask;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "getConfiguration", "Lkotlin/Triple;", "", "configureDataSet", "Lorg/dbunit/dataset/xml/FlatXmlDataSet;", "runImport", "", "Companion", "integration-server-gradle-plugin"})
public class ImportDbUnitDataTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "importDbUnitData";

    public ImportDbUnitDataTask() {
        this.setGroup("Integration Server");
        Object[] objectArray = new Object[]{"downloadAndExtractDbUnitData"};
        this.dependsOn(objectArray);
        this.onlyIf(new Spec(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isSatisfiedBy(Task it) {
                Project project = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                if (DbUtil.Companion.isDerby(project)) return false;
                Project project2 = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                if (DeployExtensionUtil.Companion.getExtension(project2).getXldIsDataVersion() == null) return false;
                return true;
            }
        });
    }

    private final Triple<String, String, String> getConfiguration() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        String username = DbUtil.Companion.getDbPropValue(project, "db-username");
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        String password = DbUtil.Companion.getDbPropValue(project2, "db-password");
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
        String url = DbUtil.Companion.getDbPropValue(project3, "db-url");
        Project project4 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"getProject(...)");
        String updatedDbUrl = StringsKt.replace$default((String)url, (String)"{{DB_PORT}}", (String)String.valueOf(DbUtil.Companion.getPort(project4)), (boolean)false, (int)4, null);
        return new Triple((Object)username, (Object)password, (Object)updatedDbUrl);
    }

    private final FlatXmlDataSet configureDataSet() {
        FlatXmlDataSetBuilder provider = new FlatXmlDataSetBuilder();
        provider.setColumnSensing(true);
        provider.setCaseSensitiveTableNames(true);
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        String version = DeployExtensionUtil.Companion.getExtension(project).getXldIsDataVersion();
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        Path dataFile = Paths.get(IntegrationServerUtil.Companion.getDist(project2) + "/xld-is-data-" + version + "-repository/data.xml", new String[0]);
        return provider.build((InputStream)new FileInputStream(dataFile.toFile()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public final void runImport() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        String dbname = DbUtil.Companion.databaseName(project);
        DbParameters dbDependency = DbUtil.Companion.detectDbDependencies(dbname);
        Triple<String, String, String> dbConfig = this.getConfiguration();
        Properties properties = DbConfigurationUtil.Companion.connectionProperties((String)dbConfig.getFirst(), (String)dbConfig.getSecond());
        String string = dbDependency.getDriverClass();
        if (string == null) {
            string = "";
        }
        Connection driverConnection = DbConfigurationUtil.Companion.createDriverConnection(string, (String)dbConfig.getThird(), properties);
        DatabaseConnection connection = DbConfigurationUtil.Companion.configureConnection(driverConnection, dbDependency);
        try {
            FlatXmlDataSet dataSet = this.configureDataSet();
            DatabaseOperation.CLEAN_INSERT.execute((IDatabaseConnection)connection, (IDataSet)dataSet);
            if (Intrinsics.areEqual((Object)dbname, (Object)"postgres-10")) {
                Project project2 = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                PostgresDbUtil.Companion.resetSequences(project2, driverConnection);
            }
        }
        finally {
            connection.close();
            driverConnection.close();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lai/digital/integration/server/common/tasks/database/ImportDbUnitDataTask$Companion;", "", "<init>", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

