/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.integration.server.deploy.tasks.cluster;

import ai.digital.integration.server.common.constant.ClusterProfileName;
import ai.digital.integration.server.common.constant.TerraformProviderName;
import ai.digital.integration.server.deploy.internals.cluster.DeployClusterUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0007"}, d2={"Lai/digital/integration/server/deploy/tasks/cluster/StartDeployClusterTask;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "launch", "", "Companion", "integration-server-gradle-plugin"})
public class StartDeployClusterTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "startDeployCluster";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public StartDeployClusterTask() {
        String string;
        this.setGroup("Integration Server");
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        String profileName = DeployClusterUtil.Companion.getProfile(project);
        if (Intrinsics.areEqual((Object)profileName, (Object)ClusterProfileName.DOCKER_COMPOSE.getProfileName())) {
            string = "dockerComposeBasedStartDeployCluster";
        } else if (Intrinsics.areEqual((Object)profileName, (Object)ClusterProfileName.OPERATOR.getProfileName())) {
            string = "operatorBasedInstallDeployCluster";
        } else if (Intrinsics.areEqual((Object)profileName, (Object)ClusterProfileName.HELM.getProfileName())) {
            string = "helmBasedInstallDeployCluster";
        } else {
            if (!Intrinsics.areEqual((Object)profileName, (Object)ClusterProfileName.TERRAFORM.getProfileName())) throw new IllegalArgumentException("Provided profile name `" + profileName + "` is not supported. Choose one of " + ArraysKt.joinToString$default((Object[])ClusterProfileName.values(), null, null, null, (int)0, null, null, (int)63, null));
            Project project2 = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            String providerName = DeployClusterUtil.Companion.getTerraformProvider(project2);
            if (!Intrinsics.areEqual((Object)providerName, (Object)TerraformProviderName.AWS_EKS.getProviderName())) throw new IllegalArgumentException("Provided terraform provider name `" + providerName + "` is not supported. Choose one of " + ArraysKt.joinToString$default((Object[])TerraformProviderName.values(), null, null, null, (int)0, null, null, (int)63, null));
            string = "terraformBasedAwsEksStartDeployCluster";
        }
        List dependencies = CollectionsKt.listOf((Object)string);
        Object[] objectArray = new Object[]{dependencies};
        this.dependsOn(objectArray);
        objectArray = new Object[]{"runCli"};
        this.finalizedBy(objectArray);
    }

    @TaskAction
    public final void launch() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        String profileName = DeployClusterUtil.Companion.getProfile(project);
        this.getProject().getLogger().lifecycle("Deploy Cluster profile " + profileName + " has started.");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lai/digital/integration/server/deploy/tasks/cluster/StartDeployClusterTask$Companion;", "", "<init>", "()V", "NAME", "", "integration-server-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

